/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.jdbc.dialect;

import java.util.Collection;
import org.apache.ignite.cache.store.jdbc.dialect.BasicJdbcDialect;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;

public class MySQLDialect
extends BasicJdbcDialect {
    private static final long serialVersionUID = 0L;

    public MySQLDialect() {
        this.fetchSize = Integer.MIN_VALUE;
    }

    @Override
    public String escape(String ident) {
        return "`" + ident + "`";
    }

    @Override
    public String loadCacheSelectRangeQuery(String fullTblName, Collection<String> keyCols) {
        String cols = MySQLDialect.mkString(keyCols, ",");
        return String.format("SELECT %s FROM (SELECT %s, @rownum := @rownum + 1 AS rn FROM %s, (SELECT @rownum := 0) r ORDER BY %s) as r WHERE mod(rn, ?) = 0", cols, cols, fullTblName, cols);
    }

    @Override
    public boolean hasMerge() {
        return true;
    }

    @Override
    public String mergeQuery(String fullTblName, Collection<String> keyCols, Collection<String> uniqCols) {
        Collection<String> cols = F.concat(false, keyCols, uniqCols);
        String updPart = MySQLDialect.mkString(uniqCols, new C1<String, String>(){

            @Override
            public String apply(String col) {
                return String.format("%s = VALUES(%s)", col, col);
            }
        }, "", ", ", "");
        return String.format("INSERT INTO %s (%s) VALUES (%s) ON DUPLICATE KEY UPDATE %s", fullTblName, MySQLDialect.mkString(cols, ", "), MySQLDialect.repeat("?", cols.size(), "", ",", ""), updPart);
    }
}

