/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.types;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.migrationtools.types.InspectedField;
import org.apache.ignite.migrationtools.types.InspectedFieldType;
import org.apache.ignite3.catalog.ColumnType;
import org.apache.ignite3.table.mapper.Mapper;
import org.jetbrains.annotations.Nullable;

public class TypeInspector {
    private static final Map<Class<?>, ColumnType<?>> COL_TYPE_REF;

    public static List<InspectedField> inspectType(Class<?> type) {
        Class rootType = ClassUtils.primitiveToWrapper(type);
        String rootTypeName = rootType.getName();
        if (rootType.isArray() || Collection.class.isAssignableFrom(rootType)) {
            return Collections.singletonList(InspectedField.forUnnamed(rootTypeName, InspectedFieldType.ARRAY));
        }
        if (TypeInspector.isPrimitiveType(rootType)) {
            return Collections.singletonList(InspectedField.forUnnamed(rootTypeName, InspectedFieldType.PRIMITIVE));
        }
        Field[] fields = rootType.getDeclaredFields();
        ArrayList<InspectedField> ret = new ArrayList<InspectedField>(fields.length);
        for (Field field : fields) {
            if (!TypeInspector.shouldPersistField(field)) continue;
            @Nullable QuerySqlField annotation = field.getAnnotation(QuerySqlField.class);
            boolean hasAnnotation = annotation != null;
            Class<?> origFieldType = field.getType();
            Class wrappedFieldType = ClassUtils.primitiveToWrapper(origFieldType);
            boolean nullable = !origFieldType.isPrimitive();
            InspectedFieldType inspectedFieldType = TypeInspector.isPrimitiveType(wrappedFieldType) ? InspectedFieldType.POJO_ATTRIBUTE : InspectedFieldType.NESTED_POJO_ATTRIBUTE;
            InspectedField inspectedField = InspectedField.forNamed(field.getName(), wrappedFieldType.getName(), inspectedFieldType, nullable, hasAnnotation);
            ret.add(inspectedField);
        }
        return ret;
    }

    private static boolean isPrimitiveType(Class<?> type) {
        return type.isEnum() || Mapper.nativelySupported(type) || COL_TYPE_REF.containsKey(type);
    }

    private static boolean shouldPersistField(Field field) {
        int mods = field.getModifiers();
        return !Modifier.isStatic(mods) && !Modifier.isTransient(mods);
    }

    static {
        try {
            COL_TYPE_REF = (Map)FieldUtils.readDeclaredStaticField(ColumnType.class, (String)"TYPES", (boolean)true);
            COL_TYPE_REF.remove(java.util.Date.class);
            Constructor constructor = ColumnType.class.getDeclaredConstructor(Class.class, String.class);
            constructor.setAccessible(true);
            constructor.newInstance(Character.class, "CHAR");
            constructor.newInstance(BitSet.class, "VARBINARY");
            constructor.newInstance(LocalTime.class, "TIME");
            constructor.newInstance(LocalDate.class, "DATE");
            constructor.newInstance(LocalDateTime.class, "TIMESTAMP");
            constructor.newInstance(Instant.class, "TIMESTAMP");
            constructor.newInstance(java.util.Date.class, "TIMESTAMP");
            constructor.newInstance(Enum.class, "VARCHAR");
            constructor.newInstance(Date.class, "DATE");
            constructor.newInstance(Time.class, "TIME");
            constructor.newInstance(Timestamp.class, "TIMESTAMP");
            constructor.newInstance(Collection.class, "VARBINARY");
            constructor.newInstance(List.class, "VARBINARY");
            constructor.newInstance(Set.class, "VARBINARY");
            constructor.newInstance(boolean[].class, "VARBINARY");
            constructor.newInstance(char[].class, "VARBINARY");
            constructor.newInstance(short[].class, "VARBINARY");
            constructor.newInstance(int[].class, "VARBINARY");
            constructor.newInstance(long[].class, "VARBINARY");
            constructor.newInstance(float[].class, "VARBINARY");
            constructor.newInstance(double[].class, "VARBINARY");
            constructor.newInstance(String[].class, "VARBINARY");
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

