/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.rel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.ignite3.internal.lang.Debuggable;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.lang.IgniteStringBuilder;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.partition.replicator.network.replication.BinaryTupleMessage;
import org.apache.ignite3.internal.sql.engine.NodeLeftException;
import org.apache.ignite3.internal.sql.engine.exec.ExchangeService;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.MailboxRegistry;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.SharedState;
import org.apache.ignite3.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite3.internal.sql.engine.exec.rel.Mailbox;
import org.apache.ignite3.internal.sql.engine.exec.rel.Node;
import org.apache.ignite3.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class Inbox<RowT>
extends AbstractNode<RowT>
implements Mailbox<RowT>,
SingleNode<RowT> {
    private final ExchangeService exchange;
    private final MailboxRegistry registry;
    private final long exchangeId;
    private final long srcFragmentId;
    private final Collection<String> srcNodeNames;
    @Nullable
    private final Comparator<RowT> comp;
    private final Map<String, RemoteSource<RowT>> perNodeBuffers;
    private final RowHandler.RowFactory<RowT> rowFactory;
    @Nullable
    private List<RemoteSource<RowT>> remoteSources;
    private int requested;
    private boolean inLoop;

    public Inbox(ExecutionContext<RowT> ctx, ExchangeService exchange, MailboxRegistry registry, Collection<String> srcNodeNames, @Nullable Comparator<RowT> comp, RowHandler.RowFactory<RowT> rowFactory, long exchangeId, long srcFragmentId) {
        super(ctx);
        assert (!CollectionUtils.nullOrEmpty(srcNodeNames));
        this.exchange = exchange;
        this.registry = registry;
        this.srcNodeNames = srcNodeNames;
        this.comp = comp;
        this.rowFactory = rowFactory;
        this.srcFragmentId = srcFragmentId;
        this.exchangeId = exchangeId;
        HashMap sources = new HashMap();
        for (String nodeName : srcNodeNames) {
            sources.put(nodeName, new RemoteSource((cnt, state) -> this.requestBatches(nodeName, cnt, state)));
        }
        this.perNodeBuffers = Map.copyOf(sources);
    }

    @Override
    public long exchangeId() {
        return this.exchangeId;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (rowsCnt > 0 && this.requested == 0);
        this.requested = rowsCnt;
        if (!this.inLoop) {
            this.execute(this::push);
        }
    }

    @Override
    public void closeInternal() {
        super.closeInternal();
        this.registry.unregister(this);
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void register(List<Node<RowT>> sources) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void rewindInternal() {
        this.remoteSources = null;
        this.requested = 0;
        for (String nodeName : this.srcNodeNames) {
            RemoteSource<RowT> source = this.perNodeBuffers.get(nodeName);
            assert (source != null);
            source.reset(this.context().sharedState());
        }
    }

    @Override
    @TestOnly
    public void dumpState(IgniteStringBuilder writer, String indent) {
        writer.app(indent).app("class=").app(this.getClass().getSimpleName()).app(", requested=").app(this.requested).nl();
        String childIndent = Debuggable.childIndentation(indent);
        for (String nodeName : this.srcNodeNames) {
            RemoteSource<RowT> source = this.perNodeBuffers.get(nodeName);
            writer.app(childIndent).app("class=" + source.getClass().getSimpleName()).app(", nodeName=").app(nodeName).app(", state=").app((Object)source.state).nl();
        }
    }

    public void onBatchReceived(String srcNodeName, int batchId, boolean last, List<BinaryTupleMessage> rows) throws Exception {
        this.checkState();
        RemoteSource source = this.perNodeBuffers.get(srcNodeName);
        boolean waitingBefore = source.check() == RemoteSource.State.WAITING;
        ArrayList<RowT> rows0 = new ArrayList<RowT>(rows.size());
        for (BinaryTupleMessage row : rows) {
            rows0.add(this.rowFactory.create(row.asBinaryTuple()));
        }
        source.onBatchReceived(batchId, last, rows0);
        if (this.requested > 0 && waitingBefore && source.check() != RemoteSource.State.WAITING) {
            this.push();
        }
    }

    private void push() throws Exception {
        if (this.remoteSources == null) {
            this.remoteSources = new ArrayList<RemoteSource<RowT>>(this.srcNodeNames.size());
            for (String nodeName : this.srcNodeNames) {
                this.remoteSources.add(this.perNodeBuffers.get(nodeName));
            }
        }
        if (this.comp != null) {
            this.pushOrdered();
        } else {
            this.pushUnordered();
        }
    }

    private boolean checkAllBuffsReady(Iterator<RemoteSource<RowT>> it) {
        block5: while (it.hasNext()) {
            RemoteSource<RowT> buf = it.next();
            RemoteSource.State state = buf.check();
            switch (state) {
                case READY: {
                    continue block5;
                }
                case END: {
                    it.remove();
                    continue block5;
                }
                case WAITING: {
                    return false;
                }
            }
            throw Util.unexpected((Enum)state);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushOrdered() throws Exception {
        PriorityQueue heap;
        block17: {
            RemoteSource.State state;
            if (!this.checkAllBuffsReady(this.remoteSources.iterator())) {
                for (RemoteSource<RowT> remote : this.remoteSources) {
                    remote.requestNextBatchIfNeeded();
                }
                return;
            }
            assert (this.comp != null);
            heap = new PriorityQueue(Math.max(this.remoteSources.size(), 1), Map.Entry.comparingByKey(this.comp));
            for (RemoteSource<RowT> buf : this.remoteSources) {
                state = buf.check();
                if (state == RemoteSource.State.READY) {
                    heap.offer(Pair.of(buf.peek(), buf));
                    continue;
                }
                throw new AssertionError((Object)("Unexpected buffer state: " + state));
            }
            int processed = 0;
            this.inLoop = true;
            try {
                while (this.requested > 0 && !heap.isEmpty()) {
                    RemoteSource source = (RemoteSource)((Pair)heap.poll()).right;
                    --this.requested;
                    this.downstream().push(source.remove());
                    state = source.check();
                    switch (state) {
                        case END: {
                            this.remoteSources.remove(source);
                            break;
                        }
                        case READY: {
                            heap.offer(Pair.of(source.peek(), (Object)source));
                            break;
                        }
                        case WAITING: {
                            break block17;
                        }
                        default: {
                            throw Util.unexpected((Enum)state);
                        }
                    }
                    if (processed++ < this.inBufSize) continue;
                    this.execute(this::push);
                    return;
                }
            }
            finally {
                this.inLoop = false;
            }
        }
        for (RemoteSource<RowT> remote : this.remoteSources) {
            remote.requestNextBatchIfNeeded();
        }
        if (this.requested > 0 && this.remoteSources.isEmpty() && heap.isEmpty()) {
            this.requested = 0;
            this.downstream().end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushUnordered() throws Exception {
        int idx = 0;
        int noProgress = 0;
        int processed = 0;
        this.inLoop = true;
        try {
            while (this.requested > 0 && !this.remoteSources.isEmpty()) {
                RemoteSource<RowT> source = this.remoteSources.get(idx);
                switch (source.check()) {
                    case END: {
                        this.remoteSources.remove(idx);
                        break;
                    }
                    case READY: {
                        noProgress = 0;
                        --this.requested;
                        this.downstream().push(source.remove());
                        break;
                    }
                    case WAITING: {
                        ++noProgress;
                        ++idx;
                        break;
                    }
                }
                if (noProgress >= this.remoteSources.size()) {
                    break;
                }
                if (idx == this.remoteSources.size()) {
                    idx = 0;
                }
                if (processed++ < this.inBufSize) continue;
                this.execute(this::push);
                return;
            }
        }
        finally {
            this.inLoop = false;
        }
        for (RemoteSource<RowT> source : this.remoteSources) {
            source.requestNextBatchIfNeeded();
        }
        if (this.requested > 0 && this.remoteSources.isEmpty()) {
            this.requested = 0;
            this.downstream().end();
        }
    }

    private void requestBatches(String nodeName, int cnt, @Nullable SharedState state) {
        this.exchange.request(nodeName, this.executionId(), this.srcFragmentId, this.exchangeId, cnt, state).whenComplete((ignored, ex) -> {
            if (ex != null) {
                IgniteInternalException wrapperEx = ExceptionUtils.withCause(IgniteInternalException::new, ErrorGroups.Common.INTERNAL_ERR, "Unable to request next batch: " + ex.getMessage(), ex);
                this.execute(() -> this.onError(wrapperEx));
            }
        });
    }

    public void onNodeLeft(InternalClusterNode node) {
        if (this.srcNodeNames.contains(node.name())) {
            this.execute(() -> this.onNodeLeft0(node.name()));
        }
    }

    private void onNodeLeft0(String nodeName) {
        if (this.perNodeBuffers.get(nodeName).check() != RemoteSource.State.END) {
            throw new NodeLeftException(nodeName);
        }
    }

    static final class RemoteSource<RowT> {
        private final PriorityQueue<Batch<RowT>> batches = new PriorityQueue(4);
        private final BatchRequester batchRequester;
        private State state = State.WAITING;
        private int lastEnqueued = -1;
        private int lastRequested = -1;
        @Nullable
        private Batch<RowT> curr = null;
        @Nullable
        private SharedState sharedStateHolder = null;

        private RemoteSource(BatchRequester batchRequester) {
            this.batchRequester = batchRequester;
        }

        void reset(SharedState state) {
            this.sharedStateHolder = state;
            this.batches.clear();
            this.lastEnqueued = this.lastRequested;
            this.state = State.WAITING;
            this.curr = null;
        }

        void onBatchReceived(int id, boolean last, List<RowT> rows) {
            if (id <= this.lastEnqueued) {
                return;
            }
            this.batches.offer(new Batch<RowT>(id, last, rows));
            if (this.state == State.WAITING && id == this.lastEnqueued + 1) {
                this.advanceBatch();
            }
        }

        void requestNextBatchIfNeeded() throws IgniteInternalCheckedException {
            int currentInFlightCount;
            int maxInFlightCount = Math.max(4, 1);
            if (maxInFlightCount / 2 >= (currentInFlightCount = this.lastRequested - this.lastEnqueued)) {
                int countOfBatches = maxInFlightCount - currentInFlightCount;
                this.lastRequested += countOfBatches;
                this.batchRequester.request(countOfBatches, this.sharedStateHolder);
                this.sharedStateHolder = null;
            }
        }

        State check() {
            return this.state;
        }

        RowT peek() {
            assert (this.state == State.READY);
            assert (this.curr != null);
            return this.curr.rows.get(this.curr.idx);
        }

        RowT remove() {
            assert (this.state == State.READY);
            assert (this.curr != null);
            RowT row = this.curr.rows.set(this.curr.idx++, null);
            if (this.curr.idx == this.curr.rows.size()) {
                if (this.curr.last) {
                    this.state = State.END;
                } else {
                    this.advanceBatch();
                }
            }
            return row;
        }

        private boolean hasNextBatch() {
            return !this.batches.isEmpty() && this.batches.peek().batchId == this.lastEnqueued + 1;
        }

        private void advanceBatch() {
            if (!this.hasNextBatch()) {
                this.state = State.WAITING;
                return;
            }
            this.curr = this.batches.poll();
            assert (this.curr != null);
            this.state = this.curr.rows.isEmpty() ? State.END : State.READY;
            this.lastEnqueued = this.curr.batchId;
        }

        static enum State {
            END,
            READY,
            WAITING;

        }

        @FunctionalInterface
        private static interface BatchRequester {
            public void request(int var1, @Nullable SharedState var2) throws IgniteInternalCheckedException;
        }
    }

    private static final class Batch<RowT>
    implements Comparable<Batch<RowT>> {
        private final int batchId;
        private final boolean last;
        private final List<RowT> rows;
        private int idx;

        private Batch(int batchId, boolean last, List<RowT> rows) {
            this.batchId = batchId;
            this.last = last;
            this.rows = rows;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Batch batch = (Batch)o;
            return this.batchId == batch.batchId;
        }

        public int hashCode() {
            return this.batchId;
        }

        @Override
        public int compareTo(Batch<RowT> o) {
            return Integer.compare(this.batchId, o.batchId);
        }
    }
}

