/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.paging;

import com.azure.core.util.IterableStream;
import com.azure.core.util.paging.ContinuablePage;
import com.azure.core.util.paging.ContinuablePagedByItemIterable;
import com.azure.core.util.paging.ContinuablePagedByPageIterable;
import com.azure.core.util.paging.ContinuablePagedFlux;
import com.azure.core.util.paging.ContinuablePagedFluxCore;
import java.util.Iterator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class ContinuablePagedIterable<C, T, P extends ContinuablePage<C, T>>
extends IterableStream<T> {
    private final ContinuablePagedFlux<C, T, P> pagedFlux;
    private final int batchSize;

    public ContinuablePagedIterable(ContinuablePagedFlux<C, T, P> pagedFlux) {
        this(pagedFlux, 1);
    }

    public ContinuablePagedIterable(ContinuablePagedFlux<C, T, P> pagedFlux, int batchSize) {
        super(pagedFlux);
        this.pagedFlux = pagedFlux;
        this.batchSize = batchSize;
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(this.iterableByItemInternal().spliterator(), false);
    }

    public Stream<P> streamByPage() {
        return this.streamByPageInternal(null, null, () -> this.pagedFlux.byPage().toStream(this.batchSize));
    }

    public Stream<P> streamByPage(C continuationToken) {
        return this.streamByPageInternal(continuationToken, null, () -> this.pagedFlux.byPage(continuationToken).toStream(this.batchSize));
    }

    public Stream<P> streamByPage(int preferredPageSize) {
        return this.streamByPageInternal(null, preferredPageSize, () -> this.pagedFlux.byPage(preferredPageSize).toStream(this.batchSize));
    }

    public Stream<P> streamByPage(C continuationToken, int preferredPageSize) {
        return this.streamByPageInternal(continuationToken, preferredPageSize, () -> this.pagedFlux.byPage(continuationToken, preferredPageSize).toStream(this.batchSize));
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterableByItemInternal().iterator();
    }

    public Iterable<P> iterableByPage() {
        return this.iterableByPageInternal(null, null, () -> this.pagedFlux.byPage().toIterable(this.batchSize));
    }

    public Iterable<P> iterableByPage(C continuationToken) {
        return this.iterableByPageInternal(continuationToken, null, () -> this.pagedFlux.byPage(continuationToken).toIterable(this.batchSize));
    }

    public Iterable<P> iterableByPage(int preferredPageSize) {
        return this.iterableByPageInternal(null, preferredPageSize, () -> this.pagedFlux.byPage(preferredPageSize).toIterable(this.batchSize));
    }

    public Iterable<P> iterableByPage(C continuationToken, int preferredPageSize) {
        return this.iterableByPageInternal(continuationToken, preferredPageSize, () -> this.pagedFlux.byPage(continuationToken, preferredPageSize).toIterable(this.batchSize));
    }

    private Stream<P> streamByPageInternal(C continuationToken, Integer preferredPageSize, Supplier<Stream<P>> nonPagedFluxCoreIterableSupplier) {
        if (this.pagedFlux instanceof ContinuablePagedFluxCore) {
            return StreamSupport.stream(this.iterableByPageInternal(continuationToken, preferredPageSize, null).spliterator(), false);
        }
        return nonPagedFluxCoreIterableSupplier.get();
    }

    private Iterable<P> iterableByPageInternal(C continuationToken, Integer preferredPageSize, Supplier<Iterable<P>> nonPagedFluxCoreIterableSupplier) {
        if (this.pagedFlux instanceof ContinuablePagedFluxCore) {
            ContinuablePagedFluxCore pagedFluxCore = (ContinuablePagedFluxCore)this.pagedFlux;
            return new ContinuablePagedByPageIterable(pagedFluxCore.pageRetrieverProvider.get(), continuationToken, preferredPageSize);
        }
        return nonPagedFluxCoreIterableSupplier.get();
    }

    private Iterable<T> iterableByItemInternal() {
        if (this.pagedFlux instanceof ContinuablePagedFluxCore) {
            ContinuablePagedFluxCore pagedFluxCore = (ContinuablePagedFluxCore)this.pagedFlux;
            return new ContinuablePagedByItemIterable(pagedFluxCore.pageRetrieverProvider.get(), null, null);
        }
        return this.pagedFlux.toIterable(this.batchSize);
    }
}

