/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.binary.BinaryFieldAccessor;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class BinaryFieldMetadata
implements Externalizable {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude(sensitive=true)
    private int fieldId;
    @GridToStringInclude(sensitive=true)
    private int typeId;

    public BinaryFieldMetadata() {
    }

    public BinaryFieldMetadata(int typeId, int fieldId) {
        this.typeId = typeId;
        this.fieldId = fieldId;
    }

    public BinaryFieldMetadata(BinaryFieldAccessor accessor) {
        this.typeId = accessor.mode().typeId();
        this.fieldId = accessor.id;
    }

    public int fieldId() {
        return this.fieldId;
    }

    public int typeId() {
        return this.typeId;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeTo(out);
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeInt(this.typeId);
        out.writeInt(this.fieldId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readFrom(in);
    }

    public void readFrom(DataInput in) throws IOException {
        this.typeId = in.readInt();
        this.fieldId = in.readInt();
    }

    public String toString() {
        return S.toString(BinaryFieldMetadata.class, this);
    }
}

