/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc.txlog;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageInitRecord;
import org.apache.ignite.internal.processors.cache.CacheDiagnosticManager;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.mvcc.txlog.TxKey;
import org.apache.ignite.internal.processors.cache.mvcc.txlog.TxLogIO;
import org.apache.ignite.internal.processors.cache.mvcc.txlog.TxLogTree;
import org.apache.ignite.internal.processors.cache.mvcc.txlog.TxRow;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageMetaIOV2;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseListImpl;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageLockListener;
import org.apache.ignite.internal.util.IgniteTree;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class TxLog
implements CheckpointListener {
    public static final String TX_LOG_CACHE_NAME = "TxLog";
    public static final int TX_LOG_CACHE_ID = CU.cacheId("TxLog");
    private static final TxKey LOWEST = new TxKey(0L, 0L);
    private final IgniteCacheDatabaseSharedManager mgr;
    private ReuseListImpl reuseList;
    private TxLogTree tree;
    private ConcurrentMap<TxKey, Sync> keyMap = new ConcurrentHashMap<TxKey, Sync>();

    public TxLog(GridKernalContext ctx, IgniteCacheDatabaseSharedManager mgr) throws IgniteCheckedException {
        this.mgr = mgr;
        this.init(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(GridKernalContext ctx) throws IgniteCheckedException {
        String txLogName = "TxLog##Tree";
        CacheDiagnosticManager diagnosticMgr = ctx.cache().context().diagnostic();
        PageLockListener txLogLockLsnr = diagnosticMgr.pageLockTracker().createPageLockTracker(txLogName);
        DataRegion txLogDataRegion = this.mgr.dataRegion(TX_LOG_CACHE_NAME);
        if (CU.isPersistenceEnabled(ctx.config())) {
            String txLogReuseListName = "TxLog##ReuseList";
            PageLockListener txLogReuseListLockLsnr = diagnosticMgr.pageLockTracker().createPageLockTracker(txLogReuseListName);
            this.mgr.checkpointReadLock();
            try {
                long reuseListRoot;
                long treeRoot;
                IgniteWriteAheadLogManager wal = ctx.cache().context().wal();
                PageMemoryEx pageMemory = (PageMemoryEx)txLogDataRegion.pageMemory();
                long metaId = PageMemory.META_PAGE_ID;
                long metaPage = pageMemory.acquirePage(TX_LOG_CACHE_ID, metaId);
                boolean isNew = false;
                try {
                    long pageAddr = pageMemory.writeLock(TX_LOG_CACHE_ID, metaId, metaPage);
                    try {
                        if (PageIO.getType(pageAddr) != 11) {
                            PageMetaIO io = (PageMetaIO)PageMetaIOV2.VERSIONS.latest();
                            io.initNewPage(pageAddr, metaId, pageMemory.pageSize());
                            treeRoot = pageMemory.allocatePage(TX_LOG_CACHE_ID, 65535, (byte)2);
                            reuseListRoot = pageMemory.allocatePage(TX_LOG_CACHE_ID, 65535, (byte)2);
                            assert (PageIdUtils.flag(treeRoot) == 2);
                            assert (PageIdUtils.flag(reuseListRoot) == 2);
                            io.setTreeRoot(pageAddr, treeRoot);
                            io.setReuseListRoot(pageAddr, reuseListRoot);
                            if (PageHandler.isWalDeltaRecordNeeded(pageMemory, TX_LOG_CACHE_ID, metaId, metaPage, wal, null)) assert (io.getType() == 11);
                            wal.log(new MetaPageInitRecord(TX_LOG_CACHE_ID, metaId, io.getType(), io.getVersion(), treeRoot, reuseListRoot));
                            isNew = true;
                        } else {
                            PageMetaIO io = (PageMetaIO)PageIO.getPageIO(pageAddr);
                            treeRoot = io.getTreeRoot(pageAddr);
                            reuseListRoot = io.getReuseListRoot(pageAddr);
                            assert (PageIdUtils.flag(treeRoot) == 2) : U.hexLong(treeRoot) + ", TX_LOG_CACHE_ID=" + TX_LOG_CACHE_ID;
                            assert (PageIdUtils.flag(reuseListRoot) == 2) : U.hexLong(reuseListRoot) + ", TX_LOG_CACHE_ID=" + TX_LOG_CACHE_ID;
                        }
                    }
                    finally {
                        pageMemory.writeUnlock(TX_LOG_CACHE_ID, metaId, metaPage, null, isNew);
                    }
                }
                finally {
                    pageMemory.releasePage(TX_LOG_CACHE_ID, metaId, metaPage);
                }
                this.reuseList = new ReuseListImpl(TX_LOG_CACHE_ID, TX_LOG_CACHE_NAME, pageMemory, wal, reuseListRoot, isNew, txLogReuseListLockLsnr, ctx, null, 2);
                this.tree = new TxLogTree(TX_LOG_CACHE_NAME, pageMemory, wal, treeRoot, this.reuseList, ctx.failure(), isNew, txLogLockLsnr);
                ((GridCacheDatabaseSharedManager)this.mgr).addCheckpointListener(this, txLogDataRegion);
            }
            finally {
                this.mgr.checkpointReadUnlock();
            }
        }
        PageMemory pageMemory = txLogDataRegion.pageMemory();
        ReuseList reuseList1 = this.mgr.reuseList(TX_LOG_CACHE_NAME);
        long treeRoot = reuseList1.takeRecycledPage();
        if (treeRoot == 0L) {
            treeRoot = pageMemory.allocatePage(TX_LOG_CACHE_ID, 65535, (byte)2);
        }
        this.tree = new TxLogTree(txLogName, pageMemory, null, treeRoot, reuseList1, ctx.failure(), true, txLogLockLsnr);
    }

    @Override
    public void onMarkCheckpointBegin(CheckpointListener.Context ctx) throws IgniteCheckedException {
        this.saveReuseListMetadata(ctx);
    }

    @Override
    public void beforeCheckpointBegin(CheckpointListener.Context ctx) throws IgniteCheckedException {
        this.saveReuseListMetadata(ctx);
    }

    private void saveReuseListMetadata(CheckpointListener.Context ctx) throws IgniteCheckedException {
        Executor executor = ctx.executor();
        if (executor == null) {
            this.reuseList.saveMetadata(IoStatisticsHolderNoOp.INSTANCE);
        } else {
            executor.execute(() -> {
                try {
                    this.reuseList.saveMetadata(IoStatisticsHolderNoOp.INSTANCE);
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            });
        }
    }

    @Override
    public void onCheckpointBegin(CheckpointListener.Context ctx) throws IgniteCheckedException {
    }

    public byte get(long major, long minor) throws IgniteCheckedException {
        return this.get(new TxKey(major, minor));
    }

    public byte get(TxKey key) throws IgniteCheckedException {
        TxRow row = (TxRow)this.tree.findOne(key);
        return row == null ? (byte)0 : row.state();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(TxKey key, byte state, boolean primary) throws IgniteCheckedException {
        assert (this.mgr.checkpointLockIsHeldByThread());
        Sync sync = this.syncObject(key);
        try {
            Sync sync2 = sync;
            synchronized (sync2) {
                this.tree.invoke(key, null, new TxLogUpdateClosure(key.major(), key.minor(), state, primary));
            }
        }
        finally {
            this.evict(key, sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUntil(long major, long minor) throws IgniteCheckedException {
        TraversingClosure clo = new TraversingClosure(major, minor);
        this.tree.iterate(LOWEST, clo, clo);
        if (clo.rows != null) {
            this.mgr.checkpointReadLock();
            try {
                for (TxKey row : clo.rows) {
                    this.remove(row);
                }
            }
            finally {
                this.mgr.checkpointReadUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(TxKey key) throws IgniteCheckedException {
        Sync sync = this.syncObject(key);
        try {
            Sync sync2 = sync;
            synchronized (sync2) {
                this.tree.removex(key);
            }
        }
        finally {
            this.evict(key, sync);
        }
    }

    private Sync syncObject(TxKey key) {
        Sync sync = (Sync)this.keyMap.get(key);
        while (true) {
            if (sync == null) {
                sync = new Sync();
                Sync old = this.keyMap.putIfAbsent(key, sync);
                if (old == null) {
                    return sync;
                }
                sync = old;
                continue;
            }
            int cntr = sync.counter;
            while (cntr > 0) {
                if (sync.casCounter(cntr, cntr + 1)) {
                    return sync;
                }
                cntr = sync.counter;
            }
            sync = (Sync)this.keyMap.get(key);
        }
    }

    private void evict(TxKey key, Sync sync) {
        assert (sync != null);
        int cntr = sync.counter;
        while (true) {
            assert (cntr > 0);
            if (sync.casCounter(cntr, cntr - 1)) break;
            cntr = sync.counter;
        }
        if (cntr == 1) {
            boolean removed = this.keyMap.remove(key, sync);
            assert (removed);
        }
    }

    private static final class TxLogUpdateClosure
    implements IgniteTree.InvokeClosure<TxRow> {
        private final long major;
        private final long minor;
        private final byte newState;
        private final boolean primary;
        private IgniteTree.OperationType treeOp;

        TxLogUpdateClosure(long major, long minor, byte newState, boolean primary) {
            assert (MvccUtils.mvccVersionIsValid(major, minor) && newState != 0);
            this.major = major;
            this.minor = minor;
            this.newState = newState;
            this.primary = primary;
        }

        @Override
        public void call(@Nullable TxRow row) {
            if (row == null) {
                this.valid();
                return;
            }
            byte currState = row.state();
            switch (currState) {
                case 0: {
                    this.checkNa(currState);
                    break;
                }
                case 1: {
                    this.checkPrepared(currState);
                    break;
                }
                case 3: {
                    this.checkCommitted(currState);
                    break;
                }
                case 2: {
                    this.checkAborted(currState);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown tx state: " + currState);
                }
            }
        }

        @Override
        public TxRow newRow() {
            return this.treeOp == IgniteTree.OperationType.PUT ? new TxRow(this.major, this.minor, this.newState) : null;
        }

        @Override
        public IgniteTree.OperationType operationType() {
            return this.treeOp;
        }

        private void checkNa(byte currState) {
            switch (this.newState) {
                case 1: 
                case 2: {
                    this.valid();
                    break;
                }
                case 3: {
                    this.invalid(currState);
                    break;
                }
                default: {
                    this.invalid(currState);
                }
            }
        }

        private void checkPrepared(byte currState) {
            switch (this.newState) {
                case 2: 
                case 3: {
                    this.valid();
                    break;
                }
                case 1: {
                    this.ignore();
                    break;
                }
                default: {
                    this.invalid(currState);
                }
            }
        }

        private void checkCommitted(byte currState) {
            switch (this.newState) {
                case 3: {
                    this.ignore();
                    break;
                }
                case 1: {
                    if (this.primary) {
                        this.ignore();
                        break;
                    }
                    this.invalid(currState);
                    break;
                }
                default: {
                    this.invalid(currState);
                }
            }
        }

        private void checkAborted(byte currState) {
            switch (this.newState) {
                case 2: {
                    this.ignore();
                    break;
                }
                case 1: {
                    if (this.primary) {
                        this.ignore();
                        break;
                    }
                    this.invalid(currState);
                    break;
                }
                default: {
                    this.invalid(currState);
                }
            }
        }

        private void valid() {
            assert (this.treeOp == null);
            this.treeOp = IgniteTree.OperationType.PUT;
        }

        private void invalid(byte currState) {
            assert (this.treeOp == null);
            throw new IllegalStateException("Unexpected new transaction state. [currState=" + currState + ", newState=" + this.newState + ", cntr=" + this.minor + ']');
        }

        private void ignore() {
            assert (this.treeOp == null);
            this.treeOp = IgniteTree.OperationType.NOOP;
        }
    }

    private static class Sync {
        private static final AtomicIntegerFieldUpdater<Sync> UPD = AtomicIntegerFieldUpdater.newUpdater(Sync.class, "counter");
        volatile int counter = 1;

        private Sync() {
        }

        boolean casCounter(int old, int upd) {
            return UPD.compareAndSet(this, old, upd);
        }
    }

    private static class TraversingClosure
    extends TxKey
    implements BPlusTree.TreeRowClosure<TxKey, TxRow> {
        private List<TxKey> rows;

        TraversingClosure(long major, long minor) {
            super(major, minor);
        }

        @Override
        public boolean apply(BPlusTree<TxKey, TxRow> tree, BPlusIO<TxKey> io, long pageAddr, int idx) throws IgniteCheckedException {
            if (this.rows == null) {
                this.rows = new ArrayList<TxKey>();
            }
            TxLogIO logIO = (TxLogIO)((Object)io);
            int offset = io.offset(idx);
            this.rows.add(new TxKey(logIO.getMajor(pageAddr, offset), logIO.getMinor(pageAddr, offset)));
            return true;
        }
    }
}

