/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.persistence.CorruptedPersistenceException;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTreeRuntimeException;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.jetbrains.annotations.Nullable;

public class CorruptedTreeException
extends IgniteCheckedException
implements CorruptedPersistenceException {
    private static final long serialVersionUID = 0L;
    private final T2<Integer, Long>[] pages;

    public CorruptedTreeException(String msg, @Nullable Throwable cause, int grpId, String grpName, long ... pageIds) {
        this(msg, null, null, grpName, cause, CorruptedTreeException.toPagesArray(grpId, pageIds));
    }

    public CorruptedTreeException(String msg, @Nullable Throwable cause, int grpId, String grpName, String cacheName, String indexName, long ... pageIds) {
        this(msg, cacheName, indexName, grpName, cause, CorruptedTreeException.toPagesArray(grpId, pageIds));
    }

    public CorruptedTreeException(String msg, String cacheName, String indexName, String grpName, @Nullable Throwable cause, T2<Integer, Long> ... pages) {
        super(CorruptedTreeException.getMsg(msg, cacheName, indexName, grpName, pages), cause);
        this.pages = CorruptedTreeException.expandPagesArray(pages, cause);
    }

    private static T2<Integer, Long>[] toPagesArray(int grpId, long[] pageIds) {
        T2[] res = new T2[pageIds.length];
        for (int i = 0; i < pageIds.length; ++i) {
            res[i] = new T2<Integer, Long>(grpId, pageIds[i]);
        }
        return res;
    }

    private static T2<Integer, Long>[] expandPagesArray(T2<Integer, Long>[] pages, Throwable cause) {
        HashSet<T2<Integer, Long>> res = new HashSet<T2<Integer, Long>>(Arrays.asList(pages));
        BPlusTreeRuntimeException treeRuntimeException = X.cause(cause, BPlusTreeRuntimeException.class);
        if (treeRuntimeException != null) {
            res.addAll(treeRuntimeException.pages());
        }
        Set partMetaPages = res.stream().map(page -> {
            int grpId = (Integer)page.get1();
            int partId = PageIdUtils.partId((Long)page.get2());
            long partMetaPageId = PageIdUtils.pageId(partId, (byte)1, 0);
            return new T2<Integer, Long>(grpId, partMetaPageId);
        }).collect(Collectors.toSet());
        res.addAll(partMetaPages);
        return res.toArray(new T2[0]);
    }

    private static String getMsg(String msg, String cacheName, String indexName, String grpName, T2<Integer, Long> ... pages) {
        GridStringBuilder stringBuilder = new GridStringBuilder("B+Tree is corrupted [").a("pages(groupId, pageId)=").a(Arrays.toString(pages));
        if (cacheName != null) {
            stringBuilder.a(", cacheId=").a(CU.cacheId(cacheName)).a(", cacheName=").a(cacheName);
        }
        if (indexName != null) {
            stringBuilder.a(", indexName=").a(indexName);
        }
        if (grpName != null) {
            stringBuilder.a(", groupName=").a(grpName);
        }
        stringBuilder.a(", msg=").a(msg).a("]");
        return stringBuilder.toString();
    }

    public T2<Integer, Long>[] pages() {
        return this.pages;
    }
}

