/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.version;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridCacheVersionManager
extends GridCacheSharedManagerAdapter {
    public static final GridCacheVersion EVICT_VER = new GridCacheVersion(Integer.MAX_VALUE, 0L, 0, 0);
    public static final long TOP_VER_BASE_TIME = 1388520000000L;
    public static final String LAST_DATA_VER = "LastDataVersion";
    protected AtomicLongMetric lastDataVer;
    private final AtomicLong order = new AtomicLong(U.currentTimeMillis());
    private final AtomicLong loadOrder = new AtomicLong(0L);
    private GridCacheVersion startVer;
    private volatile GridCacheVersion last;
    private byte dataCenterId;
    private volatile int offset;
    private volatile GridCacheVersion isolatedStreamerVer;
    private final GridLocalEventListener discoLsnr = new GridLocalEventListener(){

        @Override
        public void onEvent(Event evt) {
            assert (evt.type() == 13);
            DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
            ClusterNode node = GridCacheVersionManager.this.cctx.discovery().node(discoEvt.node().id());
            if (node != null && !node.id().equals(GridCacheVersionManager.this.cctx.localNodeId())) {
                GridCacheVersionManager.this.onReceived(discoEvt.eventNode().id(), node.metrics().getLastDataVersion());
            }
        }
    };

    @Override
    public void start0() throws IgniteCheckedException {
        MetricRegistry sysreg = this.cctx.kernalContext().metric().registry("cache");
        this.lastDataVer = sysreg.longMetric(LAST_DATA_VER, "The latest data version on the node.");
        this.startVer = new GridCacheVersion(0, 0L, 0, this.dataCenterId);
        this.cctx.gridEvents().addLocalEventListener(this.discoLsnr, 13, new int[0]);
    }

    @Override
    protected void stop0(boolean cancel) {
        this.cctx.gridEvents().removeLocalEventListener(this.discoLsnr, 13);
    }

    public void onLocalJoin(long topVer) {
        long startTime = this.cctx.kernalContext().discovery().gridStartTime();
        if (startTime != 0L) {
            this.offset = (int)((startTime - 1388520000000L) / 1000L);
        }
        this.last = new GridCacheVersion(0, this.order.get(), 0, this.dataCenterId);
        this.lastDataVer.value(this.last.order());
        this.isolatedStreamerVer = new GridCacheVersion(1 + this.offset, 0L, 1, this.dataCenterId);
    }

    public void dataCenterId(byte dataCenterId) {
        this.dataCenterId = dataCenterId;
        this.startVer = new GridCacheVersion(0, 0L, 0, dataCenterId);
    }

    public void onReceived(UUID nodeId, GridCacheVersion ver) {
        this.onReceived(nodeId, ver.order());
    }

    public void onReceived(UUID nodeId, long ver) {
        block3: {
            long order;
            if (ver <= 0L) break block3;
            while (ver > (order = this.order.get())) {
                if (!this.order.compareAndSet(order, ver)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Updated version from node [nodeId=" + nodeId + ", ver=" + ver + ']');
                }
                break block3;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Did not update version from node (version has lower order) [nodeId=" + nodeId + ", ver=" + ver + ", curOrder=" + this.order + ']');
            }
        }
    }

    public void onExchange(long rcvOrder) {
        long order;
        while (rcvOrder > (order = this.order.get()) && !this.order.compareAndSet(order, rcvOrder)) {
        }
    }

    public GridCacheVersion onReceivedAndNext(UUID nodeId, GridCacheVersion ver) {
        this.onReceived(nodeId, ver);
        return this.next(ver);
    }

    public GridCacheVersion isolatedStreamerVersion() {
        return this.isolatedStreamerVer;
    }

    public GridCacheVersion next(long topVer) {
        return this.next(topVer + (long)this.offset, this.cctx.localNode().order(), this.dataCenterId);
    }

    public GridCacheVersion next(long topVer, byte dataCenterId) {
        return this.next(topVer + (long)this.offset, this.cctx.localNode().order(), dataCenterId);
    }

    public GridCacheVersion next(GridCacheVersion ver) {
        return this.next(ver.topologyVersion(), this.cctx.localNode().order(), this.dataCenterId);
    }

    public GridCacheVersion nextForLoad() {
        return this.nextForLoad(this.cctx.kernalContext().discovery().topologyVersion() + (long)this.offset, this.cctx.localNode().order(), this.dataCenterId);
    }

    public GridCacheVersion nextForLoad(long topVer) {
        return this.nextForLoad(topVer + (long)this.offset, this.cctx.localNode().order(), this.dataCenterId);
    }

    public GridCacheVersion nextForLoad(GridCacheVersion ver) {
        return this.nextForLoad(ver.topologyVersion(), this.cctx.localNode().order(), this.dataCenterId);
    }

    private GridCacheVersion next(long topVer, long nodeOrder, byte dataCenterId) {
        GridCacheVersion next;
        long ord = this.order.incrementAndGet();
        this.last = next = new GridCacheVersion((int)topVer, ord, (int)nodeOrder, dataCenterId);
        this.lastDataVer.value(ord);
        return next;
    }

    private GridCacheVersion nextForLoad(long topVer, long nodeOrder, byte dataCenterId) {
        GridCacheVersion next;
        long ord = this.loadOrder.incrementAndGet();
        this.last = next = new GridCacheVersion((int)topVer, ord, (int)nodeOrder, dataCenterId);
        this.lastDataVer.value(ord);
        return next;
    }

    public GridCacheVersion last() {
        GridCacheVersion last0 = this.last;
        return new GridCacheVersion(last0.topologyVersion(), this.localOrder(), last0.nodeOrder(), last0.dataCenterId());
    }

    public long localOrder() {
        return this.order.get();
    }

    public GridCacheVersion startVersion() {
        assert (this.startVer != null);
        return this.startVer;
    }

    public boolean isStartVersion(GridCacheVersion ver) {
        return this.startVer.equals(ver);
    }

    public void gridStartTime(long startTime) {
        this.offset = (int)((startTime - 1388520000000L) / 1000L);
        this.isolatedStreamerVer = new GridCacheVersion(1 + this.offset, 0L, 1, this.dataCenterId);
    }
}

