/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.ignite.IgniteException;

public class GridCleaner {
    private static final String PRE_JAVA9_CLEANER_CLASS_NAME = "sun.misc.Cleaner";
    private static final String JAVA9_CLEANER_CLASS_NAME = "java.lang.ref.Cleaner";
    private static final Class<?> cls = GridCleaner.findCleanerClass();
    private static final Object instance;
    private static final Method initMtd;

    private static Class<?> findCleanerClass() {
        Object[] clsNames = new String[]{PRE_JAVA9_CLEANER_CLASS_NAME, JAVA9_CLEANER_CLASS_NAME};
        ClassLoader clsLdr = ClassLoader.getSystemClassLoader();
        for (String string : clsNames) {
            try {
                return Class.forName(string, true, clsLdr);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new IllegalStateException("None of cleaner classes found: " + Arrays.toString(clsNames));
    }

    public static Object create(Object obj, Runnable act) {
        try {
            return initMtd.invoke(instance, obj, act);
        }
        catch (ReflectiveOperationException e) {
            throw new IgniteException(e);
        }
    }

    static {
        try {
            String mtdName;
            if (JAVA9_CLEANER_CLASS_NAME.equals(cls.getName())) {
                instance = cls.getMethod("create", new Class[0]).invoke(null, new Object[0]);
                mtdName = "register";
            } else {
                instance = null;
                mtdName = "create";
            }
            initMtd = cls.getMethod(mtdName, Object.class, Runnable.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

