/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor;

import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.jetbrains.annotations.Nullable;

public abstract class VisorJob<A, R>
extends ComputeJobAdapter {
    @IgniteInstanceResource
    protected transient IgniteEx ignite;
    protected transient long start;
    protected boolean debug;

    protected VisorJob(@Nullable A arg, boolean debug) {
        super((Object)arg);
        this.debug = debug;
    }

    @Override
    @Nullable
    public Object execute() {
        this.start = U.currentTimeMillis();
        Object arg = this.argument(0);
        try {
            if (this.debug) {
                VisorTaskUtils.logStart(this.ignite.log(), this.getClass(), this.start);
            }
            R r = this.run(arg);
            return r;
        }
        finally {
            if (this.debug) {
                VisorTaskUtils.logFinish(this.ignite.log(), this.getClass(), this.start);
            }
        }
    }

    protected abstract R run(@Nullable A var1) throws IgniteException;
}

