/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.file;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorFileBlockTaskArg
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String path;
    private long off;
    private int blockSz;
    private long lastModified;

    public VisorFileBlockTaskArg() {
    }

    public VisorFileBlockTaskArg(String path, long off, int blockSz, long lastModified) {
        this.path = path;
        this.off = off;
        this.blockSz = blockSz;
        this.lastModified = lastModified;
    }

    public String getPath() {
        return this.path;
    }

    public long getOffset() {
        return this.off;
    }

    public int getBlockSize() {
        return this.blockSz;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.path);
        out.writeLong(this.off);
        out.writeInt(this.blockSz);
        out.writeLong(this.lastModified);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.path = U.readString(in);
        this.off = in.readLong();
        this.blockSz = in.readInt();
        this.lastModified = in.readLong();
    }

    public String toString() {
        return S.toString(VisorFileBlockTaskArg.class, this);
    }
}

