/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.performancestatistics.handlers;

import java.io.PrintStream;
import java.util.BitSet;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.performancestatistics.util.Utils;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.performancestatistics.OperationType;
import org.apache.ignite.internal.processors.performancestatistics.PerformanceStatisticsHandler;
import org.apache.ignite.internal.util.GridIntIterator;
import org.apache.ignite.internal.util.GridIntList;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class PrintHandler
implements PerformanceStatisticsHandler {
    private final PrintStream ps;
    @Nullable
    private final BitSet ops;
    private final long from;
    private final long to;
    @Nullable
    private final Set<Integer> cacheIds;

    public PrintHandler(PrintStream ps, @Nullable BitSet ops, long from, long to, @Nullable Set<Integer> cacheIds) {
        this.ps = ps;
        this.ops = ops;
        this.from = from;
        this.to = to;
        this.cacheIds = cacheIds;
    }

    public void cacheStart(UUID nodeId, int cacheId, String name) {
        if (this.skip(OperationType.CACHE_START, cacheId)) {
            return;
        }
        this.ps.print("{\"op\":\"" + OperationType.CACHE_START);
        this.ps.print("\",\"nodeId\":\"");
        this.ps.print(nodeId);
        this.ps.print("\",\"cacheId\":");
        this.ps.print(cacheId);
        this.ps.print(",\"name\":\"");
        Utils.printEscaped(this.ps, name);
        this.ps.println("\"}");
    }

    public void cacheOperation(UUID nodeId, OperationType type, int cacheId, long startTime, long duration) {
        if (this.skip(type, startTime, cacheId)) {
            return;
        }
        this.ps.print("{\"op\":\"");
        this.ps.print(type);
        this.ps.print("\",\"nodeId\":\"");
        this.ps.print(nodeId);
        this.ps.print("\",\"cacheId\":");
        this.ps.print(cacheId);
        this.ps.print(",\"startTime\":");
        this.ps.print(startTime);
        this.ps.print(",\"duration\":");
        this.ps.print(duration);
        this.ps.println("}");
    }

    public void transaction(UUID nodeId, GridIntList cacheIds, long startTime, long duration, boolean commited) {
        OperationType op;
        OperationType operationType = op = commited ? OperationType.TX_COMMIT : OperationType.TX_ROLLBACK;
        if (this.skip(op, startTime, cacheIds)) {
            return;
        }
        this.ps.print("{\"op\":\"");
        this.ps.print(op);
        this.ps.print("\",\"nodeId\":\"");
        this.ps.print(nodeId);
        this.ps.print("\",\"cacheIds\":");
        this.ps.print(cacheIds);
        this.ps.print(",\"startTime\":");
        this.ps.print(startTime);
        this.ps.print(",\"duration\":");
        this.ps.print(duration);
        this.ps.println("}");
    }

    public void query(UUID nodeId, GridCacheQueryType type, String text, long id, long startTime, long duration, boolean success) {
        if (this.skip(OperationType.QUERY, startTime)) {
            return;
        }
        this.ps.print("{\"op\":\"" + OperationType.QUERY);
        this.ps.print("\",\"nodeId\":\"");
        this.ps.print(nodeId);
        this.ps.print("\",\"type\":\"");
        this.ps.print(type);
        this.ps.print("\",\"text\":\"");
        Utils.printEscaped(this.ps, text);
        this.ps.print("\",\"id\":");
        this.ps.print(id);
        this.ps.print(",\"startTime\":");
        this.ps.print(startTime);
        this.ps.print(",\"duration\":");
        this.ps.print(duration);
        this.ps.print(",\"success\":");
        this.ps.print(success);
        this.ps.println("}");
    }

    public void queryReads(UUID nodeId, GridCacheQueryType type, UUID queryNodeId, long id, long logicalReads, long physicalReads) {
        if (this.skip(OperationType.QUERY_READS)) {
            return;
        }
        this.ps.print("{\"op\":\"" + OperationType.QUERY_READS);
        this.ps.print("\",\"nodeId\":\"");
        this.ps.print(nodeId);
        this.ps.print("\",\"type\":\"");
        this.ps.print(type);
        this.ps.print("\",\"queryNodeId\":\"");
        this.ps.print(queryNodeId);
        this.ps.print("\",\"id\":");
        this.ps.print(id);
        this.ps.print(",\"logicalReads\":");
        this.ps.print(logicalReads);
        this.ps.print(",\"physicalReads\":");
        this.ps.print(physicalReads);
        this.ps.println("}");
    }

    public void task(UUID nodeId, IgniteUuid sesId, String taskName, long startTime, long duration, int affPartId) {
        if (this.skip(OperationType.TASK, startTime)) {
            return;
        }
        this.ps.print("{\"op\":\"" + OperationType.TASK);
        this.ps.print("\",\"nodeId\":\"");
        this.ps.print(nodeId);
        this.ps.print("\",\"sesId\":\"");
        this.ps.print(sesId);
        this.ps.print("\",\"taskName\":\"");
        Utils.printEscaped(this.ps, taskName);
        this.ps.print("\",\"startTime\":");
        this.ps.print(startTime);
        this.ps.print(",\"duration\":");
        this.ps.print(duration);
        this.ps.print(",\"affPartId\":");
        this.ps.print(affPartId);
        this.ps.println("}");
    }

    public void job(UUID nodeId, IgniteUuid sesId, long queuedTime, long startTime, long duration, boolean timedOut) {
        if (this.skip(OperationType.JOB, startTime)) {
            return;
        }
        this.ps.print("{\"op\":\"" + OperationType.JOB);
        this.ps.print("\",\"nodeId\":\"");
        this.ps.print(nodeId);
        this.ps.print("\",\"sesId\":\"");
        this.ps.print(sesId);
        this.ps.print("\",\"queuedTime\":");
        this.ps.print(queuedTime);
        this.ps.print(",\"startTime\":");
        this.ps.print(startTime);
        this.ps.print(",\"duration\":");
        this.ps.print(duration);
        this.ps.print(",\"timedOut\":");
        this.ps.print(timedOut);
        this.ps.println("}");
    }

    private boolean skip(OperationType op) {
        return this.ops != null && !this.ops.get(op.id());
    }

    private boolean skip(OperationType op, long startTime) {
        return this.skip(op) || startTime < this.from || startTime > this.to;
    }

    private boolean skip(OperationType op, int cacheId) {
        return this.skip(op) || this.cacheIds != null && !this.cacheIds.contains(cacheId);
    }

    private boolean skip(OperationType op, long startTime, int cacheId) {
        return this.skip(op, startTime) || this.cacheIds != null && !this.cacheIds.contains(cacheId);
    }

    private boolean skip(OperationType op, long startTime, GridIntList cacheIds) {
        if (this.skip(op, startTime)) {
            return true;
        }
        if (this.cacheIds == null) {
            return false;
        }
        GridIntIterator iter = cacheIds.iterator();
        while (iter.hasNext()) {
            if (!this.cacheIds.contains(iter.next())) continue;
            return false;
        }
        return true;
    }
}

