/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

CREATE TABLE tbl_result (
  a_id bigint,
  b_id bigint,
  a_age bigint,
  a_lang varchar,
  b_age bigint,
  b_lang varchar
) WITH (
	type='file',
	geaflow.dsl.file.path='${target}'
);

USE GRAPH modern;

INSERT INTO tbl_result
SELECT
	a.id,
	b.id,
	a_age,
	a_lang,
	b_age,
  b_lang
FROM (
  MATCH
       (a:person)-(b:software) | (a:software)-(b:person)
       |+| (a:person)-(b:software)
  ORDER by a, b limit 10
  RETURN distinct a, b, a.age as a_age, a.lang as a_lang, b.age as b_age, b.lang as b_lang
  order by a, b
)
;