/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.rel.expressions.sorts;

import java.util.Objects;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.sorts.NullOrdering;
import org.apache.gravitino.rel.expressions.sorts.SortDirection;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;

public class SortOrders {
    public static final SortOrder[] NONE = new SortOrder[0];

    public static SortImpl ascending(Expression expression) {
        return SortOrders.of(expression, SortDirection.ASCENDING);
    }

    public static SortImpl descending(Expression expression) {
        return SortOrders.of(expression, SortDirection.DESCENDING);
    }

    public static SortImpl of(Expression expression, SortDirection direction) {
        return SortOrders.of(expression, direction, direction.defaultNullOrdering());
    }

    public static SortImpl of(Expression expression, SortDirection direction, NullOrdering nullOrdering) {
        return new SortImpl(expression, direction, nullOrdering);
    }

    private SortOrders() {
    }

    public static final class SortImpl
    implements SortOrder {
        private final Expression expression;
        private final SortDirection direction;
        private final NullOrdering nullOrdering;

        private SortImpl(Expression expression, SortDirection direction, NullOrdering nullOrdering) {
            this.expression = expression;
            this.direction = direction;
            this.nullOrdering = nullOrdering;
        }

        @Override
        public Expression expression() {
            return this.expression;
        }

        @Override
        public SortDirection direction() {
            return this.direction;
        }

        @Override
        public NullOrdering nullOrdering() {
            return this.nullOrdering;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SortImpl sort = (SortImpl)o;
            return Objects.equals(this.expression, sort.expression) && this.direction == sort.direction && this.nullOrdering == sort.nullOrdering;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.expression, this.direction, this.nullOrdering});
        }

        public String toString() {
            return "SortImpl{expression=" + this.expression + ", direction=" + (Object)((Object)this.direction) + ", nullOrdering=" + (Object)((Object)this.nullOrdering) + '}';
        }
    }
}

