/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.PropertyUtil;

public class GCPProperties
implements Serializable {
    public static final String GCS_PROJECT_ID = "gcs.project-id";
    public static final String GCS_CLIENT_LIB_TOKEN = "gcs.client-lib-token";
    public static final String GCS_SERVICE_HOST = "gcs.service.host";
    public static final String GCS_DECRYPTION_KEY = "gcs.decryption-key";
    public static final String GCS_ENCRYPTION_KEY = "gcs.encryption-key";
    public static final String GCS_USER_PROJECT = "gcs.user-project";
    public static final String GCS_CHANNEL_READ_CHUNK_SIZE = "gcs.channel.read.chunk-size-bytes";
    public static final String GCS_CHANNEL_WRITE_CHUNK_SIZE = "gcs.channel.write.chunk-size-bytes";
    public static final String GCS_OAUTH2_TOKEN = "gcs.oauth2.token";
    public static final String GCS_OAUTH2_TOKEN_EXPIRES_AT = "gcs.oauth2.token-expires-at";
    public static final String GCS_NO_AUTH = "gcs.no-auth";
    public static final String GCS_DELETE_BATCH_SIZE = "gcs.delete.batch-size";
    public static final int GCS_DELETE_BATCH_SIZE_DEFAULT = 50;
    private String projectId;
    private String clientLibToken;
    private String serviceHost;
    private String gcsDecryptionKey;
    private String gcsEncryptionKey;
    private String gcsUserProject;
    private Integer gcsChannelReadChunkSize;
    private Integer gcsChannelWriteChunkSize;
    private boolean gcsNoAuth;
    private String gcsOAuth2Token;
    private Date gcsOAuth2TokenExpiresAt;
    private int gcsDeleteBatchSize = 50;

    public GCPProperties() {
    }

    public GCPProperties(Map<String, String> properties) {
        this.projectId = properties.get(GCS_PROJECT_ID);
        this.clientLibToken = properties.get(GCS_CLIENT_LIB_TOKEN);
        this.serviceHost = properties.get(GCS_SERVICE_HOST);
        this.gcsDecryptionKey = properties.get(GCS_DECRYPTION_KEY);
        this.gcsEncryptionKey = properties.get(GCS_ENCRYPTION_KEY);
        this.gcsUserProject = properties.get(GCS_USER_PROJECT);
        if (properties.containsKey(GCS_CHANNEL_READ_CHUNK_SIZE)) {
            this.gcsChannelReadChunkSize = Integer.parseInt(properties.get(GCS_CHANNEL_READ_CHUNK_SIZE));
        }
        if (properties.containsKey(GCS_CHANNEL_WRITE_CHUNK_SIZE)) {
            this.gcsChannelWriteChunkSize = Integer.parseInt(properties.get(GCS_CHANNEL_WRITE_CHUNK_SIZE));
        }
        this.gcsOAuth2Token = properties.get(GCS_OAUTH2_TOKEN);
        if (properties.containsKey(GCS_OAUTH2_TOKEN_EXPIRES_AT)) {
            this.gcsOAuth2TokenExpiresAt = new Date(Long.parseLong(properties.get(GCS_OAUTH2_TOKEN_EXPIRES_AT)));
        }
        this.gcsNoAuth = Boolean.parseBoolean(properties.getOrDefault(GCS_NO_AUTH, "false"));
        Preconditions.checkState((this.gcsOAuth2Token == null || !this.gcsNoAuth ? 1 : 0) != 0, (String)"Invalid auth settings: must not configure %s and %s", (Object)GCS_NO_AUTH, (Object)GCS_OAUTH2_TOKEN);
        this.gcsDeleteBatchSize = PropertyUtil.propertyAsInt(properties, (String)GCS_DELETE_BATCH_SIZE, (int)50);
    }

    public Optional<Integer> channelReadChunkSize() {
        return Optional.ofNullable(this.gcsChannelReadChunkSize);
    }

    public Optional<Integer> channelWriteChunkSize() {
        return Optional.ofNullable(this.gcsChannelWriteChunkSize);
    }

    public Optional<String> clientLibToken() {
        return Optional.ofNullable(this.clientLibToken);
    }

    public Optional<String> decryptionKey() {
        return Optional.ofNullable(this.gcsDecryptionKey);
    }

    public Optional<String> encryptionKey() {
        return Optional.ofNullable(this.gcsEncryptionKey);
    }

    public Optional<String> projectId() {
        return Optional.ofNullable(this.projectId);
    }

    public Optional<String> serviceHost() {
        return Optional.ofNullable(this.serviceHost);
    }

    public Optional<String> userProject() {
        return Optional.ofNullable(this.gcsUserProject);
    }

    public Optional<String> oauth2Token() {
        return Optional.ofNullable(this.gcsOAuth2Token);
    }

    public boolean noAuth() {
        return this.gcsNoAuth;
    }

    public Optional<Date> oauth2TokenExpiresAt() {
        return Optional.ofNullable(this.gcsOAuth2TokenExpiresAt);
    }

    public int deleteBatchSize() {
        return this.gcsDeleteBatchSize;
    }
}

