/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.gravitino.rest.RESTRequest;

public class ModelVersionLinkRequest
implements RESTRequest {
    @JsonProperty(value="uri")
    private String uri;
    @JsonProperty(value="aliases")
    private String[] aliases;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="properties")
    private Map<String, String> properties;

    @Override
    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.uri), (Object)"\"uri\" field is required and cannot be empty");
        if (this.aliases != null && this.aliases.length > 0) {
            for (String alias : this.aliases) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)alias), (Object)"alias must not be null or empty");
                Preconditions.checkArgument((!NumberUtils.isCreatable((String)alias) ? 1 : 0) != 0, (Object)"alias must not be a number or a number string");
            }
        }
    }

    public String getUri() {
        return this.uri;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String getComment() {
        return this.comment;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "ModelVersionLinkRequest(uri=" + this.getUri() + ", aliases=" + Arrays.deepToString(this.getAliases()) + ", comment=" + this.getComment() + ", properties=" + this.getProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelVersionLinkRequest)) {
            return false;
        }
        ModelVersionLinkRequest other = (ModelVersionLinkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAliases(), other.getAliases())) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelVersionLinkRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAliases());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public ModelVersionLinkRequest() {
    }

    public ModelVersionLinkRequest(String uri, String[] aliases, String comment, Map<String, String> properties) {
        this.uri = uri;
        this.aliases = aliases;
        this.comment = comment;
        this.properties = properties;
    }
}

