/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.event;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.iceberg.service.IcebergRestUtils;
import org.apache.gravitino.listener.api.event.IcebergRequestContext;
import org.apache.gravitino.listener.api.event.IcebergTableEvent;
import org.apache.gravitino.listener.api.event.OperationType;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.responses.LoadTableResponse;

@DeveloperApi
public class IcebergCreateTableEvent
extends IcebergTableEvent {
    private final CreateTableRequest createTableRequest;
    private final LoadTableResponse loadTableResponse;

    public IcebergCreateTableEvent(IcebergRequestContext icebergRequestContext, NameIdentifier resourceIdentifier, CreateTableRequest createTableRequest, LoadTableResponse loadTableResponse) {
        super(icebergRequestContext, resourceIdentifier);
        this.createTableRequest = IcebergRestUtils.cloneIcebergRESTObject(createTableRequest, CreateTableRequest.class);
        this.loadTableResponse = IcebergRestUtils.cloneIcebergRESTObject(loadTableResponse, LoadTableResponse.class);
    }

    public OperationType operationType() {
        return OperationType.CREATE_TABLE;
    }

    public CreateTableRequest createTableRequest() {
        return this.createTableRequest;
    }

    public LoadTableResponse loadTableResponse() {
        return this.loadTableResponse;
    }
}

