/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.iceberg.aws.ApacheHttpClientConfigurations;
import org.apache.iceberg.aws.UrlConnectionHttpClientConfigurations;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.util.PropertyUtil;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;

public class HttpClientProperties
implements Serializable {
    public static final String CLIENT_TYPE = "http-client.type";
    public static final String CLIENT_TYPE_APACHE = "apache";
    private static final String CLIENT_PREFIX = "http-client.";
    public static final String CLIENT_TYPE_URLCONNECTION = "urlconnection";
    public static final String CLIENT_TYPE_DEFAULT = "apache";
    public static final String URLCONNECTION_CONNECTION_TIMEOUT_MS = "http-client.urlconnection.connection-timeout-ms";
    public static final String URLCONNECTION_SOCKET_TIMEOUT_MS = "http-client.urlconnection.socket-timeout-ms";
    public static final String APACHE_CONNECTION_TIMEOUT_MS = "http-client.apache.connection-timeout-ms";
    public static final String APACHE_SOCKET_TIMEOUT_MS = "http-client.apache.socket-timeout-ms";
    public static final String APACHE_CONNECTION_ACQUISITION_TIMEOUT_MS = "http-client.apache.connection-acquisition-timeout-ms";
    public static final String APACHE_CONNECTION_MAX_IDLE_TIME_MS = "http-client.apache.connection-max-idle-time-ms";
    public static final String APACHE_CONNECTION_TIME_TO_LIVE_MS = "http-client.apache.connection-time-to-live-ms";
    public static final String APACHE_EXPECT_CONTINUE_ENABLED = "http-client.apache.expect-continue-enabled";
    public static final String APACHE_MAX_CONNECTIONS = "http-client.apache.max-connections";
    public static final String APACHE_TCP_KEEP_ALIVE_ENABLED = "http-client.apache.tcp-keep-alive-enabled";
    public static final String APACHE_USE_IDLE_CONNECTION_REAPER_ENABLED = "http-client.apache.use-idle-connection-reaper-enabled";
    private String httpClientType;
    private final Map<String, String> httpClientProperties;

    public HttpClientProperties() {
        this.httpClientType = "apache";
        this.httpClientProperties = Collections.emptyMap();
    }

    public HttpClientProperties(Map<String, String> properties) {
        this.httpClientType = PropertyUtil.propertyAsString(properties, (String)CLIENT_TYPE, (String)"apache");
        this.httpClientProperties = PropertyUtil.filterProperties(properties, key -> key.startsWith(CLIENT_PREFIX));
    }

    public <T extends AwsSyncClientBuilder> void applyHttpClientConfigurations(T builder) {
        if (Strings.isNullOrEmpty((String)this.httpClientType)) {
            this.httpClientType = "apache";
        }
        switch (this.httpClientType) {
            case "urlconnection": {
                UrlConnectionHttpClientConfigurations urlConnectionHttpClientConfigurations = (UrlConnectionHttpClientConfigurations)this.loadHttpClientConfigurations(UrlConnectionHttpClientConfigurations.class.getName());
                urlConnectionHttpClientConfigurations.configureHttpClientBuilder(builder);
                break;
            }
            case "apache": {
                ApacheHttpClientConfigurations apacheHttpClientConfigurations = (ApacheHttpClientConfigurations)this.loadHttpClientConfigurations(ApacheHttpClientConfigurations.class.getName());
                apacheHttpClientConfigurations.configureHttpClientBuilder(builder);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized HTTP client type " + this.httpClientType);
            }
        }
    }

    private <T> T loadHttpClientConfigurations(String impl) {
        try {
            Object httpClientConfigurations = DynMethods.builder((String)"create").hiddenImpl(impl, new Class[]{Map.class}).buildStaticChecked().invoke(new Object[]{this.httpClientProperties});
            return (T)httpClientConfigurations;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot create %s to generate and configure the http client builder", impl), e);
        }
    }
}

