/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.util;

import java.util.concurrent.atomic.AtomicBoolean;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollection;
import software.amazon.awssdk.metrics.MetricPublisher;

public class RetryDetector
implements MetricPublisher {
    private final AtomicBoolean retried = new AtomicBoolean(false);

    public void publish(MetricCollection metricCollection) {
        if (!this.retried.get()) {
            if (metricCollection.metricValues(CoreMetric.RETRY_COUNT).stream().anyMatch(i -> i > 0)) {
                this.retried.set(true);
            } else {
                metricCollection.children().forEach(this::publish);
            }
        }
    }

    public void close() {
    }

    public boolean retried() {
        return this.retried.get();
    }
}

