/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.apache.gravitino.config.ConfigEntry;
import org.apache.gravitino.utils.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Config {
    private static final Logger LOG = LoggerFactory.getLogger(Config.class);
    private static final String CONFIG_PREPEND = "gravitino.";
    private final ConcurrentMap<String, String> configMap;
    private final Map<String, DeprecatedConfig> deprecatedConfigMap;
    private final DeprecatedConfig[] deprecatedConfigs = new DeprecatedConfig[]{new DeprecatedConfig("gravitino.authenticator", "0.6.0", "Please use gravitino.authenticators instead.")};

    protected Config(boolean loadDefaults) {
        this.deprecatedConfigMap = new HashMap<String, DeprecatedConfig>();
        for (DeprecatedConfig config : this.deprecatedConfigs) {
            this.deprecatedConfigMap.put(config.key, config);
        }
        this.configMap = new ConcurrentHashMap<String, String>();
        if (loadDefaults) {
            this.loadFromProperties(System.getProperties());
        }
    }

    public Config() {
        this(true);
    }

    public Config loadFromFile(String name) throws Exception {
        String confDir = Optional.ofNullable(System.getenv("GRAVITINO_CONF_DIR")).orElse(Optional.ofNullable(System.getenv("GRAVITINO_HOME")).map(s -> s + File.separator + "conf").orElse(null));
        if (confDir == null) {
            throw new IllegalArgumentException("GRAVITINO_CONF_DIR or GRAVITINO_HOME not set");
        }
        File confFile = new File(confDir + File.separator + name);
        if (!confFile.exists()) {
            throw new IllegalArgumentException("Config file " + confFile.getAbsolutePath() + " not found");
        }
        Properties properties = this.loadPropertiesFromFile(confFile);
        this.loadFromProperties(properties);
        return this;
    }

    public <T> T get(ConfigEntry<T> entry) throws NoSuchElementException {
        return entry.readFrom(this.configMap);
    }

    public String getRawString(String key) {
        return (String)this.configMap.get(key);
    }

    public String getRawString(String key, String defaultValue) {
        return this.configMap.getOrDefault(key, defaultValue);
    }

    public Map<String, String> getConfigsWithPrefix(String prefix) {
        return MapUtils.getPrefixMap(this.configMap, (String)prefix);
    }

    public Map<String, String> getAllConfig() {
        return MapUtils.unmodifiableMap(this.configMap);
    }

    public <T> void set(ConfigEntry<T> entry, T value) {
        if (entry.isDeprecated() && this.deprecatedConfigMap.containsKey(entry.getKey()) && LOG.isWarnEnabled()) {
            LOG.warn("Config {} is deprecated since Gravitino {}. {}", new Object[]{entry.getKey(), this.deprecatedConfigMap.get(entry.getKey()).version, this.deprecatedConfigMap.get(entry.getKey()).deprecationMessage});
        }
        if (value == null && LOG.isWarnEnabled()) {
            LOG.warn("Config {} value to set is null, ignore setting to Config.", (Object)entry.getKey());
            return;
        }
        entry.writeTo(this.configMap, value);
    }

    public void loadFromMap(Map<String, String> map, Predicate<String> predicate) {
        map.forEach((k, v) -> {
            String trimmedK = k.trim();
            String trimmedV = v.trim();
            if (!trimmedK.isEmpty() && !trimmedV.isEmpty() && predicate.test(trimmedK)) {
                this.configMap.put(trimmedK, trimmedV);
            }
        });
    }

    public void loadFromProperties(Properties properties) {
        this.loadFromMap((Map<String, String>)Maps.fromProperties((Properties)properties), k -> {
            if (k.startsWith(CONFIG_PREPEND)) {
                if (this.deprecatedConfigMap.containsKey(k) && LOG.isWarnEnabled()) {
                    LOG.warn("Config {} is deprecated since Gravitino {}. {}", new Object[]{k, this.deprecatedConfigMap.get(k).version, this.deprecatedConfigMap.get(k).deprecationMessage});
                }
                return true;
            }
            return false;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties loadPropertiesFromFile(File file) throws IOException {
        Properties properties = new Properties();
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception e) {
            LOG.error("Failed to load properties from {}", (Object)file.getAbsolutePath(), (Object)e);
            throw new IOException("Failed to load properties from " + file.getAbsolutePath(), e);
        }
    }

    private static class DeprecatedConfig {
        private final String key;
        private final String version;
        private final String deprecationMessage;

        private DeprecatedConfig(String key, String version, String deprecationMessage) {
            this.key = key;
            this.version = version;
            this.deprecationMessage = deprecationMessage;
        }
    }
}

