/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener;

import java.util.Map;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.listener.EventBus;
import org.apache.gravitino.listener.api.event.AlterTagFailureEvent;
import org.apache.gravitino.listener.api.event.AssociateTagsForMetadataObjectFailureEvent;
import org.apache.gravitino.listener.api.event.CreateTagFailureEvent;
import org.apache.gravitino.listener.api.event.DeleteTagFailureEvent;
import org.apache.gravitino.listener.api.event.GetTagFailureEvent;
import org.apache.gravitino.listener.api.event.GetTagForMetadataObjectFailureEvent;
import org.apache.gravitino.listener.api.event.ListMetadataObjectsForTagFailureEvent;
import org.apache.gravitino.listener.api.event.ListTagsFailureEvent;
import org.apache.gravitino.listener.api.event.ListTagsForMetadataObjectFailureEvent;
import org.apache.gravitino.listener.api.event.ListTagsInfoFailureEvent;
import org.apache.gravitino.listener.api.event.ListTagsInfoForMetadataObjectFailureEvent;
import org.apache.gravitino.listener.api.info.TagInfo;
import org.apache.gravitino.tag.Tag;
import org.apache.gravitino.tag.TagChange;
import org.apache.gravitino.tag.TagDispatcher;
import org.apache.gravitino.utils.PrincipalUtils;

public class TagEventDispatcher
implements TagDispatcher {
    private final EventBus eventBus;
    private final TagDispatcher dispatcher;

    public TagEventDispatcher(EventBus eventBus, TagDispatcher dispatcher) {
        this.eventBus = eventBus;
        this.dispatcher = dispatcher;
    }

    @Override
    public String[] listTags(String metalake) {
        try {
            return this.dispatcher.listTags(metalake);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new ListTagsFailureEvent(PrincipalUtils.getCurrentUserName(), metalake, e));
            throw e;
        }
    }

    @Override
    public Tag[] listTagsInfo(String metalake) {
        try {
            return this.dispatcher.listTagsInfo(metalake);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new ListTagsInfoFailureEvent(PrincipalUtils.getCurrentUserName(), metalake, e));
            throw e;
        }
    }

    @Override
    public Tag getTag(String metalake, String name) throws NoSuchTagException {
        try {
            return this.dispatcher.getTag(metalake, name);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new GetTagFailureEvent(PrincipalUtils.getCurrentUserName(), metalake, name, e));
            throw e;
        }
    }

    @Override
    public Tag createTag(String metalake, String name, String comment, Map<String, String> properties) {
        TagInfo tagInfo = new TagInfo(name, comment, properties);
        try {
            return this.dispatcher.createTag(metalake, name, comment, properties);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new CreateTagFailureEvent(PrincipalUtils.getCurrentUserName(), metalake, tagInfo, e));
            throw e;
        }
    }

    @Override
    public Tag alterTag(String metalake, String name, TagChange ... changes) {
        try {
            return this.dispatcher.alterTag(metalake, name, changes);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new AlterTagFailureEvent(PrincipalUtils.getCurrentUserName(), metalake, name, changes, e));
            throw e;
        }
    }

    @Override
    public boolean deleteTag(String metalake, String name) {
        try {
            return this.dispatcher.deleteTag(metalake, name);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new DeleteTagFailureEvent(PrincipalUtils.getCurrentUserName(), metalake, name, e));
            throw e;
        }
    }

    @Override
    public MetadataObject[] listMetadataObjectsForTag(String metalake, String name) {
        try {
            return this.dispatcher.listMetadataObjectsForTag(metalake, name);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new ListMetadataObjectsForTagFailureEvent(PrincipalUtils.getCurrentUserName(), metalake, name, e));
            throw e;
        }
    }

    @Override
    public String[] listTagsForMetadataObject(String metalake, MetadataObject metadataObject) {
        try {
            return this.dispatcher.listTagsForMetadataObject(metalake, metadataObject);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new ListTagsForMetadataObjectFailureEvent(PrincipalUtils.getCurrentUserName(), metalake, metadataObject, e));
            throw e;
        }
    }

    @Override
    public Tag[] listTagsInfoForMetadataObject(String metalake, MetadataObject metadataObject) {
        try {
            return this.dispatcher.listTagsInfoForMetadataObject(metalake, metadataObject);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new ListTagsInfoForMetadataObjectFailureEvent(PrincipalUtils.getCurrentUserName(), metalake, metadataObject, e));
            throw e;
        }
    }

    @Override
    public String[] associateTagsForMetadataObject(String metalake, MetadataObject metadataObject, String[] tagsToAdd, String[] tagsToRemove) {
        try {
            return this.dispatcher.associateTagsForMetadataObject(metalake, metadataObject, tagsToAdd, tagsToRemove);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new AssociateTagsForMetadataObjectFailureEvent(PrincipalUtils.getCurrentUserName(), metalake, metadataObject, tagsToAdd, tagsToRemove, e));
            throw e;
        }
    }

    @Override
    public Tag getTagForMetadataObject(String metalake, MetadataObject metadataObject, String name) {
        try {
            return this.dispatcher.getTagForMetadataObject(metalake, metadataObject, name);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new GetTagForMetadataObjectFailureEvent(PrincipalUtils.getCurrentUserName(), metalake, metadataObject, name, e));
            throw e;
        }
    }
}

