/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.info;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.gravitino.Audit;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.file.Fileset;

@DeveloperApi
public final class FilesetInfo {
    private final String name;
    @Nullable
    private final String comment;
    private final Fileset.Type type;
    private final String storageLocation;
    private final Map<String, String> properties;
    @Nullable
    private final Audit audit;

    public FilesetInfo(Fileset fileset) {
        this(fileset.name(), fileset.comment(), fileset.type(), fileset.storageLocation(), fileset.properties(), fileset.auditInfo());
    }

    public FilesetInfo(String name, String comment, Fileset.Type type, String storageLocation, Map<String, String> properties, Audit audit) {
        this.name = name;
        this.comment = comment;
        this.type = type;
        this.storageLocation = storageLocation;
        this.properties = properties == null ? ImmutableMap.of() : ImmutableMap.copyOf(properties);
        this.audit = audit;
    }

    @Nullable
    public Audit auditInfo() {
        return this.audit;
    }

    public String name() {
        return this.name;
    }

    public Fileset.Type type() {
        return this.type;
    }

    public String storageLocation() {
        return this.storageLocation;
    }

    @Nullable
    public String comment() {
        return this.comment;
    }

    public Map<String, String> properties() {
        return this.properties;
    }
}

