/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.info.partitions;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;
import org.apache.gravitino.listener.api.info.partitions.IdentityPartitionInfo;
import org.apache.gravitino.listener.api.info.partitions.ListPartitionInfo;
import org.apache.gravitino.listener.api.info.partitions.RangePartitionInfo;
import org.apache.gravitino.rel.partitions.IdentityPartition;
import org.apache.gravitino.rel.partitions.ListPartition;
import org.apache.gravitino.rel.partitions.Partition;
import org.apache.gravitino.rel.partitions.RangePartition;

@DeveloperApi
public abstract class PartitionInfo {
    private String name;
    private Map<String, String> properties;

    protected PartitionInfo(String name, Map<String, String> properties) {
        this.name = name;
        this.properties = properties == null ? ImmutableMap.of() : ImmutableMap.copyOf(properties);
    }

    public String name() {
        return this.name;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public static PartitionInfo of(Partition partition) {
        if (partition instanceof IdentityPartition) {
            IdentityPartition identityPartition = (IdentityPartition)partition;
            return new IdentityPartitionInfo(identityPartition.name(), identityPartition.fieldNames(), identityPartition.values(), identityPartition.properties());
        }
        if (partition instanceof ListPartition) {
            ListPartition listPartition = (ListPartition)partition;
            return new ListPartitionInfo(listPartition.name(), listPartition.properties(), listPartition.lists());
        }
        if (partition instanceof RangePartition) {
            RangePartition rangePartition = (RangePartition)partition;
            return new RangePartitionInfo(rangePartition.name(), rangePartition.upper(), rangePartition.lower(), rangePartition.properties());
        }
        throw new GravitinoRuntimeException("Invalid instance of PartitionInfo");
    }
}

