/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class SchemaPO {
    private Long schemaId;
    private String schemaName;
    private Long metalakeId;
    private Long catalogId;
    private String schemaComment;
    private String properties;
    private String auditInfo;
    private Long currentVersion;
    private Long lastVersion;
    private Long deletedAt;

    public Long getSchemaId() {
        return this.schemaId;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Long getMetalakeId() {
        return this.metalakeId;
    }

    public Long getCatalogId() {
        return this.catalogId;
    }

    public String getSchemaComment() {
        return this.schemaComment;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getAuditInfo() {
        return this.auditInfo;
    }

    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaPO)) {
            return false;
        }
        SchemaPO schemaPO = (SchemaPO)o;
        return Objects.equal((Object)this.getSchemaId(), (Object)schemaPO.getSchemaId()) && Objects.equal((Object)this.getSchemaName(), (Object)schemaPO.getSchemaName()) && Objects.equal((Object)this.getMetalakeId(), (Object)schemaPO.getMetalakeId()) && Objects.equal((Object)this.getCatalogId(), (Object)schemaPO.getCatalogId()) && Objects.equal((Object)this.getSchemaComment(), (Object)schemaPO.getSchemaComment()) && Objects.equal((Object)this.getProperties(), (Object)schemaPO.getProperties()) && Objects.equal((Object)this.getAuditInfo(), (Object)schemaPO.getAuditInfo()) && Objects.equal((Object)this.getCurrentVersion(), (Object)schemaPO.getCurrentVersion()) && Objects.equal((Object)this.getLastVersion(), (Object)schemaPO.getLastVersion()) && Objects.equal((Object)this.getDeletedAt(), (Object)schemaPO.getDeletedAt());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getSchemaId(), this.getSchemaName(), this.getMetalakeId(), this.getCatalogId(), this.getSchemaComment(), this.getProperties(), this.getAuditInfo(), this.getCurrentVersion(), this.getLastVersion(), this.getDeletedAt()});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final SchemaPO schemaPO = new SchemaPO();

        private Builder() {
        }

        public Builder withSchemaId(Long schemaId) {
            this.schemaPO.schemaId = schemaId;
            return this;
        }

        public Builder withSchemaName(String schemaName) {
            this.schemaPO.schemaName = schemaName;
            return this;
        }

        public Builder withMetalakeId(Long metalakeId) {
            this.schemaPO.metalakeId = metalakeId;
            return this;
        }

        public Builder withCatalogId(Long catalogId) {
            this.schemaPO.catalogId = catalogId;
            return this;
        }

        public Builder withSchemaComment(String schemaComment) {
            this.schemaPO.schemaComment = schemaComment;
            return this;
        }

        public Builder withProperties(String properties) {
            this.schemaPO.properties = properties;
            return this;
        }

        public Builder withAuditInfo(String auditInfo) {
            this.schemaPO.auditInfo = auditInfo;
            return this;
        }

        public Builder withCurrentVersion(Long currentVersion) {
            this.schemaPO.currentVersion = currentVersion;
            return this;
        }

        public Builder withLastVersion(Long lastVersion) {
            this.schemaPO.lastVersion = lastVersion;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.schemaPO.deletedAt = deletedAt;
            return this;
        }

        private void validate() {
            Preconditions.checkArgument((this.schemaPO.schemaId != null ? 1 : 0) != 0, (Object)"Schema id is required");
            Preconditions.checkArgument((this.schemaPO.schemaName != null ? 1 : 0) != 0, (Object)"Schema name is required");
            Preconditions.checkArgument((this.schemaPO.metalakeId != null ? 1 : 0) != 0, (Object)"Metalake id is required");
            Preconditions.checkArgument((this.schemaPO.catalogId != null ? 1 : 0) != 0, (Object)"Catalog id is required");
            Preconditions.checkArgument((this.schemaPO.auditInfo != null ? 1 : 0) != 0, (Object)"Audit info is required");
            Preconditions.checkArgument((this.schemaPO.currentVersion != null ? 1 : 0) != 0, (Object)"Current version is required");
            Preconditions.checkArgument((this.schemaPO.lastVersion != null ? 1 : 0) != 0, (Object)"Last version is required");
            Preconditions.checkArgument((this.schemaPO.deletedAt != null ? 1 : 0) != 0, (Object)"Deleted at is required");
        }

        public SchemaPO build() {
            this.validate();
            return this.schemaPO;
        }
    }
}

