/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class TagMetadataObjectRelPO {
    private Long tagId;
    private Long metadataObjectId;
    private String metadataObjectType;
    private String auditInfo;
    private Long currentVersion;
    private Long lastVersion;
    private Long deletedAt;

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TagMetadataObjectRelPO)) {
            return false;
        }
        TagMetadataObjectRelPO tagRelPO = (TagMetadataObjectRelPO)o;
        return Objects.equal((Object)this.tagId, (Object)tagRelPO.tagId) && Objects.equal((Object)this.metadataObjectId, (Object)tagRelPO.metadataObjectId) && Objects.equal((Object)this.metadataObjectType, (Object)tagRelPO.metadataObjectType) && Objects.equal((Object)this.auditInfo, (Object)tagRelPO.auditInfo) && Objects.equal((Object)this.currentVersion, (Object)tagRelPO.currentVersion) && Objects.equal((Object)this.lastVersion, (Object)tagRelPO.lastVersion) && Objects.equal((Object)this.deletedAt, (Object)tagRelPO.deletedAt);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tagId, this.metadataObjectId, this.metadataObjectType, this.auditInfo, this.currentVersion, this.lastVersion, this.deletedAt});
    }

    public Long getTagId() {
        return this.tagId;
    }

    public Long getMetadataObjectId() {
        return this.metadataObjectId;
    }

    public String getMetadataObjectType() {
        return this.metadataObjectType;
    }

    public String getAuditInfo() {
        return this.auditInfo;
    }

    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public static class Builder {
        private final TagMetadataObjectRelPO tagRelPO = new TagMetadataObjectRelPO();

        private Builder() {
        }

        public Builder withTagId(Long tagId) {
            this.tagRelPO.tagId = tagId;
            return this;
        }

        public Builder withMetadataObjectId(Long metadataObjectId) {
            this.tagRelPO.metadataObjectId = metadataObjectId;
            return this;
        }

        public Builder withMetadataObjectType(String metadataObjectType) {
            this.tagRelPO.metadataObjectType = metadataObjectType;
            return this;
        }

        public Builder withAuditInfo(String auditInfo) {
            this.tagRelPO.auditInfo = auditInfo;
            return this;
        }

        public Builder withCurrentVersion(Long currentVersion) {
            this.tagRelPO.currentVersion = currentVersion;
            return this;
        }

        public Builder withLastVersion(Long lastVersion) {
            this.tagRelPO.lastVersion = lastVersion;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.tagRelPO.deletedAt = deletedAt;
            return this;
        }

        private void validate() {
            Preconditions.checkArgument((this.tagRelPO.tagId != null ? 1 : 0) != 0, (Object)"Tag id is required");
            Preconditions.checkArgument((this.tagRelPO.metadataObjectId != null ? 1 : 0) != 0, (Object)"Metadata object id is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.tagRelPO.metadataObjectType), (Object)"Metadata object type should not be empty");
            Preconditions.checkArgument((this.tagRelPO.auditInfo != null ? 1 : 0) != 0, (Object)"Audit info is required");
            Preconditions.checkArgument((this.tagRelPO.currentVersion != null ? 1 : 0) != 0, (Object)"Current version is required");
            Preconditions.checkArgument((this.tagRelPO.lastVersion != null ? 1 : 0) != 0, (Object)"Last version is required");
            Preconditions.checkArgument((this.tagRelPO.deletedAt != null ? 1 : 0) != 0, (Object)"Deleted at is required");
        }

        public TagMetadataObjectRelPO build() {
            this.validate();
            return this.tagRelPO;
        }
    }
}

