/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class UserRoleRelPO {
    private Long userId;
    private Long roleId;
    private String auditInfo;
    private Long currentVersion;
    private Long lastVersion;
    private Long deletedAt;

    public Long getUserId() {
        return this.userId;
    }

    public Long getRoleId() {
        return this.roleId;
    }

    public String getAuditInfo() {
        return this.auditInfo;
    }

    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserRoleRelPO)) {
            return false;
        }
        UserRoleRelPO userRoleRelPO = (UserRoleRelPO)o;
        return Objects.equal((Object)this.getUserId(), (Object)userRoleRelPO.getUserId()) && Objects.equal((Object)this.getRoleId(), (Object)userRoleRelPO.getRoleId()) && Objects.equal((Object)this.getAuditInfo(), (Object)userRoleRelPO.getAuditInfo()) && Objects.equal((Object)this.getCurrentVersion(), (Object)userRoleRelPO.getCurrentVersion()) && Objects.equal((Object)this.getLastVersion(), (Object)userRoleRelPO.getLastVersion()) && Objects.equal((Object)this.getDeletedAt(), (Object)userRoleRelPO.getDeletedAt());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getUserId(), this.getRoleId(), this.getAuditInfo(), this.getCurrentVersion(), this.getLastVersion(), this.getDeletedAt()});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final UserRoleRelPO userRoleRelPO = new UserRoleRelPO();

        private Builder() {
        }

        public Builder withUserId(Long userId) {
            this.userRoleRelPO.userId = userId;
            return this;
        }

        public Builder withRoleId(Long roleId) {
            this.userRoleRelPO.roleId = roleId;
            return this;
        }

        public Builder withAuditInfo(String auditInfo) {
            this.userRoleRelPO.auditInfo = auditInfo;
            return this;
        }

        public Builder withCurrentVersion(Long currentVersion) {
            this.userRoleRelPO.currentVersion = currentVersion;
            return this;
        }

        public Builder withLastVersion(Long lastVersion) {
            this.userRoleRelPO.lastVersion = lastVersion;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.userRoleRelPO.deletedAt = deletedAt;
            return this;
        }

        private void validate() {
            Preconditions.checkArgument((this.userRoleRelPO.userId != null ? 1 : 0) != 0, (Object)"User id is required");
            Preconditions.checkArgument((this.userRoleRelPO.roleId != null ? 1 : 0) != 0, (Object)"Role id is required");
            Preconditions.checkArgument((this.userRoleRelPO.auditInfo != null ? 1 : 0) != 0, (Object)"Audit info is required");
            Preconditions.checkArgument((this.userRoleRelPO.currentVersion != null ? 1 : 0) != 0, (Object)"Current version is required");
            Preconditions.checkArgument((this.userRoleRelPO.lastVersion != null ? 1 : 0) != 0, (Object)"Last version is required");
            Preconditions.checkArgument((this.userRoleRelPO.deletedAt != null ? 1 : 0) != 0, (Object)"Deleted at is required");
        }

        public UserRoleRelPO build() {
            this.validate();
            return this.userRoleRelPO;
        }
    }
}

