/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.tag;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityAlreadyExistsException;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchMetadataObjectException;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.exceptions.NotFoundException;
import org.apache.gravitino.exceptions.TagAlreadyAssociatedException;
import org.apache.gravitino.exceptions.TagAlreadyExistsException;
import org.apache.gravitino.lock.LockType;
import org.apache.gravitino.lock.TreeLockUtils;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.TagEntity;
import org.apache.gravitino.metalake.MetalakeManager;
import org.apache.gravitino.storage.IdGenerator;
import org.apache.gravitino.tag.SupportsTagOperations;
import org.apache.gravitino.tag.Tag;
import org.apache.gravitino.tag.TagChange;
import org.apache.gravitino.tag.TagDispatcher;
import org.apache.gravitino.utils.MetadataObjectUtil;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.apache.gravitino.utils.PrincipalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagManager
implements TagDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(TagManager.class);
    private final IdGenerator idGenerator;
    private final EntityStore entityStore;
    private final SupportsTagOperations supportsTagOperations;

    public TagManager(IdGenerator idGenerator, EntityStore entityStore) {
        if (!(entityStore instanceof SupportsTagOperations)) {
            String errorMsg = "TagManager cannot run with entity store that does not support tag operations, please configure the entity store to use relational entity store and restart the Gravitino server";
            LOG.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        this.supportsTagOperations = entityStore.tagOperations();
        this.idGenerator = idGenerator;
        this.entityStore = entityStore;
    }

    @Override
    public String[] listTags(String metalake) {
        return (String[])Arrays.stream(this.listTagsInfo(metalake)).map(Tag::name).toArray(String[]::new);
    }

    @Override
    public Tag[] listTagsInfo(String metalake) {
        return TreeLockUtils.doWithTreeLock(NameIdentifier.of((String[])NamespaceUtil.ofTag(metalake).levels()), LockType.READ, () -> {
            MetalakeManager.checkMetalake(NameIdentifier.of((String[])new String[]{metalake}), this.entityStore);
            try {
                return (Tag[])this.entityStore.list(NamespaceUtil.ofTag(metalake), TagEntity.class, Entity.EntityType.TAG).stream().toArray(Tag[]::new);
            }
            catch (IOException ioe) {
                LOG.error("Failed to list tags under metalake {}", (Object)metalake, (Object)ioe);
                throw new RuntimeException(ioe);
            }
        });
    }

    @Override
    public Tag createTag(String metalake, String name, String comment, Map<String, String> properties) throws TagAlreadyExistsException {
        Map<Object, Object> tagProperties = properties == null ? Collections.emptyMap() : properties;
        return TreeLockUtils.doWithTreeLock(NameIdentifier.of((String[])NamespaceUtil.ofTag(metalake).levels()), LockType.WRITE, () -> {
            MetalakeManager.checkMetalake(NameIdentifier.of((String[])new String[]{metalake}), this.entityStore);
            TagEntity tagEntity = TagEntity.builder().withId(this.idGenerator.nextId()).withName(name).withNamespace(NamespaceUtil.ofTag(metalake)).withComment(comment).withProperties(tagProperties).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build()).build();
            try {
                this.entityStore.put(tagEntity, false);
                return tagEntity;
            }
            catch (EntityAlreadyExistsException e) {
                throw new TagAlreadyExistsException("Tag with name %s under metalake %s already exists", new Object[]{name, metalake});
            }
            catch (IOException ioe) {
                LOG.error("Failed to create tag {} under metalake {}", new Object[]{name, metalake, ioe});
                throw new RuntimeException(ioe);
            }
        });
    }

    @Override
    public Tag getTag(String metalake, String name) throws NoSuchTagException {
        return TreeLockUtils.doWithTreeLock(NameIdentifierUtil.ofTag(metalake, name), LockType.READ, () -> {
            MetalakeManager.checkMetalake(NameIdentifier.of((String[])new String[]{metalake}), this.entityStore);
            try {
                return this.entityStore.get(NameIdentifierUtil.ofTag(metalake, name), Entity.EntityType.TAG, TagEntity.class);
            }
            catch (NoSuchEntityException e) {
                throw new NoSuchTagException("Tag with name %s under metalake %s does not exist", new Object[]{name, metalake});
            }
            catch (IOException ioe) {
                LOG.error("Failed to get tag {} under metalake {}", new Object[]{name, metalake, ioe});
                throw new RuntimeException(ioe);
            }
        });
    }

    @Override
    public Tag alterTag(String metalake, String name, TagChange ... changes) throws NoSuchTagException, IllegalArgumentException {
        return TreeLockUtils.doWithTreeLock(NameIdentifier.of((String[])NamespaceUtil.ofTag(metalake).levels()), LockType.WRITE, () -> {
            MetalakeManager.checkMetalake(NameIdentifier.of((String[])new String[]{metalake}), this.entityStore);
            try {
                return this.entityStore.update(NameIdentifierUtil.ofTag(metalake, name), TagEntity.class, Entity.EntityType.TAG, tagEntity -> this.updateTagEntity((TagEntity)tagEntity, changes));
            }
            catch (NoSuchEntityException e) {
                throw new NoSuchTagException("Tag with name %s under metalake %s does not exist", new Object[]{name, metalake});
            }
            catch (EntityAlreadyExistsException e) {
                throw new RuntimeException("Tag with name " + name + " under metalake " + metalake + " already exists");
            }
            catch (IOException ioe) {
                LOG.error("Failed to alter tag {} under metalake {}", new Object[]{name, metalake, ioe});
                throw new RuntimeException(ioe);
            }
        });
    }

    @Override
    public boolean deleteTag(String metalake, String name) {
        return TreeLockUtils.doWithTreeLock(NameIdentifier.of((String[])NamespaceUtil.ofTag(metalake).levels()), LockType.WRITE, () -> {
            MetalakeManager.checkMetalake(NameIdentifier.of((String[])new String[]{metalake}), this.entityStore);
            try {
                return this.entityStore.delete(NameIdentifierUtil.ofTag(metalake, name), Entity.EntityType.TAG);
            }
            catch (IOException ioe) {
                LOG.error("Failed to delete tag {} under metalake {}", new Object[]{name, metalake, ioe});
                throw new RuntimeException(ioe);
            }
        });
    }

    @Override
    public MetadataObject[] listMetadataObjectsForTag(String metalake, String name) throws NoSuchTagException {
        NameIdentifier tagId = NameIdentifierUtil.ofTag(metalake, name);
        return TreeLockUtils.doWithTreeLock(tagId, LockType.READ, () -> {
            MetalakeManager.checkMetalake(NameIdentifier.of((String[])new String[]{metalake}), this.entityStore);
            try {
                if (!this.entityStore.exists(tagId, Entity.EntityType.TAG)) {
                    throw new NoSuchTagException("Tag with name %s under metalake %s does not exist", new Object[]{name, metalake});
                }
                return this.supportsTagOperations.listAssociatedMetadataObjectsForTag(tagId).toArray(new MetadataObject[0]);
            }
            catch (IOException e) {
                LOG.error("Failed to list metadata objects for tag {}", (Object)name, (Object)e);
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public String[] listTagsForMetadataObject(String metalake, MetadataObject metadataObject) throws NotFoundException {
        return (String[])Arrays.stream(this.listTagsInfoForMetadataObject(metalake, metadataObject)).map(Tag::name).toArray(String[]::new);
    }

    @Override
    public Tag[] listTagsInfoForMetadataObject(String metalake, MetadataObject metadataObject) throws NoSuchMetadataObjectException {
        NameIdentifier entityIdent = MetadataObjectUtil.toEntityIdent(metalake, metadataObject);
        Entity.EntityType entityType = MetadataObjectUtil.toEntityType(metadataObject);
        MetadataObjectUtil.checkMetadataObject(metalake, metadataObject);
        return TreeLockUtils.doWithTreeLock(entityIdent, LockType.READ, () -> {
            try {
                return this.supportsTagOperations.listAssociatedTagsForMetadataObject(entityIdent, entityType).toArray(new Tag[0]);
            }
            catch (NoSuchEntityException e) {
                throw new NoSuchMetadataObjectException((Throwable)e, "Failed to list tags for metadata object %s due to not found", new Object[]{metadataObject});
            }
            catch (IOException e) {
                LOG.error("Failed to list tags for metadata object {}", (Object)metadataObject, (Object)e);
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public Tag getTagForMetadataObject(String metalake, MetadataObject metadataObject, String name) throws NoSuchMetadataObjectException {
        NameIdentifier entityIdent = MetadataObjectUtil.toEntityIdent(metalake, metadataObject);
        Entity.EntityType entityType = MetadataObjectUtil.toEntityType(metadataObject);
        NameIdentifier tagIdent = NameIdentifierUtil.ofTag(metalake, name);
        MetadataObjectUtil.checkMetadataObject(metalake, metadataObject);
        return TreeLockUtils.doWithTreeLock(entityIdent, LockType.READ, () -> {
            try {
                return this.supportsTagOperations.getTagForMetadataObject(entityIdent, entityType, tagIdent);
            }
            catch (NoSuchEntityException e) {
                if (e.getMessage().contains("No such tag entity")) {
                    throw new NoSuchTagException((Throwable)e, "Tag %s does not exist for metadata object %s", new Object[]{name, metadataObject});
                }
                throw new NoSuchMetadataObjectException((Throwable)e, "Failed to get tag for metadata object %s due to not found", new Object[]{metadataObject});
            }
            catch (IOException e) {
                LOG.error("Failed to get tag for metadata object {}", (Object)metadataObject, (Object)e);
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public String[] associateTagsForMetadataObject(String metalake, MetadataObject metadataObject, String[] tagsToAdd, String[] tagsToRemove) throws NoSuchMetadataObjectException, TagAlreadyAssociatedException {
        Preconditions.checkArgument((!metadataObject.type().equals((Object)MetadataObject.Type.METALAKE) && !metadataObject.type().equals((Object)MetadataObject.Type.ROLE) ? 1 : 0) != 0, (String)"Cannot associate tags for unsupported metadata object type %s", (Object)metadataObject.type());
        NameIdentifier entityIdent = MetadataObjectUtil.toEntityIdent(metalake, metadataObject);
        Entity.EntityType entityType = MetadataObjectUtil.toEntityType(metadataObject);
        MetadataObjectUtil.checkMetadataObject(metalake, metadataObject);
        HashSet tagsToAddSet = tagsToAdd == null ? Sets.newHashSet() : Sets.newHashSet((Object[])tagsToAdd);
        HashSet tagsToRemoveSet = tagsToRemove == null ? Sets.newHashSet() : Sets.newHashSet((Object[])tagsToRemove);
        ImmutableSet common = Sets.intersection((Set)tagsToAddSet, (Set)tagsToRemoveSet).immutableCopy();
        tagsToAddSet.removeAll((Collection<?>)common);
        tagsToRemoveSet.removeAll((Collection<?>)common);
        NameIdentifier[] tagsToAddIdent = (NameIdentifier[])tagsToAddSet.stream().map(tag -> NameIdentifierUtil.ofTag(metalake, tag)).toArray(NameIdentifier[]::new);
        NameIdentifier[] tagsToRemoveIdent = (NameIdentifier[])tagsToRemoveSet.stream().map(tag -> NameIdentifierUtil.ofTag(metalake, tag)).toArray(NameIdentifier[]::new);
        return TreeLockUtils.doWithTreeLock(entityIdent, LockType.READ, () -> TreeLockUtils.doWithTreeLock(NameIdentifier.of((String[])NamespaceUtil.ofTag(metalake).levels()), LockType.WRITE, () -> {
            try {
                return (String[])this.supportsTagOperations.associateTagsWithMetadataObject(entityIdent, entityType, tagsToAddIdent, tagsToRemoveIdent).stream().map(Tag::name).toArray(String[]::new);
            }
            catch (NoSuchEntityException e) {
                throw new NoSuchMetadataObjectException((Throwable)e, "Failed to associate tags for metadata object %s due to not found", new Object[]{metadataObject});
            }
            catch (EntityAlreadyExistsException e) {
                throw new TagAlreadyAssociatedException((Throwable)((Object)e), "Failed to associate tags for metadata object due to some tags %s already associated to the metadata object %s", new Object[]{Arrays.toString(tagsToAdd), metadataObject});
            }
            catch (IOException e) {
                LOG.error("Failed to associate tags for metadata object {}", (Object)metadataObject, (Object)e);
                throw new RuntimeException(e);
            }
        }));
    }

    private TagEntity updateTagEntity(TagEntity tagEntity, TagChange ... changes) {
        HashMap props = tagEntity.properties() == null ? Maps.newHashMap() : Maps.newHashMap(tagEntity.properties());
        String newName = tagEntity.name();
        String newComment = tagEntity.comment();
        for (TagChange change : changes) {
            if (change instanceof TagChange.RenameTag) {
                newName = ((TagChange.RenameTag)change).getNewName();
                continue;
            }
            if (change instanceof TagChange.UpdateTagComment) {
                newComment = ((TagChange.UpdateTagComment)change).getNewComment();
                continue;
            }
            if (change instanceof TagChange.SetProperty) {
                TagChange.SetProperty setProperty = (TagChange.SetProperty)change;
                props.put(setProperty.getProperty(), setProperty.getValue());
                continue;
            }
            if (change instanceof TagChange.RemoveProperty) {
                TagChange.RemoveProperty removeProperty = (TagChange.RemoveProperty)change;
                props.remove(removeProperty.getProperty());
                continue;
            }
            throw new IllegalArgumentException("Unsupported tag change: " + change);
        }
        return TagEntity.builder().withId(tagEntity.id()).withName(newName).withNamespace(tagEntity.namespace()).withComment(newComment).withProperties(props).withAuditInfo(AuditInfo.builder().withCreator(tagEntity.auditInfo().creator()).withCreateTime(tagEntity.auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build()).build();
    }
}

