/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.NameNodeProxiesClient;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocolPB.JournalProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.JournalProtocolTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolTranslatorPB;
import org.apache.hadoop.hdfs.server.namenode.ha.AbstractNNFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.NameNodeHAProxyFactory;
import org.apache.hadoop.hdfs.server.protocol.BalancerProtocols;
import org.apache.hadoop.hdfs.server.protocol.JournalProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.ProxyCombiner;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RefreshCallQueueProtocol;
import org.apache.hadoop.ipc.protocolPB.RefreshCallQueueProtocolClientSideTranslatorPB;
import org.apache.hadoop.ipc.protocolPB.RefreshCallQueueProtocolPB;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.security.protocolPB.RefreshAuthorizationPolicyProtocolClientSideTranslatorPB;
import org.apache.hadoop.security.protocolPB.RefreshAuthorizationPolicyProtocolPB;
import org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolClientSideTranslatorPB;
import org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolPB;
import org.apache.hadoop.tools.GetUserMappingsProtocol;
import org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolClientSideTranslatorPB;
import org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolPB;

@InterfaceAudience.Private
public class NameNodeProxies {
    private static final Log LOG = LogFactory.getLog(NameNodeProxies.class);

    public static <T> NameNodeProxiesClient.ProxyAndInfo<T> createProxy(Configuration conf, URI nameNodeUri, Class<T> xface) throws IOException {
        return NameNodeProxies.createProxy(conf, nameNodeUri, xface, null);
    }

    public static <T> NameNodeProxiesClient.ProxyAndInfo<T> createProxy(Configuration conf, URI nameNodeUri, Class<T> xface, AtomicBoolean fallbackToSimpleAuth) throws IOException {
        AbstractNNFailoverProxyProvider failoverProxyProvider = NameNodeProxiesClient.createFailoverProxyProvider((Configuration)conf, (URI)nameNodeUri, xface, (boolean)true, (AtomicBoolean)fallbackToSimpleAuth, new NameNodeHAProxyFactory());
        if (failoverProxyProvider == null) {
            return NameNodeProxies.createNonHAProxy(conf, DFSUtilClient.getNNAddress((URI)nameNodeUri), xface, UserGroupInformation.getCurrentUser(), true, fallbackToSimpleAuth, null);
        }
        return NameNodeProxiesClient.createHAProxy((Configuration)conf, (URI)nameNodeUri, xface, (AbstractNNFailoverProxyProvider)failoverProxyProvider);
    }

    public static <T> NameNodeProxiesClient.ProxyAndInfo<T> createNonHAProxy(Configuration conf, InetSocketAddress nnAddr, Class<T> xface, UserGroupInformation ugi, boolean withRetries) throws IOException {
        return NameNodeProxies.createNonHAProxy(conf, nnAddr, xface, ugi, withRetries, null, null);
    }

    public static <T> NameNodeProxiesClient.ProxyAndInfo<T> createNonHAProxy(Configuration conf, InetSocketAddress nnAddr, Class<T> xface, UserGroupInformation ugi, boolean withRetries, AtomicBoolean fallbackToSimpleAuth, AlignmentContext alignmentContext) throws IOException {
        Object proxy;
        Text dtService = SecurityUtil.buildTokenService((InetSocketAddress)nnAddr);
        if (xface == ClientProtocol.class) {
            proxy = NameNodeProxiesClient.createProxyWithAlignmentContext((InetSocketAddress)nnAddr, (Configuration)conf, (UserGroupInformation)ugi, (boolean)withRetries, (AtomicBoolean)fallbackToSimpleAuth, (AlignmentContext)alignmentContext);
        } else if (xface == JournalProtocol.class) {
            proxy = NameNodeProxies.createNNProxyWithJournalProtocol(nnAddr, conf, ugi, alignmentContext);
        } else if (xface == NamenodeProtocol.class) {
            proxy = NameNodeProxies.createNNProxyWithNamenodeProtocol(nnAddr, conf, ugi, withRetries, alignmentContext);
        } else if (xface == GetUserMappingsProtocol.class) {
            proxy = NameNodeProxies.createNNProxyWithGetUserMappingsProtocol(nnAddr, conf, ugi, alignmentContext);
        } else if (xface == RefreshUserMappingsProtocol.class) {
            proxy = NameNodeProxies.createNNProxyWithRefreshUserMappingsProtocol(nnAddr, conf, ugi, alignmentContext);
        } else if (xface == RefreshAuthorizationPolicyProtocol.class) {
            proxy = NameNodeProxies.createNNProxyWithRefreshAuthorizationPolicyProtocol(nnAddr, conf, ugi, alignmentContext);
        } else if (xface == RefreshCallQueueProtocol.class) {
            proxy = NameNodeProxies.createNNProxyWithRefreshCallQueueProtocol(nnAddr, conf, ugi, alignmentContext);
        } else if (xface == BalancerProtocols.class) {
            proxy = NameNodeProxies.createNNProxyWithBalancerProtocol(nnAddr, conf, ugi, withRetries, fallbackToSimpleAuth, alignmentContext);
        } else {
            String message = "Unsupported protocol found when creating the proxy connection to NameNode: " + (xface != null ? xface.getClass().getName() : "null");
            LOG.error((Object)message);
            throw new IllegalStateException(message);
        }
        return new NameNodeProxiesClient.ProxyAndInfo(proxy, dtService, nnAddr);
    }

    private static JournalProtocol createNNProxyWithJournalProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi, AlignmentContext alignmentContext) throws IOException {
        JournalProtocolPB proxy = NameNodeProxies.createNameNodeProxy(address, conf, ugi, JournalProtocolPB.class, alignmentContext);
        return new JournalProtocolTranslatorPB(proxy);
    }

    private static RefreshAuthorizationPolicyProtocol createNNProxyWithRefreshAuthorizationPolicyProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi, AlignmentContext alignmentContext) throws IOException {
        RefreshAuthorizationPolicyProtocolPB proxy = NameNodeProxies.createNameNodeProxy(address, conf, ugi, RefreshAuthorizationPolicyProtocolPB.class, alignmentContext);
        return new RefreshAuthorizationPolicyProtocolClientSideTranslatorPB(proxy);
    }

    private static RefreshUserMappingsProtocol createNNProxyWithRefreshUserMappingsProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi, AlignmentContext alignmentContext) throws IOException {
        RefreshUserMappingsProtocolPB proxy = NameNodeProxies.createNameNodeProxy(address, conf, ugi, RefreshUserMappingsProtocolPB.class, alignmentContext);
        return new RefreshUserMappingsProtocolClientSideTranslatorPB(proxy);
    }

    private static RefreshCallQueueProtocol createNNProxyWithRefreshCallQueueProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi, AlignmentContext alignmentContext) throws IOException {
        RefreshCallQueueProtocolPB proxy = NameNodeProxies.createNameNodeProxy(address, conf, ugi, RefreshCallQueueProtocolPB.class, alignmentContext);
        return new RefreshCallQueueProtocolClientSideTranslatorPB(proxy);
    }

    private static GetUserMappingsProtocol createNNProxyWithGetUserMappingsProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi, AlignmentContext alignmentContext) throws IOException {
        GetUserMappingsProtocolPB proxy = NameNodeProxies.createNameNodeProxy(address, conf, ugi, GetUserMappingsProtocolPB.class, alignmentContext);
        return new GetUserMappingsProtocolClientSideTranslatorPB(proxy);
    }

    private static NamenodeProtocol createNNProxyWithNamenodeProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi, boolean withRetries, AlignmentContext alignmentContext) throws IOException {
        NamenodeProtocolPB proxy = NameNodeProxies.createNameNodeProxy(address, conf, ugi, NamenodeProtocolPB.class, alignmentContext);
        if (withRetries) {
            RetryPolicy timeoutPolicy = RetryPolicies.exponentialBackoffRetry((int)5, (long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
            HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
            methodNameToPolicyMap.put("getBlocks", timeoutPolicy);
            methodNameToPolicyMap.put("getAccessKeys", timeoutPolicy);
            NamenodeProtocolTranslatorPB translatorProxy = new NamenodeProtocolTranslatorPB(proxy);
            return (NamenodeProtocol)RetryProxy.create(NamenodeProtocol.class, (Object)translatorProxy, methodNameToPolicyMap);
        }
        return new NamenodeProtocolTranslatorPB(proxy);
    }

    private static BalancerProtocols createNNProxyWithBalancerProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi, boolean withRetries, AtomicBoolean fallbackToSimpleAuth, AlignmentContext alignmentContext) throws IOException {
        NamenodeProtocol namenodeProtocol = NameNodeProxies.createNNProxyWithNamenodeProtocol(address, conf, ugi, withRetries, alignmentContext);
        ClientProtocol clientProtocol = NameNodeProxiesClient.createProxyWithAlignmentContext((InetSocketAddress)address, (Configuration)conf, (UserGroupInformation)ugi, (boolean)withRetries, (AtomicBoolean)fallbackToSimpleAuth, (AlignmentContext)alignmentContext);
        return (BalancerProtocols)ProxyCombiner.combine(BalancerProtocols.class, (Object[])new Object[]{namenodeProtocol, clientProtocol});
    }

    private static <T> T createNameNodeProxy(InetSocketAddress address, Configuration conf, UserGroupInformation ugi, Class<T> xface, AlignmentContext alignmentContext) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, xface, ProtobufRpcEngine.class);
        return (T)RPC.getProtocolProxy(xface, (long)RPC.getProtocolVersion(xface), (InetSocketAddress)address, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)RPC.getRpcTimeout((Configuration)conf), null, null, (AlignmentContext)alignmentContext).getProxy();
    }
}

