/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;

public class StoragePolicySummary {
    Map<StorageTypeAllocation, Long> storageComboCounts = new HashMap<StorageTypeAllocation, Long>();
    final BlockStoragePolicy[] storagePolicies;
    int totalBlocks;

    StoragePolicySummary(BlockStoragePolicy[] storagePolicies) {
        this.storagePolicies = storagePolicies;
    }

    void add(StorageType[] storageTypes, BlockStoragePolicy policy) {
        StorageTypeAllocation storageCombo = new StorageTypeAllocation(storageTypes, policy);
        Long count = this.storageComboCounts.get(storageCombo);
        if (count == null) {
            this.storageComboCounts.put(storageCombo, 1L);
            storageCombo.setActualStoragePolicy(this.getStoragePolicy(storageCombo.getStorageTypes()));
        } else {
            this.storageComboCounts.put(storageCombo, count + 1L);
        }
        ++this.totalBlocks;
    }

    static List<Map.Entry<StorageTypeAllocation, Long>> sortByComparator(Map<StorageTypeAllocation, Long> unsortMap) {
        LinkedList<Map.Entry<StorageTypeAllocation, Long>> storageAllocations = new LinkedList<Map.Entry<StorageTypeAllocation, Long>>(unsortMap.entrySet());
        Collections.sort(storageAllocations, new Comparator<Map.Entry<StorageTypeAllocation, Long>>(){

            @Override
            public int compare(Map.Entry<StorageTypeAllocation, Long> o1, Map.Entry<StorageTypeAllocation, Long> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        return storageAllocations;
    }

    public String toString() {
        StringBuilder compliantBlocksSB = new StringBuilder();
        compliantBlocksSB.append("\nBlocks satisfying the specified storage policy:");
        compliantBlocksSB.append("\nStorage Policy                  # of blocks       % of blocks\n");
        StringBuilder nonCompliantBlocksSB = new StringBuilder();
        Formatter compliantFormatter = new Formatter(compliantBlocksSB);
        Formatter nonCompliantFormatter = new Formatter(nonCompliantBlocksSB);
        NumberFormat percentFormat = NumberFormat.getPercentInstance();
        percentFormat.setMinimumFractionDigits(4);
        percentFormat.setMaximumFractionDigits(4);
        for (Map.Entry<StorageTypeAllocation, Long> storageComboCount : StoragePolicySummary.sortByComparator(this.storageComboCounts)) {
            double percent = (double)storageComboCount.getValue().longValue() / (double)this.totalBlocks;
            StorageTypeAllocation sta = storageComboCount.getKey();
            if (sta.policyMatches()) {
                compliantFormatter.format("%-25s %10d  %20s%n", sta.getStoragePolicyDescriptor(), storageComboCount.getValue(), percentFormat.format(percent));
                continue;
            }
            if (nonCompliantBlocksSB.length() == 0) {
                nonCompliantBlocksSB.append("\nBlocks NOT satisfying the specified storage policy:");
                nonCompliantBlocksSB.append("\nStorage Policy                  ");
                nonCompliantBlocksSB.append("Specified Storage Policy      # of blocks       % of blocks\n");
            }
            nonCompliantFormatter.format("%-35s %-20s %10d  %20s%n", sta.getStoragePolicyDescriptor(), sta.getSpecifiedStoragePolicy().getName(), storageComboCount.getValue(), percentFormat.format(percent));
        }
        if (nonCompliantBlocksSB.length() == 0) {
            nonCompliantBlocksSB.append("\nAll blocks satisfy specified storage policy.\n");
        }
        compliantFormatter.close();
        nonCompliantFormatter.close();
        return compliantBlocksSB.toString() + nonCompliantBlocksSB;
    }

    private BlockStoragePolicy getStoragePolicy(StorageType[] storageTypes) {
        for (BlockStoragePolicy storagePolicy : this.storagePolicies) {
            int j;
            int i;
            Object[] policyStorageTypes = storagePolicy.getStorageTypes();
            policyStorageTypes = Arrays.copyOf(policyStorageTypes, policyStorageTypes.length);
            Arrays.sort(policyStorageTypes);
            if (policyStorageTypes.length > storageTypes.length) continue;
            for (i = 0; i < policyStorageTypes.length && policyStorageTypes[i] == storageTypes[i]; ++i) {
            }
            if (i < policyStorageTypes.length) continue;
            for (j = policyStorageTypes.length; j < storageTypes.length && policyStorageTypes[i - 1] == storageTypes[j]; ++j) {
            }
            if (j != storageTypes.length) continue;
            return storagePolicy;
        }
        return null;
    }

    static class StorageTypeAllocation {
        private final BlockStoragePolicy specifiedStoragePolicy;
        private final StorageType[] storageTypes;
        private BlockStoragePolicy actualStoragePolicy;

        StorageTypeAllocation(StorageType[] storageTypes, BlockStoragePolicy specifiedStoragePolicy) {
            Arrays.sort(storageTypes);
            this.storageTypes = storageTypes;
            this.specifiedStoragePolicy = specifiedStoragePolicy;
        }

        StorageType[] getStorageTypes() {
            return this.storageTypes;
        }

        BlockStoragePolicy getSpecifiedStoragePolicy() {
            return this.specifiedStoragePolicy;
        }

        void setActualStoragePolicy(BlockStoragePolicy actualStoragePolicy) {
            this.actualStoragePolicy = actualStoragePolicy;
        }

        BlockStoragePolicy getActualStoragePolicy() {
            return this.actualStoragePolicy;
        }

        private static String getStorageAllocationAsString(Map<StorageType, Integer> storageType_countmap) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<StorageType, Integer> storageTypeCountEntry : storageType_countmap.entrySet()) {
                sb.append(storageTypeCountEntry.getKey().name() + ":" + storageTypeCountEntry.getValue() + ",");
            }
            if (sb.length() > 1) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }

        private String getStorageAllocationAsString() {
            EnumMap<StorageType, Integer> storageType_countmap = new EnumMap<StorageType, Integer>(StorageType.class);
            for (StorageType storageType : this.storageTypes) {
                Integer count = (Integer)storageType_countmap.get(storageType);
                if (count == null) {
                    storageType_countmap.put(storageType, 1);
                    continue;
                }
                storageType_countmap.put(storageType, count + 1);
            }
            return StorageTypeAllocation.getStorageAllocationAsString(storageType_countmap);
        }

        String getStoragePolicyDescriptor() {
            StringBuilder storagePolicyDescriptorSB = new StringBuilder();
            if (this.actualStoragePolicy != null) {
                storagePolicyDescriptorSB.append(this.getStorageAllocationAsString()).append("(").append(this.actualStoragePolicy.getName()).append(")");
            } else {
                storagePolicyDescriptorSB.append(this.getStorageAllocationAsString());
            }
            return storagePolicyDescriptorSB.toString();
        }

        boolean policyMatches() {
            return this.specifiedStoragePolicy.equals((Object)this.actualStoragePolicy);
        }

        public String toString() {
            return this.specifiedStoragePolicy.getName() + "|" + this.getStoragePolicyDescriptor();
        }

        public int hashCode() {
            return Objects.hash(this.specifiedStoragePolicy, Arrays.hashCode(this.storageTypes));
        }

        public boolean equals(Object another) {
            return another instanceof StorageTypeAllocation && Objects.equals(this.specifiedStoragePolicy, ((StorageTypeAllocation)another).specifiedStoragePolicy) && Arrays.equals(this.storageTypes, ((StorageTypeAllocation)another).storageTypes);
        }
    }
}

