/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.client.CreateEncryptionZoneFlag;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.tools.AdminHelper;
import org.apache.hadoop.tools.TableListing;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class CryptoAdmin
extends Configured
implements Tool {
    private static final AdminHelper.Command[] COMMANDS = new AdminHelper.Command[]{new CreateZoneCommand(), new ListZonesCommand(), new ProvisionTrashCommand(), new GetFileEncryptionInfoCommand()};

    public CryptoAdmin() {
        this(null);
    }

    public CryptoAdmin(Configuration conf) {
        super(conf);
    }

    public int run(String[] args) throws IOException {
        if (args.length == 0) {
            AdminHelper.printUsage(false, "crypto", COMMANDS);
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return 1;
        }
        AdminHelper.Command command = AdminHelper.determineCommand(args[0], COMMANDS);
        if (command == null) {
            System.err.println("Can't understand command '" + args[0] + "'");
            if (!args[0].startsWith("-")) {
                System.err.println("Command names must start with dashes.");
            }
            AdminHelper.printUsage(false, "crypto", COMMANDS);
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return 1;
        }
        LinkedList<String> argsList = new LinkedList<String>();
        for (int j = 1; j < args.length; ++j) {
            argsList.add(args[j]);
        }
        try {
            return command.run(this.getConf(), argsList);
        }
        catch (IllegalArgumentException e) {
            System.err.println(CryptoAdmin.prettifyException(e));
            return -1;
        }
    }

    public static void main(String[] argsArray) throws Exception {
        CryptoAdmin cryptoAdmin = new CryptoAdmin(new Configuration());
        int res = ToolRunner.run((Tool)cryptoAdmin, (String[])argsArray);
        System.exit(res);
    }

    private static String prettifyException(Exception e) {
        return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage().split("\n")[0];
    }

    private static class ProvisionTrashCommand
    implements AdminHelper.Command {
        private ProvisionTrashCommand() {
        }

        @Override
        public String getName() {
            return "-provisionTrash";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + " -path <path>]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = AdminHelper.getOptionDescriptionListing();
            listing.addRow(new String[]{"<path>", "The path to the root of the encryption zone. "});
            return this.getShortUsage() + "\n" + "Provision a trash directory for an encryption zone.\n\n" + listing.toString();
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            String path = StringUtils.popOptionWithArgument((String)"-path", args);
            if (!args.isEmpty()) {
                System.err.println("Can't understand argument: " + args.get(0));
                return 1;
            }
            Path p = new Path(path);
            HdfsAdmin admin = new HdfsAdmin(p.toUri(), conf);
            try {
                admin.provisionEncryptionZoneTrash(p);
                System.out.println("Created a trash directory for " + path);
            }
            catch (IOException ioe) {
                System.err.println(CryptoAdmin.prettifyException(ioe));
                return 2;
            }
            return 0;
        }
    }

    private static class GetFileEncryptionInfoCommand
    implements AdminHelper.Command {
        private GetFileEncryptionInfoCommand() {
        }

        @Override
        public String getName() {
            return "-getFileEncryptionInfo";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + " -path <path>]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = AdminHelper.getOptionDescriptionListing();
            listing.addRow(new String[]{"<path>", "The path to the file to show encryption info."});
            return this.getShortUsage() + "\n" + "Get encryption info of a file.\n\n" + listing.toString();
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            String path = StringUtils.popOptionWithArgument((String)"-path", args);
            if (!args.isEmpty()) {
                System.err.println("Can't understand argument: " + args.get(0));
                return 1;
            }
            Path p = new Path(path);
            HdfsAdmin admin = new HdfsAdmin(p.toUri(), conf);
            try {
                FileEncryptionInfo fei = admin.getFileEncryptionInfo(p);
                if (fei == null) {
                    System.err.println("No FileEncryptionInfo found for path " + path);
                    return 2;
                }
                System.out.println(fei.toStringStable());
            }
            catch (IOException e) {
                System.err.println(CryptoAdmin.prettifyException(e));
                return 3;
            }
            return 0;
        }
    }

    private static class ListZonesCommand
    implements AdminHelper.Command {
        private ListZonesCommand() {
        }

        @Override
        public String getName() {
            return "-listZones";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + "]\n";
        }

        @Override
        public String getLongUsage() {
            return this.getShortUsage() + "\n" + "List all encryption zones. Requires superuser permissions.\n\n";
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            if (!args.isEmpty()) {
                System.err.println("Can't understand argument: " + args.get(0));
                return 1;
            }
            HdfsAdmin admin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)conf), conf);
            try {
                TableListing listing = new TableListing.Builder().addField("").addField("", true).hideHeaders().build();
                RemoteIterator it = admin.listEncryptionZones();
                while (it.hasNext()) {
                    EncryptionZone ez = (EncryptionZone)it.next();
                    listing.addRow(new String[]{ez.getPath(), ez.getKeyName()});
                }
                System.out.println(listing.toString());
            }
            catch (IOException e) {
                System.err.println(CryptoAdmin.prettifyException(e));
                return 2;
            }
            return 0;
        }
    }

    private static class CreateZoneCommand
    implements AdminHelper.Command {
        private CreateZoneCommand() {
        }

        @Override
        public String getName() {
            return "-createZone";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + " -keyName <keyName> -path <path>]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = AdminHelper.getOptionDescriptionListing();
            listing.addRow(new String[]{"<path>", "The path of the encryption zone to create. It must be an empty directory. A trash directory is provisioned under this path."});
            listing.addRow(new String[]{"<keyName>", "Name of the key to use for the encryption zone."});
            return this.getShortUsage() + "\n" + "Create a new encryption zone.\n\n" + listing.toString();
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            String path = StringUtils.popOptionWithArgument((String)"-path", args);
            if (path == null) {
                System.err.println("You must specify a path with -path.");
                return 1;
            }
            String keyName = StringUtils.popOptionWithArgument((String)"-keyName", args);
            if (keyName == null) {
                System.err.println("You must specify a key name with -keyName.");
                return 1;
            }
            if (!args.isEmpty()) {
                System.err.println("Can't understand argument: " + args.get(0));
                return 1;
            }
            Path p = new Path(path);
            HdfsAdmin admin = new HdfsAdmin(p.toUri(), conf);
            EnumSet<CreateEncryptionZoneFlag> flags = EnumSet.of(CreateEncryptionZoneFlag.PROVISION_TRASH);
            try {
                admin.createEncryptionZone(p, keyName, flags);
                System.out.println("Added encryption zone " + path);
            }
            catch (IOException e) {
                System.err.println(CryptoAdmin.prettifyException(e));
                return 2;
            }
            return 0;
        }
    }
}

