/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.lang.reflect.Array;
import java.util.Comparator;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class SortOrderComparators {
    private SortOrderComparators() {
    }

    public static Comparator<StructLike> forSchema(Schema schema, SortOrder sortOrder) {
        Preconditions.checkArgument((boolean)sortOrder.isSorted(), (Object)"Invalid sort order: unsorted");
        SortOrder.checkCompatibility(sortOrder, schema);
        return new SortOrderComparator(schema, sortOrder);
    }

    private static Comparator<Object> sortFieldComparator(Comparator<Object> original, SortField sortField) {
        Comparator<Object> comparator = original;
        if (sortField == null) {
            return Comparators.nullsFirst().thenComparing(comparator);
        }
        if (sortField.direction() == SortDirection.DESC) {
            comparator = comparator.reversed();
        }
        if (sortField.nullOrder() == NullOrder.NULLS_FIRST) {
            comparator = Comparators.nullsFirst().thenComparing(comparator);
        } else if (sortField.nullOrder() == NullOrder.NULLS_LAST) {
            comparator = Comparators.nullsLast().thenComparing(comparator);
        }
        return comparator;
    }

    private static class SortOrderComparator
    implements Comparator<StructLike> {
        private final SortKey leftKey;
        private final SortKey rightKey;
        private final int size;
        private final Comparator<Object>[] comparators;
        private final Type[] transformResultTypes;

        private SortOrderComparator(Schema schema, SortOrder sortOrder) {
            this.leftKey = new SortKey(schema, sortOrder);
            this.rightKey = new SortKey(schema, sortOrder);
            this.size = sortOrder.fields().size();
            this.comparators = (Comparator[])Array.newInstance(Comparator.class, this.size);
            this.transformResultTypes = (Type[])Array.newInstance(Type.class, this.size);
            for (int i = 0; i < this.size; ++i) {
                SortField sortField = sortOrder.fields().get(i);
                Types.NestedField field = schema.findField(sortField.sourceId());
                Type transformResultType = sortField.transform().getResultType(field.type());
                Preconditions.checkArgument((boolean)transformResultType.isPrimitiveType(), (Object)"Invalid transform result type: non-primitive");
                this.transformResultTypes[i] = transformResultType;
                Comparator comparator = Comparators.forType(transformResultType.asPrimitiveType());
                this.comparators[i] = SortOrderComparators.sortFieldComparator(comparator, sortField);
            }
        }

        @Override
        public int compare(StructLike left, StructLike right) {
            if (left == right) {
                return 0;
            }
            this.leftKey.wrap(left);
            this.rightKey.wrap(right);
            for (int i = 0; i < this.size; ++i) {
                Class<?> valueClass = this.transformResultTypes[i].typeId().javaClass();
                int cmp = this.comparators[i].compare(this.leftKey.get(i, (Class)valueClass), this.rightKey.get(i, (Class)valueClass));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }
}

