/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.BatchScan;
import org.apache.iceberg.BatchScanAdapter;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.IncrementalAppendScan;
import org.apache.iceberg.IncrementalChangelogScan;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionStatisticsFile;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateLocation;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.UpdatePartitionStatistics;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.UpdateStatistics;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;

public interface Table {
    default public String name() {
        return this.toString();
    }

    public void refresh();

    public TableScan newScan();

    default public BatchScan newBatchScan() {
        return new BatchScanAdapter(this.newScan());
    }

    default public IncrementalAppendScan newIncrementalAppendScan() {
        throw new UnsupportedOperationException("Incremental append scan is not supported");
    }

    default public IncrementalChangelogScan newIncrementalChangelogScan() {
        throw new UnsupportedOperationException("Incremental changelog scan is not supported");
    }

    public Schema schema();

    public Map<Integer, Schema> schemas();

    public PartitionSpec spec();

    public Map<Integer, PartitionSpec> specs();

    public SortOrder sortOrder();

    public Map<Integer, SortOrder> sortOrders();

    public Map<String, String> properties();

    public String location();

    public Snapshot currentSnapshot();

    public Snapshot snapshot(long var1);

    public Iterable<Snapshot> snapshots();

    public List<HistoryEntry> history();

    public UpdateSchema updateSchema();

    public UpdatePartitionSpec updateSpec();

    public UpdateProperties updateProperties();

    public ReplaceSortOrder replaceSortOrder();

    public UpdateLocation updateLocation();

    public AppendFiles newAppend();

    default public AppendFiles newFastAppend() {
        return this.newAppend();
    }

    public RewriteFiles newRewrite();

    public RewriteManifests rewriteManifests();

    public OverwriteFiles newOverwrite();

    public RowDelta newRowDelta();

    public ReplacePartitions newReplacePartitions();

    public DeleteFiles newDelete();

    default public UpdateStatistics updateStatistics() {
        throw new UnsupportedOperationException("Updating statistics is not supported by " + this.getClass().getName());
    }

    default public UpdatePartitionStatistics updatePartitionStatistics() {
        throw new UnsupportedOperationException("Updating partition statistics is not supported by " + this.getClass().getName());
    }

    public ExpireSnapshots expireSnapshots();

    public ManageSnapshots manageSnapshots();

    public Transaction newTransaction();

    public FileIO io();

    public EncryptionManager encryption();

    public LocationProvider locationProvider();

    public List<StatisticsFile> statisticsFiles();

    default public List<PartitionStatisticsFile> partitionStatisticsFiles() {
        return ImmutableList.of();
    }

    public Map<String, SnapshotRef> refs();

    default public UUID uuid() {
        throw new UnsupportedOperationException(this.getClass().getName() + " doesn't implement uuid");
    }

    default public Snapshot snapshot(String name) {
        SnapshotRef ref = this.refs().get(name);
        if (ref != null) {
            return this.snapshot(ref.snapshotId());
        }
        return null;
    }
}

