/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseAddedRowsScanTask;
import org.apache.iceberg.BaseDeletedDataFileScanTask;
import org.apache.iceberg.BaseIncrementalScan;
import org.apache.iceberg.ChangelogScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.IncrementalChangelogScan;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestGroup;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.FluentIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.iceberg.util.TableScanUtil;

class BaseIncrementalChangelogScan
extends BaseIncrementalScan<IncrementalChangelogScan, ChangelogScanTask, ScanTaskGroup<ChangelogScanTask>>
implements IncrementalChangelogScan {
    BaseIncrementalChangelogScan(Table table) {
        this(table, table.schema(), TableScanContext.empty());
    }

    private BaseIncrementalChangelogScan(Table table, Schema schema, TableScanContext context) {
        super(table, schema, context);
    }

    @Override
    protected IncrementalChangelogScan newRefinedScan(Table newTable, Schema newSchema, TableScanContext newContext) {
        return new BaseIncrementalChangelogScan(newTable, newSchema, newContext);
    }

    @Override
    protected CloseableIterable<ChangelogScanTask> doPlanFiles(Long fromSnapshotIdExclusive, long toSnapshotIdInclusive) {
        Deque<Snapshot> changelogSnapshots = this.orderedChangelogSnapshots(fromSnapshotIdExclusive, toSnapshotIdInclusive);
        if (changelogSnapshots.isEmpty()) {
            return CloseableIterable.empty();
        }
        Set<Long> changelogSnapshotIds = this.toSnapshotIds(changelogSnapshots);
        ImmutableSet newDataManifests = FluentIterable.from(changelogSnapshots).transformAndConcat(snapshot -> snapshot.dataManifests(this.table().io())).filter(manifest -> changelogSnapshotIds.contains(manifest.snapshotId())).toSet();
        ManifestGroup manifestGroup = new ManifestGroup(this.table().io(), (Iterable<ManifestFile>)newDataManifests, (Iterable<ManifestFile>)ImmutableList.of()).specsById(this.table().specs()).caseSensitive(this.isCaseSensitive()).select(this.scanColumns()).filterData(this.filter()).filterManifestEntries(entry -> changelogSnapshotIds.contains(entry.snapshotId())).ignoreExisting().columnsToKeepStats(this.columnsToKeepStats());
        if (this.shouldIgnoreResiduals()) {
            manifestGroup = manifestGroup.ignoreResiduals();
        }
        if (newDataManifests.size() > 1 && this.shouldPlanWithExecutor()) {
            manifestGroup = manifestGroup.planWith(this.planExecutor());
        }
        return manifestGroup.plan(new CreateDataFileChangeTasks(changelogSnapshots));
    }

    public CloseableIterable<ScanTaskGroup<ChangelogScanTask>> planTasks() {
        return TableScanUtil.planTaskGroups(this.planFiles(), this.targetSplitSize(), this.splitLookback(), this.splitOpenFileCost());
    }

    private Deque<Snapshot> orderedChangelogSnapshots(Long fromIdExcl, long toIdIncl) {
        ArrayDeque<Snapshot> changelogSnapshots = new ArrayDeque<Snapshot>();
        for (Snapshot snapshot : SnapshotUtil.ancestorsBetween(this.table(), toIdIncl, fromIdExcl)) {
            if (snapshot.operation().equals("replace")) continue;
            if (!snapshot.deleteManifests(this.table().io()).isEmpty()) {
                throw new UnsupportedOperationException("Delete files are currently not supported in changelog scans");
            }
            changelogSnapshots.addFirst(snapshot);
        }
        return changelogSnapshots;
    }

    private Set<Long> toSnapshotIds(Collection<Snapshot> snapshots) {
        return snapshots.stream().map(Snapshot::snapshotId).collect(Collectors.toSet());
    }

    private static Map<Long, Integer> computeSnapshotOrdinals(Deque<Snapshot> snapshots) {
        HashMap snapshotOrdinals = Maps.newHashMap();
        int ordinal = 0;
        for (Snapshot snapshot : snapshots) {
            snapshotOrdinals.put(snapshot.snapshotId(), ordinal++);
        }
        return snapshotOrdinals;
    }

    private static class CreateDataFileChangeTasks
    implements ManifestGroup.CreateTasksFunction<ChangelogScanTask> {
        private static final DeleteFile[] NO_DELETES = new DeleteFile[0];
        private final Map<Long, Integer> snapshotOrdinals;

        CreateDataFileChangeTasks(Deque<Snapshot> snapshots) {
            this.snapshotOrdinals = BaseIncrementalChangelogScan.computeSnapshotOrdinals(snapshots);
        }

        @Override
        public CloseableIterable<ChangelogScanTask> apply(CloseableIterable<ManifestEntry<DataFile>> entries, ManifestGroup.TaskContext context) {
            return CloseableIterable.transform(entries, entry -> {
                long commitSnapshotId = entry.snapshotId();
                int changeOrdinal = this.snapshotOrdinals.get(commitSnapshotId);
                DataFile dataFile = (DataFile)((DataFile)entry.file()).copy(context.shouldKeepStats());
                switch (entry.status()) {
                    case ADDED: {
                        return new BaseAddedRowsScanTask(changeOrdinal, commitSnapshotId, dataFile, NO_DELETES, context.schemaAsString(), context.specAsString(), context.residuals());
                    }
                    case DELETED: {
                        return new BaseDeletedDataFileScanTask(changeOrdinal, commitSnapshotId, dataFile, NO_DELETES, context.schemaAsString(), context.specAsString(), context.residuals());
                    }
                }
                throw new IllegalArgumentException("Unexpected entry status: " + (Object)((Object)entry.status()));
            });
        }
    }
}

