/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.iceberg.BaseFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

class GenericDataFile
extends BaseFile<DataFile>
implements DataFile {
    GenericDataFile(Schema avroSchema) {
        super(avroSchema);
    }

    GenericDataFile(int specId, String filePath, FileFormat format, PartitionData partition, long fileSizeInBytes, Metrics metrics, ByteBuffer keyMetadata, List<Long> splitOffsets, Integer sortOrderId) {
        super(specId, FileContent.DATA, filePath, format, partition, fileSizeInBytes, metrics.recordCount(), metrics.columnSizes(), metrics.valueCounts(), metrics.nullValueCounts(), metrics.nanValueCounts(), metrics.lowerBounds(), metrics.upperBounds(), splitOffsets, null, sortOrderId, keyMetadata);
    }

    private GenericDataFile(GenericDataFile toCopy, boolean copyStats, Set<Integer> requestedColumnIds) {
        super(toCopy, copyStats, requestedColumnIds);
    }

    GenericDataFile() {
    }

    public DataFile copyWithoutStats() {
        return new GenericDataFile(this, false, null);
    }

    public DataFile copyWithStats(Set<Integer> requestedColumnIds) {
        return new GenericDataFile(this, true, requestedColumnIds);
    }

    public DataFile copy() {
        return new GenericDataFile(this, true, null);
    }

    @Override
    protected Schema getAvroSchema(Types.StructType partitionStruct) {
        Types.StructType type = DataFile.getType((Types.StructType)partitionStruct);
        return AvroSchemaUtil.convert((Type)type, (Map<Types.StructType, String>)ImmutableMap.of((Object)type, (Object)GenericDataFile.class.getName(), (Object)partitionStruct, (Object)PartitionData.class.getName()));
    }
}

