/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.avro;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.AvroSchemaWithTypeVisitor;
import org.apache.iceberg.avro.SupportsRowPosition;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.avro.ValueReaders;
import org.apache.iceberg.data.avro.DecoderResolver;
import org.apache.iceberg.data.avro.GenericReaders;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class DataReader<T>
implements DatumReader<T>,
SupportsRowPosition {
    private final org.apache.avro.Schema readSchema;
    private final ValueReader<T> reader;
    private org.apache.avro.Schema fileSchema = null;

    public static <D> DataReader<D> create(Schema expectedSchema, org.apache.avro.Schema readSchema) {
        return DataReader.create(expectedSchema, readSchema, ImmutableMap.of());
    }

    public static <D> DataReader<D> create(Schema expectedSchema, org.apache.avro.Schema readSchema, Map<Integer, ?> idToConstant) {
        return new DataReader(expectedSchema, readSchema, idToConstant);
    }

    protected DataReader(Schema expectedSchema, org.apache.avro.Schema readSchema, Map<Integer, ?> idToConstant) {
        this.readSchema = readSchema;
        this.reader = (ValueReader)AvroSchemaWithTypeVisitor.visit(expectedSchema, readSchema, new ReadBuilder(idToConstant));
    }

    public void setSchema(org.apache.avro.Schema newFileSchema) {
        this.fileSchema = org.apache.avro.Schema.applyAliases((org.apache.avro.Schema)newFileSchema, (org.apache.avro.Schema)this.readSchema);
    }

    public T read(T reuse, Decoder decoder) throws IOException {
        return DecoderResolver.resolveAndRead(decoder, this.readSchema, this.fileSchema, this.reader, reuse);
    }

    @Override
    public void setRowPositionSupplier(Supplier<Long> posSupplier) {
        if (this.reader instanceof SupportsRowPosition) {
            ((SupportsRowPosition)((Object)this.reader)).setRowPositionSupplier(posSupplier);
        }
    }

    protected ValueReader<?> createStructReader(Types.StructType struct, List<ValueReader<?>> fields, Map<Integer, ?> idToConstant) {
        return GenericReaders.struct(struct, fields, idToConstant);
    }

    private class ReadBuilder
    extends AvroSchemaWithTypeVisitor<ValueReader<?>> {
        private final Map<Integer, ?> idToConstant;

        private ReadBuilder(Map<Integer, ?> idToConstant) {
            this.idToConstant = idToConstant;
        }

        @Override
        public ValueReader<?> record(Types.StructType struct, org.apache.avro.Schema record, List<String> names, List<ValueReader<?>> fields) {
            return DataReader.this.createStructReader(struct, fields, this.idToConstant);
        }

        @Override
        public ValueReader<?> union(Type ignored, org.apache.avro.Schema union, List<ValueReader<?>> options) {
            return ValueReaders.union(options);
        }

        @Override
        public ValueReader<?> array(Types.ListType ignored, org.apache.avro.Schema array, ValueReader<?> elementReader) {
            return ValueReaders.array(elementReader);
        }

        @Override
        public ValueReader<?> map(Types.MapType iMap, org.apache.avro.Schema map, ValueReader<?> keyReader, ValueReader<?> valueReader) {
            return ValueReaders.arrayMap(keyReader, valueReader);
        }

        @Override
        public ValueReader<?> map(Types.MapType ignored, org.apache.avro.Schema map, ValueReader<?> valueReader) {
            return ValueReaders.map(ValueReaders.strings(), valueReader);
        }

        @Override
        public ValueReader<?> primitive(Type.PrimitiveType ignored, org.apache.avro.Schema primitive) {
            LogicalType logicalType = primitive.getLogicalType();
            if (logicalType != null) {
                switch (logicalType.getName()) {
                    case "date": {
                        return GenericReaders.dates();
                    }
                    case "time-micros": {
                        return GenericReaders.times();
                    }
                    case "timestamp-micros": {
                        if (AvroSchemaUtil.isTimestamptz(primitive)) {
                            return GenericReaders.timestamptz();
                        }
                        return GenericReaders.timestamps();
                    }
                    case "decimal": {
                        return ValueReaders.decimal(ValueReaders.decimalBytesReader(primitive), ((LogicalTypes.Decimal)logicalType).getScale());
                    }
                    case "uuid": {
                        return ValueReaders.uuids();
                    }
                }
                throw new IllegalArgumentException("Unknown logical type: " + logicalType);
            }
            switch (primitive.getType()) {
                case NULL: {
                    return ValueReaders.nulls();
                }
                case BOOLEAN: {
                    return ValueReaders.booleans();
                }
                case INT: {
                    return ValueReaders.ints();
                }
                case LONG: {
                    return ValueReaders.longs();
                }
                case FLOAT: {
                    return ValueReaders.floats();
                }
                case DOUBLE: {
                    return ValueReaders.doubles();
                }
                case STRING: {
                    return ValueReaders.strings();
                }
                case FIXED: {
                    return ValueReaders.fixed(primitive.getFixedSize());
                }
                case BYTES: {
                    return ValueReaders.byteBuffers();
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + primitive);
        }
    }
}

