/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.iceberg.io.ByteBufferInputStream;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterators;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

class MultiBufferInputStream
extends ByteBufferInputStream {
    private static final ByteBuffer EMPTY = ByteBuffer.allocate(0);
    private final List<ByteBuffer> buffers;
    private final long length;
    private Iterator<ByteBuffer> iterator;
    private ByteBuffer current = EMPTY;
    private long position;
    private long mark;
    private long markLimit;
    private List<ByteBuffer> markBuffers;

    MultiBufferInputStream(List<ByteBuffer> buffers) {
        this.buffers = buffers;
        long totalLen = 0L;
        for (ByteBuffer buffer : buffers) {
            totalLen += (long)buffer.remaining();
        }
        this.length = totalLen;
        this.initFromBuffers();
    }

    private void initFromBuffers() {
        this.discardMark();
        this.position = 0L;
        this.iterator = this.buffers.stream().map(ByteBuffer::duplicate).iterator();
        this.nextBuffer();
    }

    public long getPos() {
        return this.position;
    }

    public void seek(long newPosition) throws IOException {
        if (newPosition > this.length) {
            throw new EOFException(String.format("Cannot seek to position after end of file: %s", newPosition));
        }
        if (this.position > newPosition) {
            this.initFromBuffers();
        }
        long bytesToSkip = newPosition - this.position;
        this.skipFully(bytesToSkip);
    }

    public long skip(long n) {
        if (n <= 0L) {
            return 0L;
        }
        if (this.current == null) {
            return -1L;
        }
        long bytesSkipped = 0L;
        while (bytesSkipped < n) {
            if (this.current.remaining() > 0) {
                long bytesToSkip = Math.min(n - bytesSkipped, (long)this.current.remaining());
                this.current.position(this.current.position() + (int)bytesToSkip);
                bytesSkipped += bytesToSkip;
                this.position += bytesToSkip;
                continue;
            }
            if (this.nextBuffer()) continue;
            return bytesSkipped > 0L ? bytesSkipped : -1L;
        }
        return bytesSkipped;
    }

    @Override
    public int read(ByteBuffer out) {
        int len = out.remaining();
        if (len <= 0) {
            return 0;
        }
        if (this.current == null) {
            return -1;
        }
        int bytesCopied = 0;
        while (bytesCopied < len) {
            if (this.current.remaining() > 0) {
                ByteBuffer copyBuffer;
                int bytesToCopy;
                if (this.current.remaining() <= out.remaining()) {
                    bytesToCopy = this.current.remaining();
                    copyBuffer = this.current;
                } else {
                    bytesToCopy = out.remaining();
                    copyBuffer = this.current.duplicate();
                    copyBuffer.limit(copyBuffer.position() + bytesToCopy);
                    this.current.position(copyBuffer.position() + bytesToCopy);
                }
                out.put(copyBuffer);
                bytesCopied += bytesToCopy;
                this.position += (long)bytesToCopy;
                continue;
            }
            if (this.nextBuffer()) continue;
            return bytesCopied > 0 ? bytesCopied : -1;
        }
        return bytesCopied;
    }

    @Override
    public ByteBuffer slice(int len) throws EOFException {
        ByteBuffer slice;
        if (len <= 0) {
            return EMPTY;
        }
        if (this.current == null) {
            throw new EOFException();
        }
        if (len > this.current.remaining()) {
            slice = ByteBuffer.allocate(len);
            int bytesCopied = this.read(slice);
            slice.flip();
            if (bytesCopied < len) {
                throw new EOFException();
            }
        } else {
            slice = this.current.duplicate();
            slice.limit(slice.position() + len);
            this.current.position(slice.position() + len);
            this.position += (long)len;
        }
        return slice;
    }

    @Override
    public List<ByteBuffer> sliceBuffers(long len) throws EOFException {
        if (len <= 0L) {
            return ImmutableList.of();
        }
        if (this.current == null) {
            throw new EOFException();
        }
        ArrayList sliceBuffers = Lists.newArrayList();
        long bytesAccumulated = 0L;
        while (bytesAccumulated < len) {
            if (this.current.remaining() > 0) {
                int bufLen = (int)Math.min(len - bytesAccumulated, (long)this.current.remaining());
                ByteBuffer slice = this.current.duplicate();
                slice.limit(slice.position() + bufLen);
                sliceBuffers.add(slice);
                bytesAccumulated += (long)bufLen;
                this.current.position(this.current.position() + bufLen);
                this.position += (long)bufLen;
                continue;
            }
            if (this.nextBuffer()) continue;
            throw new EOFException();
        }
        return sliceBuffers;
    }

    @Override
    public List<ByteBuffer> remainingBuffers() {
        if (this.position >= this.length) {
            return Collections.emptyList();
        }
        try {
            return this.sliceBuffers(this.length - this.position);
        }
        catch (EOFException e) {
            throw new RuntimeException("[Parquet bug] Stream is bad: incorrect bytes remaining " + (this.length - this.position));
        }
    }

    public int read(byte[] bytes, int off, int len) {
        if (len <= 0) {
            if (len < 0) {
                throw new IndexOutOfBoundsException("Read length must be greater than 0: " + len);
            }
            return 0;
        }
        if (this.current == null) {
            return -1;
        }
        int bytesRead = 0;
        while (bytesRead < len) {
            if (this.current.remaining() > 0) {
                int bytesToRead = Math.min(len - bytesRead, this.current.remaining());
                this.current.get(bytes, off + bytesRead, bytesToRead);
                bytesRead += bytesToRead;
                this.position += (long)bytesToRead;
                continue;
            }
            if (this.nextBuffer()) continue;
            return bytesRead > 0 ? bytesRead : -1;
        }
        return bytesRead;
    }

    public int read(byte[] bytes) {
        return this.read(bytes, 0, bytes.length);
    }

    public int read() throws IOException {
        if (this.current == null) {
            throw new EOFException();
        }
        do {
            if (this.current.remaining() <= 0) continue;
            ++this.position;
            return this.current.get() & 0xFF;
        } while (this.nextBuffer());
        throw new EOFException();
    }

    public int available() {
        long remaining = this.length - this.position;
        if (remaining > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)remaining;
    }

    public void mark(int readlimit) {
        if (this.mark >= 0L) {
            this.discardMark();
        }
        this.mark = this.position;
        this.markLimit = this.mark + (long)readlimit + 1L;
        if (this.current != null) {
            this.markBuffers.add(this.current.duplicate());
        }
    }

    public void reset() throws IOException {
        if (this.mark < 0L || this.position >= this.markLimit) {
            throw new IOException("No mark defined or has read past the previous mark limit");
        }
        this.position = this.mark;
        this.iterator = Iterators.concat(this.markBuffers.iterator(), this.iterator);
        this.discardMark();
        this.nextBuffer();
    }

    private void discardMark() {
        this.mark = -1L;
        this.markLimit = 0L;
        this.markBuffers = Lists.newArrayList();
    }

    public boolean markSupported() {
        return true;
    }

    private boolean nextBuffer() {
        if (!this.iterator.hasNext()) {
            this.current = null;
            return false;
        }
        this.current = this.iterator.next().duplicate();
        if (this.mark >= 0L) {
            if (this.position < this.markLimit) {
                this.markBuffers.add(this.current.duplicate());
            } else {
                this.discardMark();
            }
        }
        return true;
    }
}

