/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.puffin;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.puffin.BlobMetadata;
import org.apache.iceberg.puffin.FileMetadata;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.util.JsonUtil;

public final class FileMetadataParser {
    private static final String BLOBS = "blobs";
    private static final String PROPERTIES = "properties";
    private static final String TYPE = "type";
    private static final String FIELDS = "fields";
    private static final String SNAPSHOT_ID = "snapshot-id";
    private static final String SEQUENCE_NUMBER = "sequence-number";
    private static final String OFFSET = "offset";
    private static final String LENGTH = "length";
    private static final String COMPRESSION_CODEC = "compression-codec";

    private FileMetadataParser() {
    }

    public static String toJson(FileMetadata fileMetadata, boolean pretty) {
        return JsonUtil.generate(gen -> FileMetadataParser.toJson(fileMetadata, gen), pretty);
    }

    public static FileMetadata fromJson(String json) {
        return JsonUtil.parse(json, FileMetadataParser::fromJson);
    }

    static FileMetadata fromJson(JsonNode json) {
        return FileMetadataParser.fileMetadataFromJson(json);
    }

    static void toJson(FileMetadata fileMetadata, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeArrayFieldStart(BLOBS);
        for (BlobMetadata blobMetadata : fileMetadata.blobs()) {
            FileMetadataParser.toJson(blobMetadata, generator);
        }
        generator.writeEndArray();
        if (!fileMetadata.properties().isEmpty()) {
            JsonUtil.writeStringMap(PROPERTIES, fileMetadata.properties(), generator);
        }
        generator.writeEndObject();
    }

    static FileMetadata fileMetadataFromJson(JsonNode json) {
        ImmutableList.Builder blobs = ImmutableList.builder();
        JsonNode blobsJson = JsonUtil.get(BLOBS, json);
        Preconditions.checkArgument((boolean)blobsJson.isArray(), (String)"Cannot parse blobs from non-array: %s", (Object)blobsJson);
        for (JsonNode blobJson : blobsJson) {
            blobs.add((Object)FileMetadataParser.blobMetadataFromJson(blobJson));
        }
        Object properties = ImmutableMap.of();
        JsonNode propertiesJson = json.get(PROPERTIES);
        if (propertiesJson != null) {
            properties = JsonUtil.getStringMap(PROPERTIES, json);
        }
        return new FileMetadata((List<BlobMetadata>)blobs.build(), (Map<String, String>)properties);
    }

    static void toJson(BlobMetadata blobMetadata, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField(TYPE, blobMetadata.type());
        JsonUtil.writeIntegerArray(FIELDS, blobMetadata.inputFields(), generator);
        generator.writeNumberField(SNAPSHOT_ID, blobMetadata.snapshotId());
        generator.writeNumberField(SEQUENCE_NUMBER, blobMetadata.sequenceNumber());
        generator.writeNumberField(OFFSET, blobMetadata.offset());
        generator.writeNumberField(LENGTH, blobMetadata.length());
        if (blobMetadata.compressionCodec() != null) {
            generator.writeStringField(COMPRESSION_CODEC, blobMetadata.compressionCodec());
        }
        if (!blobMetadata.properties().isEmpty()) {
            JsonUtil.writeStringMap(PROPERTIES, blobMetadata.properties(), generator);
        }
        generator.writeEndObject();
    }

    static BlobMetadata blobMetadataFromJson(JsonNode json) {
        String type = JsonUtil.getString(TYPE, json);
        List<Integer> fields = JsonUtil.getIntegerList(FIELDS, json);
        long snapshotId = JsonUtil.getLong(SNAPSHOT_ID, json);
        long sequenceNumber = JsonUtil.getLong(SEQUENCE_NUMBER, json);
        long offset = JsonUtil.getLong(OFFSET, json);
        long length = JsonUtil.getLong(LENGTH, json);
        String compressionCodec = JsonUtil.getStringOrNull(COMPRESSION_CODEC, json);
        Object properties = ImmutableMap.of();
        JsonNode propertiesJson = json.get(PROPERTIES);
        if (propertiesJson != null) {
            properties = JsonUtil.getStringMap(PROPERTIES, json);
        }
        return new BlobMetadata(type, fields, snapshotId, sequenceNumber, offset, length, compressionCodec, (Map<String, String>)properties);
    }
}

