/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.BitSet;
import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.BitmapContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.FastRankRoaringBitmap;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.Util;

public class BitSetUtil {
    public static final int BLOCK_LENGTH = 1024;

    public static char[] arrayContainerBufferOf(int from, int to, int cardinality, long[] words) {
        char[] content = new char[cardinality];
        int index = 0;
        int i = from;
        int socket = 0;
        while (i < to) {
            for (long word = words[i]; word != 0L; word &= word - 1L) {
                content[index++] = (char)(socket + Long.numberOfTrailingZeros(word));
            }
            ++i;
            socket += 64;
        }
        return content;
    }

    private static ArrayContainer arrayContainerOf(int from, int to, int cardinality, long[] words) {
        return new ArrayContainer(BitSetUtil.arrayContainerBufferOf(from, to, cardinality, words));
    }

    public static RoaringBitmap bitmapOf(BitSet bitSet) {
        return BitSetUtil.bitmapOf(bitSet.toLongArray());
    }

    public static RoaringBitmap bitmapOf(long[] words) {
        RoaringBitmap ans = new RoaringBitmap();
        int containerIndex = 0;
        for (int from = 0; from < words.length; from += 1024) {
            int to = Math.min(from + 1024, words.length);
            int blockCardinality = BitSetUtil.cardinality(from, to, words);
            if (blockCardinality <= 0) continue;
            ans.highLowContainer.insertNewKeyValueAt(containerIndex++, Util.highbits(from * 64), BitSetUtil.containerOf(from, to, blockCardinality, words));
        }
        return ans;
    }

    public static RoaringBitmap bitmapOf(ByteBuffer bb, boolean fastRank) {
        return BitSetUtil.bitmapOf(bb, fastRank, new long[1024]);
    }

    public static RoaringBitmap bitmapOf(ByteBuffer bb, boolean fastRank, long[] wordsBuffer) {
        long word;
        if (wordsBuffer.length != 1024) {
            throw new IllegalArgumentException("wordsBuffer length should be 1024");
        }
        bb = bb.slice().order(ByteOrder.LITTLE_ENDIAN);
        RoaringBitmap ans = fastRank ? new FastRankRoaringBitmap() : new RoaringBitmap();
        int containerIndex = 0;
        int blockLength = 0;
        int blockCardinality = 0;
        int offset = 0;
        while (bb.remaining() >= 8) {
            word = bb.getLong();
            wordsBuffer[blockLength++] = word;
            blockCardinality += Long.bitCount(word);
            if (blockLength != 1024) continue;
            if (blockCardinality > 0) {
                ans.highLowContainer.insertNewKeyValueAt(containerIndex++, Util.highbits(offset), BitSetUtil.containerOf(0, blockLength, blockCardinality, wordsBuffer));
            }
            offset += 65536;
            blockCardinality = 0;
            blockLength = 0;
        }
        if (bb.remaining() > 0) {
            word = 0L;
            int remaining = bb.remaining();
            for (int j = 0; j < remaining; ++j) {
                word |= ((long)bb.get() & 0xFFL) << 8 * j;
            }
            if (word != 0L) {
                wordsBuffer[blockLength++] = word;
                blockCardinality += Long.bitCount(word);
            }
        }
        if (blockCardinality > 0) {
            ans.highLowContainer.insertNewKeyValueAt(containerIndex, Util.highbits(offset), BitSetUtil.containerOf(0, blockLength, blockCardinality, wordsBuffer));
        }
        return ans;
    }

    private static int cardinality(int from, int to, long[] words) {
        int sum = 0;
        for (int i = from; i < to; ++i) {
            sum += Long.bitCount(words[i]);
        }
        return sum;
    }

    private static Container containerOf(int from, int to, int blockCardinality, long[] words) {
        if (blockCardinality <= 4096) {
            return BitSetUtil.arrayContainerOf(from, to, blockCardinality, words);
        }
        long[] container = new long[1024];
        System.arraycopy(words, from, container, 0, to - from);
        return new BitmapContainer(container, blockCardinality);
    }

    public static boolean equals(BitSet bitset, RoaringBitmap bitmap) {
        if (bitset.cardinality() != bitmap.getCardinality()) {
            return false;
        }
        PeekableIntIterator it = bitmap.getIntIterator();
        while (it.hasNext()) {
            int val = it.next();
            if (bitset.get(val)) continue;
            return false;
        }
        return true;
    }
}

