/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.plc4x.java.api.messages.PlcDiscoveryItemHandler;
import org.apache.plc4x.java.api.messages.PlcDiscoveryRequest;
import org.apache.plc4x.java.api.messages.PlcDiscoveryResponse;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.messages.PlcDiscoverer;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DefaultPlcDiscoveryRequest
implements PlcDiscoveryRequest,
Serializable {
    private final PlcDiscoverer discoverer;
    private final LinkedHashMap<String, String> queries;

    public DefaultPlcDiscoveryRequest(PlcDiscoverer discoverer, LinkedHashMap<String, String> queries) {
        this.discoverer = discoverer;
        this.queries = queries;
    }

    public CompletableFuture<? extends PlcDiscoveryResponse> execute() {
        return this.discoverer.discover(this);
    }

    public PlcDiscoverer getDiscoverer() {
        return this.discoverer;
    }

    public Map<String, String> getQueries() {
        return this.queries;
    }

    public CompletableFuture<? extends PlcDiscoveryResponse> executeWithHandler(PlcDiscoveryItemHandler handler) {
        return this.discoverer.discoverWithHandler(this, handler);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcDiscoveryRequest", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcDiscoveryRequest", new WithWriterArgs[0]);
    }

    public static class Builder
    implements PlcDiscoveryRequest.Builder {
        private final PlcDiscoverer discoverer;
        private final LinkedHashMap<String, String> queries;

        public Builder(PlcDiscoverer discoverer) {
            this.discoverer = discoverer;
            this.queries = new LinkedHashMap();
        }

        public PlcDiscoveryRequest.Builder addQuery(String name, String query) {
            this.queries.put(name, query);
            return this;
        }

        public PlcDiscoveryRequest build() {
            return new DefaultPlcDiscoveryRequest(this.discoverer, this.queries);
        }
    }
}

