/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.compress;

import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseCompressionAlgorithm;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePassThruStream;
import com.clickhouse.data.stream.Lz4InputStream;
import com.clickhouse.data.stream.Lz4OutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Lz4Support {
    public static ClickHouseCompressionAlgorithm getInstance() {
        return Factory.instance;
    }

    private Lz4Support() {
    }

    static final class Factory {
        private static final ClickHouseCompressionAlgorithm instance = new DefaultImpl();

        private Factory() {
        }
    }

    public static class DefaultImpl
    implements ClickHouseCompressionAlgorithm {
        protected int normalize(int level) {
            return level < 0 ? -1 : level;
        }

        @Override
        public ClickHouseOutputStream compress(ClickHousePassThruStream stream, OutputStream output, int bufferSize, int level, Runnable postCloseAction) throws IOException {
            return new Lz4OutputStream(output, this.normalize(level), bufferSize, null);
        }

        @Override
        public ClickHouseInputStream decompress(ClickHousePassThruStream stream, InputStream input, int bufferSize, int level, Runnable postCloseAction) throws IOException {
            return new Lz4InputStream(input);
        }

        @Override
        public ClickHouseCompression getAlgorithm() {
            return ClickHouseCompression.LZ4;
        }
    }
}

