/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.RequestContext;
import com.mongodb.ServerApi;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncClientSession;
import com.mongodb.internal.binding.AbstractReferenceCounted;
import com.mongodb.internal.binding.AsyncClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.binding.AsyncReadWriteBinding;
import com.mongodb.internal.binding.TransactionContext;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.session.ClientSessionContext;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import org.bson.BsonTimestamp;

public class ClientSessionBinding
extends AbstractReferenceCounted
implements AsyncReadWriteBinding {
    private final AsyncClusterAwareReadWriteBinding wrapped;
    private final AsyncClientSession session;
    private final boolean ownsSession;
    private final ClientSessionContext sessionContext;

    public ClientSessionBinding(AsyncClientSession session, boolean ownsSession, AsyncClusterAwareReadWriteBinding wrapped) {
        this.wrapped = Assertions.notNull("wrapped", wrapped).retain();
        this.ownsSession = ownsSession;
        this.session = Assertions.notNull("session", session);
        this.sessionContext = new AsyncClientSessionContext(session);
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public void getReadConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
        this.isConnectionSourcePinningRequired((isConnectionSourcePinningRequired, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else if (isConnectionSourcePinningRequired.booleanValue()) {
                this.getPinnedConnectionSource(true, callback);
            } else {
                this.wrapped.getReadConnectionSource(new WrappingCallback(callback));
            }
        });
    }

    @Override
    public void getWriteConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
        this.isConnectionSourcePinningRequired((isConnectionSourcePinningRequired, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else if (isConnectionSourcePinningRequired.booleanValue()) {
                this.getPinnedConnectionSource(false, callback);
            } else {
                this.wrapped.getWriteConnectionSource(new WrappingCallback(callback));
            }
        });
    }

    @Override
    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Override
    @Nullable
    public ServerApi getServerApi() {
        return this.wrapped.getServerApi();
    }

    @Override
    public RequestContext getRequestContext() {
        return this.wrapped.getRequestContext();
    }

    private void getPinnedConnectionSource(boolean isRead, SingleResultCallback<AsyncConnectionSource> callback) {
        WrappingCallback wrappingCallback = new WrappingCallback(callback);
        Object transactionContext = TransactionContext.get(this.session);
        if (transactionContext == null) {
            SingleResultCallback<AsyncConnectionSource> connectionSourceCallback = (result, t) -> {
                if (t != null) {
                    wrappingCallback.onResult(null, t);
                } else {
                    TransactionContext newTransactionContext = new TransactionContext(this.wrapped.getCluster().getDescription().getType());
                    this.session.setTransactionContext(result.getServerDescription().getAddress(), newTransactionContext);
                    newTransactionContext.release();
                    wrappingCallback.onResult((AsyncConnectionSource)result, (Throwable)null);
                }
            };
            if (isRead) {
                this.wrapped.getReadConnectionSource(connectionSourceCallback);
            } else {
                this.wrapped.getWriteConnectionSource(connectionSourceCallback);
            }
        } else {
            this.wrapped.getConnectionSource(this.session.getPinnedServerAddress(), new WrappingCallback(callback));
        }
    }

    @Override
    public AsyncReadWriteBinding retain() {
        super.retain();
        return this;
    }

    @Override
    public void getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference, SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getReadConnectionSource(minWireVersion, fallbackReadPreference, callback);
    }

    @Override
    public int release() {
        int count = super.release();
        if (count == 0) {
            this.wrapped.release();
            if (this.ownsSession) {
                this.session.close();
            }
        }
        return count;
    }

    private void isConnectionSourcePinningRequired(SingleResultCallback<Boolean> callback) {
        try {
            callback.onResult(this.isConnectionSourcePinningRequired(), null);
        }
        catch (RuntimeException e) {
            callback.onResult(null, e);
        }
    }

    private boolean isConnectionSourcePinningRequired() {
        ClusterType clusterType = this.wrapped.getCluster().getDescription().getType();
        return this.session.hasActiveTransaction() && (clusterType == ClusterType.SHARDED || clusterType == ClusterType.LOAD_BALANCED);
    }

    private final class AsyncClientSessionContext
    extends ClientSessionContext
    implements SessionContext {
        private final AsyncClientSession clientSession;

        AsyncClientSessionContext(AsyncClientSession clientSession) {
            super(clientSession);
            this.clientSession = clientSession;
        }

        @Override
        public boolean isImplicitSession() {
            return ClientSessionBinding.this.ownsSession;
        }

        @Override
        public boolean notifyMessageSent() {
            return this.clientSession.notifyMessageSent();
        }

        @Override
        public boolean isSnapshot() {
            Boolean snapshot = this.clientSession.getOptions().isSnapshot();
            return snapshot != null && snapshot != false;
        }

        @Override
        public void setSnapshotTimestamp(BsonTimestamp snapshotTimestamp) {
            this.clientSession.setSnapshotTimestamp(snapshotTimestamp);
        }

        @Override
        @Nullable
        public BsonTimestamp getSnapshotTimestamp() {
            return this.clientSession.getSnapshotTimestamp();
        }

        @Override
        public boolean hasActiveTransaction() {
            return this.clientSession.hasActiveTransaction();
        }

        @Override
        public ReadConcern getReadConcern() {
            if (this.clientSession.hasActiveTransaction()) {
                return this.clientSession.getTransactionOptions().getReadConcern();
            }
            if (this.isSnapshot()) {
                return ReadConcern.SNAPSHOT;
            }
            return ClientSessionBinding.this.wrapped.getSessionContext().getReadConcern();
        }
    }

    private class WrappingCallback
    implements SingleResultCallback<AsyncConnectionSource> {
        private final SingleResultCallback<AsyncConnectionSource> callback;

        WrappingCallback(SingleResultCallback<AsyncConnectionSource> callback) {
            this.callback = callback;
        }

        @Override
        public void onResult(AsyncConnectionSource result, Throwable t) {
            if (t != null) {
                this.callback.onResult(null, t);
            } else {
                this.callback.onResult(new SessionBindingAsyncConnectionSource(result), null);
            }
        }
    }

    private class SessionBindingAsyncConnectionSource
    implements AsyncConnectionSource {
        private AsyncConnectionSource wrapped;

        SessionBindingAsyncConnectionSource(AsyncConnectionSource wrapped) {
            this.wrapped = wrapped;
            ClientSessionBinding.this.retain();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        @Override
        public SessionContext getSessionContext() {
            return ClientSessionBinding.this.sessionContext;
        }

        @Override
        @Nullable
        public ServerApi getServerApi() {
            return this.wrapped.getServerApi();
        }

        @Override
        public RequestContext getRequestContext() {
            return this.wrapped.getRequestContext();
        }

        @Override
        public ReadPreference getReadPreference() {
            return this.wrapped.getReadPreference();
        }

        @Override
        public void getConnection(SingleResultCallback<AsyncConnection> callback) {
            Object transactionContext = TransactionContext.get(ClientSessionBinding.this.session);
            if (transactionContext != null && ((TransactionContext)transactionContext).isConnectionPinningRequired()) {
                AsyncConnection pinnedConnection = (AsyncConnection)((TransactionContext)transactionContext).getPinnedConnection();
                if (pinnedConnection == null) {
                    this.wrapped.getConnection((connection, t) -> {
                        if (t != null) {
                            callback.onResult(null, t);
                        } else {
                            transactionContext.pinConnection(connection, AsyncConnection::markAsPinned);
                            callback.onResult((AsyncConnection)connection, null);
                        }
                    });
                } else {
                    callback.onResult(pinnedConnection.retain(), null);
                }
            } else {
                this.wrapped.getConnection(callback);
            }
        }

        @Override
        public AsyncConnectionSource retain() {
            this.wrapped = this.wrapped.retain();
            return this;
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public int release() {
            int count = this.wrapped.release();
            if (count == 0) {
                ClientSessionBinding.this.release();
            }
            return count;
        }
    }
}

