/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.data;

import com.vesoft.nebula.Coordinate;
import com.vesoft.nebula.LineString;
import com.vesoft.nebula.client.graph.data.BaseDataObject;
import com.vesoft.nebula.client.graph.data.CoordinateWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LineStringWrapper
extends BaseDataObject {
    private final LineString lineString;

    public LineStringWrapper(LineString lineString) {
        this.lineString = lineString;
    }

    public List<CoordinateWrapper> getCoordinateList() {
        ArrayList<CoordinateWrapper> coordList = new ArrayList<CoordinateWrapper>();
        for (Coordinate coord : this.lineString.getCoordList()) {
            coordList.add(new CoordinateWrapper(coord));
        }
        return coordList;
    }

    public int hashCode() {
        return Objects.hash(this.lineString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineStringWrapper that = (LineStringWrapper)o;
        List<CoordinateWrapper> thisList = this.getCoordinateList();
        List<CoordinateWrapper> thatList = that.getCoordinateList();
        if (thisList.size() != thatList.size()) {
            return false;
        }
        for (int i = 0; i < thisList.size(); ++i) {
            if (thisList.get(i).equals(thatList.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LINESTRING");
        sb.append('(');
        if (this.lineString.getCoordList() != null) {
            for (Coordinate coordinate : this.lineString.getCoordList()) {
                sb.append(coordinate.getX());
                sb.append(' ');
                sb.append(coordinate.getY());
                sb.append(',');
            }
            if (sb.charAt(sb.length() - 1) == ',') {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        sb.append(')');
        return sb.toString();
    }
}

