/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.builder;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.fory.Fory;
import org.apache.fory.builder.AccessorHelper;
import org.apache.fory.codegen.CodegenContext;
import org.apache.fory.codegen.Expression;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.reflect.TypeRef;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.ClassInfoHolder;
import org.apache.fory.type.Descriptor;
import org.apache.fory.type.FinalObjectTypeStub;
import org.apache.fory.type.TypeUtils;
import org.apache.fory.util.GraalvmSupport;
import org.apache.fory.util.Preconditions;
import org.apache.fory.util.StringUtils;
import org.apache.fory.util.function.Functions;
import org.apache.fory.util.record.RecordComponent;
import org.apache.fory.util.record.RecordUtils;

public abstract class CodecBuilder {
    protected static final String ROOT_OBJECT_NAME = "_f_obj";
    protected static final String FORY_NAME = "_f_fory";
    static TypeRef<Object[]> objectArrayTypeRef = TypeRef.of(Object[].class);
    static TypeRef<MemoryBuffer> bufferTypeRef = TypeRef.of(MemoryBuffer.class);
    static TypeRef<ClassInfo> classInfoTypeRef = TypeRef.of(ClassInfo.class);
    static TypeRef<ClassInfoHolder> classInfoHolderTypeRef = TypeRef.of(ClassInfoHolder.class);
    protected final CodegenContext ctx;
    protected final TypeRef<?> beanType;
    protected final Class<?> beanClass;
    protected final boolean isRecord;
    protected final boolean isInterface;
    private final Set<String> duplicatedFields;
    protected Expression.Reference foryRef = Expression.Reference.fieldRef("_f_fory", TypeRef.of(Fory.class));
    public static final Expression.Reference recordComponentDefaultValues = new Expression.Reference("recordComponentDefaultValues", TypeUtils.OBJECT_ARRAY_TYPE);
    protected final Map<String, Expression.Reference> fieldMap = new HashMap<String, Expression.Reference>();
    protected boolean recordCtrAccessible;

    public CodecBuilder(CodegenContext ctx, TypeRef<?> beanType) {
        this.ctx = ctx;
        this.beanType = beanType;
        this.beanClass = TypeUtils.getRawType(beanType);
        this.isRecord = RecordUtils.isRecord(this.beanClass);
        this.isInterface = this.beanClass.isInterface();
        if (this.isRecord) {
            this.recordCtrAccessible = CodecBuilder.recordCtrAccessible(this.beanClass);
        }
        this.duplicatedFields = Descriptor.getSortedDuplicatedMembers(this.beanClass).keySet();
        ctx.reserveName(FORY_NAME);
        ctx.reserveName(ROOT_OBJECT_NAME);
        ReflectionUtils.getFields(beanType.getRawType(), true).stream().map(Field::getName).collect(Collectors.toSet()).forEach(ctx::reserveName);
    }

    public abstract String genCode();

    public abstract Expression buildEncodeExpression();

    protected boolean sourcePublicAccessible(Class<?> cls) {
        return this.ctx.sourcePublicAccessible(cls);
    }

    protected boolean fieldNullable(Descriptor descriptor) {
        return false;
    }

    protected Expression tryInlineCast(Expression expression, TypeRef<?> targetType) {
        return this.tryCastIfPublic(expression, targetType, true);
    }

    protected Expression tryCastIfPublic(Expression expression, TypeRef<?> targetType) {
        return this.tryCastIfPublic(expression, targetType, false);
    }

    protected Expression tryCastIfPublic(Expression expression, TypeRef<?> targetType, boolean inline) {
        Class<?> rawType = TypeUtils.getRawType(targetType);
        if (rawType == FinalObjectTypeStub.class) {
            return expression;
        }
        if (inline) {
            if (this.sourcePublicAccessible(rawType)) {
                return new Expression.Cast(expression, targetType);
            }
            return new Expression.Cast(expression, ReflectionUtils.getPublicSuperType(TypeRef.of(rawType)));
        }
        return this.tryCastIfPublic(expression, targetType, "castedValue");
    }

    protected Expression tryCastIfPublic(Expression expression, TypeRef<?> targetType, String valuePrefix) {
        Class<?> rawType = TypeUtils.getRawType(targetType);
        if (this.sourcePublicAccessible(rawType) && !expression.type().wrap().isSubtypeOf(targetType.wrap())) {
            return new Expression.Cast(expression, targetType, valuePrefix);
        }
        return expression;
    }

    protected Expression.Reference getRecordCtrHandle() {
        String fieldName = "_record_ctr_";
        Expression.Reference fieldRef = this.fieldMap.get(fieldName);
        if (fieldRef == null) {
            Expression.StaticInvoke getRecordCtrHandle = new Expression.StaticInvoke(RecordUtils.class, "getRecordCtrHandle", TypeRef.of(MethodHandle.class), this.beanClassExpr());
            this.ctx.addField(this.ctx.type(MethodHandle.class), fieldName, (Expression)getRecordCtrHandle);
            fieldRef = new Expression.Reference(fieldName, TypeRef.of(MethodHandle.class));
            this.fieldMap.put(fieldName, fieldRef);
        }
        return fieldRef;
    }

    protected Expression buildDefaultComponentsArray() {
        return new Expression.StaticInvoke(Platform.class, "copyObjectArray", TypeUtils.OBJECT_ARRAY_TYPE, recordComponentDefaultValues);
    }

    protected Expression getFieldValue(Expression inputBeanExpr, Descriptor descriptor) {
        TypeRef<?> fieldType = descriptor.getTypeRef();
        Class<?> rawType = descriptor.getRawType();
        String fieldName = descriptor.getName();
        boolean fieldNullable = this.fieldNullable(descriptor);
        if (this.isInterface) {
            return new Expression.Invoke(inputBeanExpr, descriptor.getName(), fieldName, fieldType, fieldNullable, new Expression[0]);
        }
        if (this.isRecord) {
            return this.getRecordFieldValue(inputBeanExpr, descriptor);
        }
        if (this.duplicatedFields.contains(fieldName) || !Modifier.isPublic(this.beanClass.getModifiers())) {
            return this.unsafeAccessField(inputBeanExpr, this.beanClass, descriptor);
        }
        if (!this.sourcePublicAccessible(rawType)) {
            fieldType = TypeUtils.OBJECT_TYPE;
        }
        if (Modifier.isPublic(descriptor.getModifiers())) {
            return new Expression.FieldValue(inputBeanExpr, fieldName, fieldType, fieldNullable, false);
        }
        if (descriptor.getReadMethod() != null && Modifier.isPublic(descriptor.getReadMethod().getModifiers())) {
            return new Expression.Invoke(inputBeanExpr, descriptor.getReadMethod().getName(), fieldName, fieldType, fieldNullable, new Expression[0]);
        }
        if (!Modifier.isPrivate(descriptor.getModifiers()) && AccessorHelper.defineAccessor(descriptor.getField())) {
            return new Expression.StaticInvoke(AccessorHelper.getAccessorClass(descriptor.getField()), fieldName, fieldType, fieldNullable, inputBeanExpr);
        }
        if (descriptor.getReadMethod() != null && !Modifier.isPrivate(descriptor.getReadMethod().getModifiers()) && AccessorHelper.defineAccessor(descriptor.getReadMethod())) {
            return new Expression.StaticInvoke(AccessorHelper.getAccessorClass(descriptor.getReadMethod()), descriptor.getReadMethod().getName(), fieldType, fieldNullable, inputBeanExpr);
        }
        return this.unsafeAccessField(inputBeanExpr, this.beanClass, descriptor);
    }

    private Expression getRecordFieldValue(Expression inputBeanExpr, Descriptor descriptor) {
        TypeRef<?> fieldType = descriptor.getTypeRef();
        if (!this.sourcePublicAccessible(descriptor.getRawType())) {
            fieldType = TypeUtils.OBJECT_TYPE;
        }
        String fieldName = descriptor.getName();
        boolean fieldNullable = this.fieldNullable(descriptor);
        if (Modifier.isPublic(this.beanClass.getModifiers())) {
            Preconditions.checkNotNull(descriptor.getReadMethod());
            return new Expression.Invoke(inputBeanExpr, descriptor.getReadMethod().getName(), fieldName, fieldType, fieldNullable, new Expression[0]);
        }
        String key = "_" + fieldName + "_getter_";
        Expression.Reference ref = this.fieldMap.get(key);
        Tuple2<Class<?>, String> methodInfo = Functions.getterMethodInfo(descriptor.getRawType());
        if (ref == null) {
            Class funcInterface = (Class)methodInfo.f0;
            TypeRef getterType = TypeRef.of(funcInterface);
            if (GraalvmSupport.isGraalBuildtime()) {
                Functions.makeGetterFunction(this.beanClass, fieldName);
            }
            Expression.Inlineable getter = new Expression.StaticInvoke(Functions.class, "makeGetterFunction", TypeUtils.OBJECT_TYPE, this.beanClassExpr(), Expression.Literal.ofString(fieldName));
            getter = new Expression.Cast(getter, getterType);
            this.ctx.addField(funcInterface, key, (Expression)getter);
            ref = new Expression.Reference(key, getterType);
            this.fieldMap.put(key, ref);
        }
        if (!fieldType.isPrimitive()) {
            Expression.Invoke v = Expression.Invoke.inlineInvoke((Expression)ref, (String)methodInfo.f1, TypeUtils.OBJECT_TYPE, fieldNullable, inputBeanExpr);
            return this.tryCastIfPublic((Expression)v, descriptor.getTypeRef(), fieldName);
        }
        return new Expression.Invoke((Expression)ref, (String)methodInfo.f1, fieldType, fieldNullable, inputBeanExpr);
    }

    private Expression reflectAccessField(Expression inputObject, Class<?> cls, Descriptor descriptor) {
        Expression.Reference fieldRef = this.getReflectField(cls, descriptor.getField());
        Expression.Invoke getObj = new Expression.Invoke((Expression)fieldRef, "get", TypeUtils.OBJECT_TYPE, this.fieldNullable(descriptor), inputObject);
        return new Expression.Cast(getObj, descriptor.getTypeRef(), descriptor.getName());
    }

    private Expression unsafeAccessField(Expression inputObject, Class<?> cls, Descriptor descriptor) {
        String fieldName = descriptor.getName();
        Expression fieldOffsetExpr = this.getFieldOffset(cls, descriptor);
        boolean fieldNullable = this.fieldNullable(descriptor);
        if (descriptor.getTypeRef().isPrimitive()) {
            Preconditions.checkArgument(!fieldNullable);
            TypeRef<?> returnType = descriptor.getTypeRef();
            String funcName = "get" + StringUtils.capitalize(descriptor.getRawType().toString());
            return new Expression.StaticInvoke(Platform.class, funcName, returnType, false, inputObject, fieldOffsetExpr);
        }
        Expression.StaticInvoke getObj = new Expression.StaticInvoke(Platform.class, "getObject", TypeUtils.OBJECT_TYPE, fieldNullable, inputObject, fieldOffsetExpr);
        return this.tryCastIfPublic((Expression)getObj, descriptor.getTypeRef(), fieldName);
    }

    private Expression getFieldOffset(Class<?> cls, Descriptor descriptor) {
        Field field = descriptor.getField();
        String fieldName = descriptor.getName();
        if (GraalvmSupport.isGraalBuildtime()) {
            return this.getOrCreateField(true, Long.TYPE, fieldName + "_offset_", () -> {
                Expression classExpr = this.beanClassExpr(field.getDeclaringClass());
                new Expression.Invoke(classExpr, "getDeclaredField", TypeRef.of(Field.class));
                Expression.Reference reflectFieldRef = this.getReflectField(cls, field, false);
                return new Expression.StaticInvoke(Platform.class, "objectFieldOffset", TypeUtils.PRIMITIVE_LONG_TYPE, reflectFieldRef).inline();
            });
        }
        long fieldOffset = ReflectionUtils.getFieldOffset(field);
        Preconditions.checkArgument(fieldOffset != -1L);
        return Expression.Literal.ofLong(fieldOffset);
    }

    public abstract Expression buildDecodeExpression();

    protected Expression setFieldValue(Expression bean, Descriptor d, Expression value) {
        String fieldName = d.getName();
        if (value instanceof Expression.Inlineable) {
            ((Expression.Inlineable)value).inline();
        }
        if (this.duplicatedFields.contains(fieldName) || !this.sourcePublicAccessible(this.beanClass)) {
            return this.unsafeSetField(bean, d, value);
        }
        if (!d.isFinalField() && Modifier.isPublic(d.getModifiers()) && Modifier.isPublic(d.getRawType().getModifiers())) {
            return new Expression.SetField(bean, fieldName, value);
        }
        if (d.getWriteMethod() != null && Modifier.isPublic(d.getWriteMethod().getModifiers())) {
            return new Expression.Invoke(bean, d.getWriteMethod().getName(), value);
        }
        if (!d.isFinalField() && !Modifier.isPrivate(d.getModifiers()) && AccessorHelper.defineSetter(d.getField())) {
            Class<?> accessorClass = AccessorHelper.getAccessorClass(d.getField());
            if (!value.type().equals(d.getTypeRef())) {
                value = new Expression.Cast(value, d.getTypeRef());
            }
            return new Expression.StaticInvoke(accessorClass, d.getName(), TypeUtils.PRIMITIVE_VOID_TYPE, false, bean, value);
        }
        if (d.getWriteMethod() != null && !Modifier.isPrivate(d.getWriteMethod().getModifiers()) && AccessorHelper.defineSetter(d.getWriteMethod())) {
            Class<?> accessorClass = AccessorHelper.getAccessorClass(d.getWriteMethod());
            if (!value.type().equals(d.getTypeRef())) {
                value = new Expression.Cast(value, d.getTypeRef());
            }
            return new Expression.StaticInvoke(accessorClass, d.getWriteMethod().getName(), TypeUtils.PRIMITIVE_VOID_TYPE, false, bean, value);
        }
        return this.unsafeSetField(bean, d, value);
    }

    private Expression reflectSetField(Expression bean, Field field, Expression value) {
        Expression.Reference fieldRef = this.getReflectField(TypeUtils.getRawType(bean.type()), field);
        Preconditions.checkNotNull(fieldRef);
        return new Expression.Invoke((Expression)fieldRef, "set", bean, value);
    }

    private Expression unsafeSetField(Expression bean, Descriptor descriptor, Expression value) {
        TypeRef<?> fieldType = descriptor.getTypeRef();
        Expression fieldOffsetExpr = this.getFieldOffset(this.beanClass, descriptor);
        if (descriptor.getTypeRef().isPrimitive()) {
            Preconditions.checkArgument(value.type().equals(fieldType));
            String funcName = "put" + StringUtils.capitalize(TypeUtils.getRawType(fieldType).toString());
            return new Expression.StaticInvoke(Platform.class, funcName, bean, fieldOffsetExpr, value);
        }
        return new Expression.StaticInvoke(Platform.class, "putObject", bean, fieldOffsetExpr, value);
    }

    private Expression.Reference getReflectField(Class<?> cls, Field field) {
        return this.getReflectField(cls, field, true);
    }

    private Expression.Reference getReflectField(Class<?> cls, Field field, boolean setAccessible) {
        String fieldName = field.getName();
        String fieldRefName = this.duplicatedFields.contains(fieldName) ? cls.getName().replaceAll("\\.|\\$", "_") + "_" + fieldName + "_Field" : fieldName + "_Field";
        return this.getOrCreateField(true, Field.class, fieldRefName, () -> {
            TypeRef<Field> fieldTypeRef = TypeRef.of(Field.class);
            Expression classExpr = this.beanClassExpr(field.getDeclaringClass());
            Expression.BaseInvoke fieldExpr = GraalvmSupport.isGraalBuildtime() ? Expression.Invoke.inlineInvoke(classExpr, "getDeclaredField", fieldTypeRef, Expression.Literal.ofString(fieldName)) : new Expression.StaticInvoke(ReflectionUtils.class, "getField", fieldTypeRef, classExpr, Expression.Literal.ofString(fieldName));
            if (!setAccessible) {
                return fieldExpr;
            }
            Expression.Invoke setAccess = new Expression.Invoke((Expression)fieldExpr, "setAccessible", Expression.Literal.True);
            return new Expression.ListExpression(setAccess, fieldExpr);
        });
    }

    protected Expression.Reference getOrCreateField(boolean isStatic, Class<?> type, String fieldName, Supplier<Expression> value) {
        Expression.Reference fieldRef = this.fieldMap.get(fieldName);
        if (fieldRef == null) {
            this.ctx.addField(isStatic, true, this.ctx.type(type), fieldName, value.get());
            fieldRef = new Expression.Reference(fieldName, TypeRef.of(type));
            this.fieldMap.put(fieldName, fieldRef);
        }
        return fieldRef;
    }

    protected Expression newBean() {
        if (this.sourcePublicAccessible(this.beanClass)) {
            return new Expression.NewInstance(this.beanType, new Expression[0]);
        }
        return new Expression.StaticInvoke(Platform.class, "newInstance", TypeUtils.OBJECT_TYPE, this.beanClassExpr());
    }

    protected void buildRecordComponentDefaultValues() {
        this.ctx.reserveName(recordComponentDefaultValues.name());
        Expression.StaticInvoke expr = new Expression.StaticInvoke(RecordUtils.class, "buildRecordComponentDefaultValues", TypeUtils.OBJECT_ARRAY_TYPE, this.beanClassExpr());
        this.ctx.addField(Object[].class, recordComponentDefaultValues.name(), (Expression)expr);
    }

    static boolean recordCtrAccessible(Class<?> cls) {
        if (!Modifier.isPublic(cls.getModifiers())) {
            return false;
        }
        for (RecordComponent component : Objects.requireNonNull(RecordUtils.getRecordComponents(cls))) {
            if (Modifier.isPublic(component.getType().getModifiers())) continue;
            return false;
        }
        return true;
    }

    protected Expression beanClassExpr(Class<?> cls) {
        if (cls == this.beanClass) {
            return this.staticBeanClassExpr();
        }
        if (GraalvmSupport.isGraalBuildtime()) {
            String name = cls.getName().replaceAll("\\.|\\$", "_") + "__class__";
            return this.getOrCreateField(true, Class.class, name, () -> new Expression.StaticInvoke(ReflectionUtils.class, "loadClass", TypeUtils.CLASS_TYPE, Expression.Literal.ofString(cls.getName())).inline());
        }
        throw new UnsupportedOperationException();
    }

    protected Expression beanClassExpr() {
        if (GraalvmSupport.isGraalBuildtime()) {
            return this.staticBeanClassExpr();
        }
        throw new UnsupportedOperationException();
    }

    protected Expression staticBeanClassExpr() {
        if (this.sourcePublicAccessible(this.beanClass)) {
            return Expression.Literal.ofClass(this.beanClass);
        }
        return this.staticClassFieldExpr(this.beanClass, "__class__");
    }

    protected Expression staticClassFieldExpr(Class<?> cls, String fieldName) {
        Preconditions.checkArgument(!this.sourcePublicAccessible(cls), "Public class %s should use class literal instead", cls, new Object[0]);
        return this.getOrCreateField(true, Class.class, fieldName, () -> new Expression.StaticInvoke(ReflectionUtils.class, "loadClass", TypeUtils.CLASS_TYPE, Expression.Literal.ofString(cls.getName())).inline());
    }

    protected Expression unsafePut(Expression base, Expression pos, Expression value) {
        return new Expression.StaticInvoke(Platform.class, "putByte", base, pos, value);
    }

    protected Expression unsafePutBoolean(Expression base, Expression pos, Expression value) {
        return new Expression.StaticInvoke(Platform.class, "putBoolean", base, pos, value);
    }

    protected Expression unsafePutChar(Expression base, Expression pos, Expression value) {
        return new Expression.StaticInvoke(Platform.class, "putChar", base, pos, value);
    }

    protected Expression unsafePutShort(Expression base, Expression pos, Expression value) {
        return new Expression.StaticInvoke(Platform.class, "putShort", base, pos, value);
    }

    protected Expression unsafePutInt(Expression base, Expression pos, Expression value) {
        return new Expression.StaticInvoke(Platform.class, "putInt", base, pos, value);
    }

    protected Expression unsafePutLong(Expression base, Expression pos, Expression value) {
        return new Expression.StaticInvoke(Platform.class, "putLong", base, pos, value);
    }

    protected Expression unsafePutFloat(Expression base, Expression pos, Expression value) {
        return new Expression.StaticInvoke(Platform.class, "putFloat", base, pos, value);
    }

    protected Expression unsafePutDouble(Expression base, Expression pos, Expression value) {
        return new Expression.StaticInvoke(Platform.class, "putDouble", base, pos, value);
    }

    protected Expression unsafeGet(Expression base, Expression pos) {
        return new Expression.StaticInvoke(Platform.class, "getByte", TypeUtils.PRIMITIVE_BYTE_TYPE, base, pos);
    }

    protected Expression unsafeGetBoolean(Expression base, Expression pos) {
        return new Expression.StaticInvoke(Platform.class, "getBoolean", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, base, pos);
    }

    protected Expression unsafeGetChar(Expression base, Expression pos) {
        Expression.StaticInvoke expr = new Expression.StaticInvoke(Platform.class, "getChar", TypeUtils.PRIMITIVE_CHAR_TYPE, base, pos);
        if (!Platform.IS_LITTLE_ENDIAN) {
            expr = new Expression.StaticInvoke(Character.class, "reverseBytes", TypeUtils.PRIMITIVE_CHAR_TYPE, expr.inline());
        }
        return expr;
    }

    protected Expression unsafeGetShort(Expression base, Expression pos) {
        Expression.StaticInvoke expr = new Expression.StaticInvoke(Platform.class, "getShort", TypeUtils.PRIMITIVE_SHORT_TYPE, base, pos);
        if (!Platform.IS_LITTLE_ENDIAN) {
            expr = new Expression.StaticInvoke(Short.class, "reverseBytes", TypeUtils.PRIMITIVE_SHORT_TYPE, expr.inline());
        }
        return expr;
    }

    protected Expression unsafeGetInt(Expression base, Expression pos) {
        Expression.StaticInvoke expr = new Expression.StaticInvoke(Platform.class, "getInt", TypeUtils.PRIMITIVE_INT_TYPE, base, pos);
        if (!Platform.IS_LITTLE_ENDIAN) {
            expr = new Expression.StaticInvoke(Integer.class, "reverseBytes", TypeUtils.PRIMITIVE_INT_TYPE, expr.inline());
        }
        return expr;
    }

    protected Expression unsafeGetLong(Expression base, Expression pos) {
        Expression.StaticInvoke expr = new Expression.StaticInvoke(Platform.class, "getLong", TypeUtils.PRIMITIVE_LONG_TYPE, base, pos);
        if (!Platform.IS_LITTLE_ENDIAN) {
            expr = new Expression.StaticInvoke(Long.class, "reverseBytes", TypeUtils.PRIMITIVE_LONG_TYPE, expr.inline());
        }
        return expr;
    }

    protected Expression unsafeGetFloat(Expression base, Expression pos) {
        Expression.StaticInvoke expr = new Expression.StaticInvoke(Platform.class, "getInt", TypeUtils.PRIMITIVE_INT_TYPE, base, pos);
        if (!Platform.IS_LITTLE_ENDIAN) {
            expr = new Expression.StaticInvoke(Integer.class, "reverseBytes", TypeUtils.PRIMITIVE_INT_TYPE, expr.inline());
        }
        return new Expression.StaticInvoke(Float.class, "intBitsToFloat", TypeUtils.PRIMITIVE_FLOAT_TYPE, expr.inline());
    }

    protected Expression unsafeGetDouble(Expression base, Expression pos) {
        Expression.StaticInvoke expr = new Expression.StaticInvoke(Platform.class, "getLong", TypeUtils.PRIMITIVE_LONG_TYPE, base, pos);
        if (!Platform.IS_LITTLE_ENDIAN) {
            expr = new Expression.StaticInvoke(Long.class, "reverseBytes", TypeUtils.PRIMITIVE_LONG_TYPE, expr.inline());
        }
        return new Expression.StaticInvoke(Double.class, "longBitsToDouble", TypeUtils.PRIMITIVE_DOUBLE_TYPE, expr.inline());
    }

    protected Expression readChar(Expression buffer) {
        return new Expression.Invoke(buffer, "readChar", TypeUtils.PRIMITIVE_CHAR_TYPE);
    }

    protected Expression readInt16(Expression buffer) {
        String func = Platform.IS_LITTLE_ENDIAN ? "_readInt16OnLE" : "_readInt16OnBE";
        return new Expression.Invoke(buffer, func, TypeUtils.PRIMITIVE_SHORT_TYPE);
    }

    protected Expression readInt32(Expression buffer) {
        String func = Platform.IS_LITTLE_ENDIAN ? "_readInt32OnLE" : "_readInt32OnBE";
        return new Expression.Invoke(buffer, func, TypeUtils.PRIMITIVE_INT_TYPE);
    }

    public static String readIntFunc() {
        return Platform.IS_LITTLE_ENDIAN ? "_readInt32OnLE" : "_readInt32OnBE";
    }

    protected Expression readVarInt32(Expression buffer) {
        String func = Platform.IS_LITTLE_ENDIAN ? "_readVarInt32OnLE" : "_readVarInt32OnBE";
        return new Expression.Invoke(buffer, func, TypeUtils.PRIMITIVE_INT_TYPE);
    }

    protected Expression readInt64(Expression buffer) {
        return new Expression.Invoke(buffer, CodecBuilder.readLongFunc(), TypeUtils.PRIMITIVE_LONG_TYPE);
    }

    public static String readLongFunc() {
        return Platform.IS_LITTLE_ENDIAN ? "_readInt64OnLE" : "_readInt64OnBE";
    }

    protected Expression readFloat32(Expression buffer) {
        String func = Platform.IS_LITTLE_ENDIAN ? "_readFloat32OnLE" : "_readFloat32OnBE";
        return new Expression.Invoke(buffer, func, TypeUtils.PRIMITIVE_FLOAT_TYPE);
    }

    protected Expression readFloat64(Expression buffer) {
        String func = Platform.IS_LITTLE_ENDIAN ? "_readFloat64OnLE" : "_readFloat64OnBE";
        return new Expression.Invoke(buffer, func, TypeUtils.PRIMITIVE_DOUBLE_TYPE);
    }
}

