/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import jakarta.servlet.Filter;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.web.PortMapper;
import org.springframework.security.web.transport.HttpsRedirectFilter;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public final class HttpsRedirectConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<HeadersConfigurer<H>, H> {
    private RequestMatcher requestMatcher;

    public HttpsRedirectConfigurer<H> requestMatchers(RequestMatcher ... matchers) {
        this.requestMatcher = new OrRequestMatcher(matchers);
        return this;
    }

    @Override
    public void configure(H http) throws Exception {
        PortMapper mapper;
        HttpsRedirectFilter filter = new HttpsRedirectFilter();
        if (this.requestMatcher != null) {
            filter.setRequestMatcher(this.requestMatcher);
        }
        if ((mapper = http.getSharedObject(PortMapper.class)) != null) {
            filter.setPortMapper(mapper);
        }
        http.addFilter((Filter)filter);
    }
}

