/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.File;
import java.io.IOException;
import org.zeromq.ZConfig;
import org.zeromq.ZMQ;
import org.zeromq.util.ZMetadata;
import zmq.util.Z85;

public class ZCert {
    private final byte[] publicKey;
    private final byte[] secretKey;
    private final String publicTxt;
    private final String secretTxt;
    private final ZMetadata metadata = new ZMetadata();

    public ZCert(String publickey) {
        if (publickey.length() == 32) {
            this.publicKey = publickey.getBytes(ZMQ.CHARSET);
            this.publicTxt = ZMQ.Curve.z85Encode(this.publicKey);
        } else {
            assert (publickey.length() == 40);
            this.publicKey = Z85.decode(publickey);
            this.publicTxt = publickey;
        }
        this.secretKey = null;
        this.secretTxt = null;
    }

    public ZCert() {
        ZMQ.Curve.KeyPair keypair = ZMQ.Curve.generateKeyPair();
        this.publicKey = ZMQ.Curve.z85Decode(keypair.publicKey);
        this.publicTxt = keypair.publicKey;
        this.secretKey = ZMQ.Curve.z85Decode(keypair.secretKey);
        this.secretTxt = keypair.secretKey;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public byte[] getSecretKey() {
        return this.secretKey;
    }

    public String getPublicKeyAsZ85() {
        return this.publicTxt;
    }

    public String getSecretKeyAsZ85() {
        return this.secretTxt;
    }

    public void apply(ZMQ.Socket socket) {
        socket.setCurvePublicKey(this.publicKey);
        socket.setCurveSecretKey(this.secretKey);
    }

    public ZMetadata getMetadata() {
        return this.metadata;
    }

    public void setMeta(String key, String value2) {
        this.metadata.set(key, value2);
    }

    private void add(ZMetadata meta, ZConfig config) {
        for (String key : meta.keySet()) {
            config.putValue("metadata/" + key, meta.get(key));
        }
    }

    public File savePublic(String filename) throws IOException {
        ZConfig conf = new ZConfig("root", null);
        this.add(this.metadata, conf);
        conf.addComment("   ZeroMQ CURVE Public Certificate");
        conf.addComment("   Exchange securely, or use a secure mechanism to verify the contents");
        conf.addComment("   of this file after exchange. Store public certificates in your home");
        conf.addComment("   directory, in the .curve subdirectory.");
        conf.putValue("/curve/public-key", this.publicTxt);
        return conf.save(filename);
    }

    public File saveSecret(String filename) throws IOException {
        ZConfig conf = new ZConfig("root", null);
        this.add(this.metadata, conf);
        conf.addComment("   ZeroMQ CURVE **Secret** Certificate");
        conf.addComment("   DO NOT PROVIDE THIS FILE TO OTHER USERS nor change its permissions.");
        conf.putValue("/curve/public-key", this.publicTxt);
        conf.putValue("/curve/secret-key", this.secretTxt);
        return conf.save(filename);
    }
}

