/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.zeromq.ZMQException;
import zmq.Ctx;
import zmq.Msg;
import zmq.SocketBase;
import zmq.ZError;
import zmq.ZMQ;
import zmq.io.coder.IDecoder;
import zmq.io.coder.IEncoder;
import zmq.io.mechanism.Mechanisms;
import zmq.msg.MsgAllocator;
import zmq.util.Z85;

public class ZMQ {
    public static final int SNDMORE = 2;
    public static final int DONTWAIT = 1;
    public static final int NOBLOCK = 1;
    public static final int PAIR = 0;
    public static final int PUB = 1;
    public static final int SUB = 2;
    public static final int REQ = 3;
    public static final int REP = 4;
    public static final int DEALER = 5;
    @Deprecated
    public static final int XREQ = 5;
    public static final int ROUTER = 6;
    @Deprecated
    public static final int XREP = 6;
    public static final int PULL = 7;
    public static final int PUSH = 8;
    public static final int XPUB = 9;
    public static final int XSUB = 10;
    public static final int STREAM = 11;
    @Deprecated
    public static final int STREAMER = 1;
    @Deprecated
    public static final int FORWARDER = 2;
    @Deprecated
    public static final int QUEUE = 3;
    @Deprecated
    public static final int UPSTREAM = 7;
    @Deprecated
    public static final int DOWNSTREAM = 8;
    public static final int EVENT_CONNECTED = 1;
    public static final int EVENT_CONNECT_DELAYED = 2;
    @Deprecated
    public static final int EVENT_DELAYED = 2;
    public static final int EVENT_CONNECT_RETRIED = 4;
    @Deprecated
    public static final int EVENT_RETRIED = 4;
    public static final int EVENT_LISTENING = 8;
    public static final int EVENT_BIND_FAILED = 16;
    public static final int EVENT_ACCEPTED = 32;
    public static final int EVENT_ACCEPT_FAILED = 64;
    public static final int EVENT_CLOSED = 128;
    public static final int EVENT_CLOSE_FAILED = 256;
    public static final int EVENT_DISCONNECTED = 512;
    public static final int EVENT_MONITOR_STOPPED = 1024;
    public static final int EVENT_HANDSHAKE_PROTOCOL = 32768;
    public static final int EVENT_ALL = 65535;
    public static final byte[] MESSAGE_SEPARATOR = zmq.ZMQ.MESSAGE_SEPARATOR;
    public static final byte[] SUBSCRIPTION_ALL = zmq.ZMQ.SUBSCRIPTION_ALL;
    public static final byte[] PROXY_PAUSE = zmq.ZMQ.PROXY_PAUSE;
    public static final byte[] PROXY_RESUME = zmq.ZMQ.PROXY_RESUME;
    public static final byte[] PROXY_TERMINATE = zmq.ZMQ.PROXY_TERMINATE;
    public static final Charset CHARSET = zmq.ZMQ.CHARSET;

    private ZMQ() {
    }

    public static Context context(int ioThreads) {
        return new Context(ioThreads);
    }

    @Deprecated
    public static boolean device(int type, Socket frontend, Socket backend) {
        return zmq.ZMQ.proxy(frontend.base, backend.base, null);
    }

    public static boolean proxy(Socket frontend, Socket backend, Socket capture) {
        return zmq.ZMQ.proxy(frontend.base, backend.base, capture != null ? capture.base : null);
    }

    public static boolean proxy(Socket frontend, Socket backend, Socket capture, Socket control) {
        return zmq.ZMQ.proxy(frontend.base, backend.base, capture == null ? null : capture.base, control == null ? null : control.base);
    }

    public static int poll(Selector selector, PollItem[] items, long timeout) {
        return ZMQ.poll(selector, items, items.length, timeout);
    }

    public static int poll(Selector selector, PollItem[] items, int count2, long timeout) {
        zmq.poll.PollItem[] pollItems = new zmq.poll.PollItem[count2];
        for (int i = 0; i < count2; ++i) {
            pollItems[i] = items[i].base;
        }
        return zmq.ZMQ.poll(selector, pollItems, count2, timeout);
    }

    public static int getMajorVersion() {
        return 4;
    }

    public static int getMinorVersion() {
        return 1;
    }

    public static int getPatchVersion() {
        return 7;
    }

    public static int getFullVersion() {
        return zmq.ZMQ.makeVersion(4, 1, 7);
    }

    public static int makeVersion(int major, int minor, int patch) {
        return zmq.ZMQ.makeVersion(major, minor, patch);
    }

    public static String getVersionString() {
        return "4.1.7";
    }

    public static void msleep(long millis) {
        zmq.ZMQ.msleep(millis);
    }

    public static void sleep(long seconds) {
        zmq.ZMQ.sleep(seconds);
    }

    public static void sleep(long amount, TimeUnit unit2) {
        zmq.ZMQ.sleep(amount, unit2);
    }

    public static class Curve {
        public static KeyPair generateKeyPair() {
            String[] keys2 = new zmq.io.mechanism.curve.Curve().keypairZ85();
            return new KeyPair(keys2[0], keys2[1]);
        }

        public static byte[] z85Decode(String key) {
            return Z85.decode(key);
        }

        public static String z85Encode(byte[] key) {
            return zmq.io.mechanism.curve.Curve.z85EncodePublic(key);
        }

        public static class KeyPair {
            public final String publicKey;
            public final String secretKey;

            public KeyPair(String publicKey, String secretKey) {
                this.publicKey = publicKey;
                this.secretKey = secretKey;
            }
        }
    }

    public static class Event {
        private final int event;
        private final Object value;
        private final String address;

        public Event(int event, Object value2, String address) {
            this.event = event;
            this.value = value2;
            this.address = address;
        }

        public int getEvent() {
            return this.event;
        }

        public Object getValue() {
            return this.value;
        }

        public String getAddress() {
            return this.address;
        }

        public static Event recv(Socket socket, int flags) {
            ZMQ.Event e = ZMQ.Event.read(socket.base, flags);
            return e != null ? new Event(e.event, e.arg, e.addr) : null;
        }

        public static Event recv(Socket socket) {
            return Event.recv(socket, 0);
        }
    }

    public static enum Error {
        ENOTSUP(45),
        EPROTONOSUPPORT(43),
        ENOBUFS(55),
        ENETDOWN(50),
        EADDRINUSE(48),
        EADDRNOTAVAIL(49),
        ECONNREFUSED(61),
        EINPROGRESS(36),
        EHOSTUNREACH(65),
        EMTHREAD(156384766),
        EFSM(156384763),
        ENOCOMPATPROTO(156384764),
        ETERM(156384765),
        ENOTSOCK(156384717),
        EAGAIN(35);

        private final int code;

        private Error(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static Error findByCode(int code) {
            for (Error e : Error.values()) {
                if (e.getCode() != code) continue;
                return e;
            }
            throw new IllegalArgumentException("Unknown " + Error.class.getName() + " enum code:" + code);
        }
    }

    public static class PollItem {
        private final zmq.poll.PollItem base;
        private final Socket socket;

        public PollItem(Socket socket, int ops) {
            this.socket = socket;
            this.base = new zmq.poll.PollItem(socket.base, ops);
        }

        public PollItem(SelectableChannel channel, int ops) {
            this.base = new zmq.poll.PollItem(channel, ops);
            this.socket = null;
        }

        final zmq.poll.PollItem base() {
            return this.base;
        }

        public final SelectableChannel getRawSocket() {
            return this.base.getRawSocket();
        }

        public final Socket getSocket() {
            return this.socket;
        }

        public final boolean isReadable() {
            return this.base.isReadable();
        }

        public final boolean isWritable() {
            return this.base.isWritable();
        }

        public final boolean isError() {
            return this.base.isError();
        }

        public final int readyOps() {
            return this.base.readyOps();
        }

        public int hashCode() {
            return this.base.hashCode();
        }

        public boolean equals(Object obj2) {
            if (!(obj2 instanceof PollItem)) {
                return false;
            }
            PollItem target = (PollItem)obj2;
            if (this.socket != null && this.socket == target.socket) {
                return true;
            }
            return this.getRawSocket() != null && this.getRawSocket() == target.getRawSocket();
        }
    }

    public static class Poller
    implements Closeable {
        public static final int POLLIN = 1;
        public static final int POLLOUT = 2;
        public static final int POLLERR = 4;
        private static final int SIZE_DEFAULT = 32;
        private static final int SIZE_INCREMENT = 16;
        private final Selector selector;
        private final Context context;
        private PollItem[] items;
        private int next;
        private int used;
        private long timeout;
        private LinkedList<Integer> freeSlots;

        protected Poller(Context context, int size2) {
            assert (context != null);
            this.context = context;
            this.selector = context.selector();
            assert (this.selector != null);
            this.items = new PollItem[size2];
            this.timeout = -1L;
            this.next = 0;
            this.freeSlots = new LinkedList();
        }

        protected Poller(Context context) {
            this(context, 32);
        }

        @Override
        public void close() {
            this.context.close(this.selector);
        }

        public int register(Socket socket) {
            return this.register(socket, 7);
        }

        public int register(SelectableChannel channel) {
            return this.register(channel, 7);
        }

        public int register(Socket socket, int events) {
            return this.registerInternal(new PollItem(socket, events));
        }

        public int register(SelectableChannel channel, int events) {
            return this.registerInternal(new PollItem(channel, events));
        }

        public int register(PollItem item) {
            return this.registerInternal(item);
        }

        private int registerInternal(PollItem item) {
            int pos;
            if (!this.freeSlots.isEmpty()) {
                pos = this.freeSlots.remove();
            } else {
                if (this.next >= this.items.length) {
                    PollItem[] nitems = new PollItem[this.items.length + 16];
                    System.arraycopy(this.items, 0, nitems, 0, this.items.length);
                    this.items = nitems;
                }
                pos = this.next++;
            }
            this.items[pos] = item;
            ++this.used;
            return pos;
        }

        public void unregister(Socket socket) {
            this.unregisterInternal(socket);
        }

        public void unregister(SelectableChannel channel) {
            this.unregisterInternal(channel);
        }

        private void unregisterInternal(Object socket) {
            for (int i = 0; i < this.next; ++i) {
                PollItem item = this.items[i];
                if (item == null || item.socket != socket && item.getRawSocket() != socket) continue;
                this.items[i] = null;
                this.freeSlots.add(i);
                --this.used;
                break;
            }
        }

        public PollItem getItem(int index2) {
            if (index2 < 0 || index2 >= this.next) {
                return null;
            }
            return this.items[index2];
        }

        public Socket getSocket(int index2) {
            if (index2 < 0 || index2 >= this.next) {
                return null;
            }
            return this.items[index2].socket;
        }

        @Deprecated
        public long getTimeout() {
            return this.timeout;
        }

        @Deprecated
        public void setTimeout(long timeout) {
            if (timeout >= -1L) {
                this.timeout = timeout;
            }
        }

        public int getSize() {
            return this.items.length;
        }

        public int getNext() {
            return this.next;
        }

        public int poll() {
            long tout = -1L;
            if (this.timeout > -1L) {
                tout = this.timeout;
            }
            return this.poll(tout);
        }

        public int poll(long tout) {
            if (tout < -1L) {
                return 0;
            }
            if (this.items.length <= 0 || this.next <= 0) {
                return 0;
            }
            zmq.poll.PollItem[] pollItems = new zmq.poll.PollItem[this.used];
            int j = 0;
            for (int i = 0; i < this.next; ++i) {
                if (this.items[i] == null) continue;
                pollItems[j++] = this.items[i].base;
            }
            try {
                return zmq.ZMQ.poll(this.selector, pollItems, this.used, tout);
            }
            catch (ZError.IOException e) {
                if (this.context.isTerminated()) {
                    return 0;
                }
                throw e;
            }
        }

        public boolean pollin(int index2) {
            if (index2 < 0 || index2 >= this.next) {
                return false;
            }
            return this.items[index2].isReadable();
        }

        public boolean pollout(int index2) {
            if (index2 < 0 || index2 >= this.next) {
                return false;
            }
            return this.items[index2].isWritable();
        }

        public boolean pollerr(int index2) {
            if (index2 < 0 || index2 >= this.next) {
                return false;
            }
            return this.items[index2].isError();
        }
    }

    public static class Socket
    implements Closeable {
        private static final int DYNFROM = 49152;
        private static final int DYNTO = 65535;
        private final Ctx ctx;
        private final SocketBase base;
        private final AtomicBoolean isClosed = new AtomicBoolean(false);

        protected Socket(Context context, int type) {
            this.ctx = context.ctx;
            this.base = this.ctx.createSocket(type);
        }

        protected Socket(SocketBase base) {
            this.ctx = null;
            this.base = base;
        }

        public SocketBase base() {
            return this.base;
        }

        @Override
        public void close() {
            if (this.isClosed.compareAndSet(false, true)) {
                this.base.close();
            }
        }

        public int getType() {
            return this.base.getSocketOpt(16);
        }

        public int getLinger() {
            return this.base.getSocketOpt(17);
        }

        private boolean setSocketOpt(int option2, Object value2) {
            try {
                boolean set2 = this.base.setSocketOpt(option2, value2);
                return set2 &= this.base.errno() != 22;
            }
            catch (ZError.CtxTerminatedException e) {
                return false;
            }
        }

        @Deprecated
        public boolean setLinger(long value2) {
            return this.setLinger(Long.valueOf(value2).intValue());
        }

        public boolean setLinger(int value2) {
            return this.base.setSocketOpt(17, value2);
        }

        public int getReconnectIVL() {
            return this.base.getSocketOpt(18);
        }

        @Deprecated
        public boolean setReconnectIVL(long value2) {
            return this.setReconnectIVL(Long.valueOf(value2).intValue());
        }

        public boolean setReconnectIVL(int value2) {
            return this.base.setSocketOpt(18, value2);
        }

        public int getBacklog() {
            return this.base.getSocketOpt(19);
        }

        @Deprecated
        public boolean setBacklog(long value2) {
            return this.setBacklog(Long.valueOf(value2).intValue());
        }

        public boolean setBacklog(int value2) {
            return this.setSocketOpt(19, value2);
        }

        public int getHandshakeIvl() {
            return this.base.getSocketOpt(66);
        }

        public boolean setHandshakeIvl(int maxHandshakeIvl) {
            return this.setSocketOpt(66, maxHandshakeIvl);
        }

        public int getTos() {
            return this.base.getSocketOpt(57);
        }

        public boolean setTos(int value2) {
            return this.setSocketOpt(57, value2);
        }

        public int getReconnectIVLMax() {
            return this.base.getSocketOpt(21);
        }

        @Deprecated
        public boolean setReconnectIVLMax(long value2) {
            return this.setReconnectIVLMax(Long.valueOf(value2).intValue());
        }

        public boolean setReconnectIVLMax(int value2) {
            return this.setSocketOpt(21, value2);
        }

        public long getMaxMsgSize() {
            return (Long)this.base.getSocketOptx(22);
        }

        public boolean setMaxMsgSize(long value2) {
            return this.setSocketOpt(22, value2);
        }

        public int getSndHWM() {
            return this.base.getSocketOpt(23);
        }

        @Deprecated
        public boolean setSndHWM(long value2) {
            return this.setSndHWM(Long.valueOf(value2).intValue());
        }

        public boolean setSndHWM(int value2) {
            return this.setSocketOpt(23, value2);
        }

        public int getRcvHWM() {
            return this.base.getSocketOpt(24);
        }

        @Deprecated
        public boolean setRcvHWM(long value2) {
            return this.setRcvHWM(Long.valueOf(value2).intValue());
        }

        public boolean setRcvHWM(int value2) {
            return this.setSocketOpt(24, value2);
        }

        @Deprecated
        public int getHWM() {
            return -1;
        }

        @Deprecated
        public boolean setHWM(long hwm) {
            boolean set2 = true;
            set2 |= this.setSndHWM(hwm);
            return set2 |= this.setRcvHWM(hwm);
        }

        public boolean setHWM(int hwm) {
            boolean set2 = false;
            set2 |= this.setSndHWM(hwm);
            return set2 |= this.setRcvHWM(hwm);
        }

        @Deprecated
        public long getSwap() {
            return -1L;
        }

        public boolean setConflate(boolean conflate) {
            return this.setSocketOpt(54, conflate);
        }

        public boolean isConflate() {
            return this.base.getSocketOpt(54) != 0;
        }

        public boolean getConflate() {
            return this.isConflate();
        }

        @Deprecated
        public boolean setSwap(long value2) {
            throw new UnsupportedOperationException();
        }

        public long getAffinity() {
            return (Long)this.base.getSocketOptx(4);
        }

        public boolean setAffinity(long value2) {
            return this.setSocketOpt(4, value2);
        }

        public byte[] getIdentity() {
            return (byte[])this.base.getSocketOptx(5);
        }

        public boolean setIdentity(byte[] identity2) {
            return this.setSocketOpt(5, identity2);
        }

        public long getRate() {
            return this.base.getSocketOpt(8);
        }

        public boolean setRate(long value2) {
            throw new UnsupportedOperationException();
        }

        public long getRecoveryInterval() {
            return this.base.getSocketOpt(9);
        }

        public boolean setRecoveryInterval(long value2) {
            throw new UnsupportedOperationException();
        }

        public boolean setReqCorrelate(boolean correlate) {
            return this.setSocketOpt(52, correlate);
        }

        @Deprecated
        public boolean getReqCorrelate() {
            throw new UnsupportedOperationException();
        }

        public boolean setReqRelaxed(boolean relaxed) {
            return this.setSocketOpt(53, relaxed);
        }

        @Deprecated
        public boolean getReqRelaxed() {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public boolean hasMulticastLoop() {
            return false;
        }

        @Deprecated
        public boolean setMulticastLoop(boolean multicastLoop) {
            throw new UnsupportedOperationException();
        }

        public long getMulticastHops() {
            return this.base.getSocketOpt(25);
        }

        public boolean setMulticastHops(long value2) {
            throw new UnsupportedOperationException();
        }

        public int getReceiveTimeOut() {
            return this.base.getSocketOpt(27);
        }

        public boolean setReceiveTimeOut(int value2) {
            return this.setSocketOpt(27, value2);
        }

        public int getSendTimeOut() {
            return this.base.getSocketOpt(28);
        }

        public boolean setSendTimeOut(int value2) {
            return this.setSocketOpt(28, value2);
        }

        @Deprecated
        public boolean setTCPKeepAlive(long value2) {
            return this.setTCPKeepAlive(Long.valueOf(value2).intValue());
        }

        @Deprecated
        public long getTCPKeepAliveSetting() {
            return this.getTCPKeepAlive();
        }

        public boolean setTCPKeepAliveCount(long value2) {
            return this.setSocketOpt(35, Long.valueOf(value2).intValue());
        }

        public long getTCPKeepAliveCount() {
            return this.base.getSocketOpt(35);
        }

        public boolean setTCPKeepAliveInterval(long value2) {
            return this.setSocketOpt(37, Long.valueOf(value2).intValue());
        }

        public long getTCPKeepAliveInterval() {
            return this.base.getSocketOpt(37);
        }

        public boolean setTCPKeepAliveIdle(long value2) {
            return this.setSocketOpt(36, Long.valueOf(value2).intValue());
        }

        public long getTCPKeepAliveIdle() {
            return this.base.getSocketOpt(36);
        }

        public int getSendBufferSize() {
            return this.base.getSocketOpt(11);
        }

        @Deprecated
        public boolean setSendBufferSize(long value2) {
            return this.setSendBufferSize(Long.valueOf(value2).intValue());
        }

        public boolean setSendBufferSize(int value2) {
            return this.setSocketOpt(11, value2);
        }

        public int getReceiveBufferSize() {
            return this.base.getSocketOpt(12);
        }

        @Deprecated
        public boolean setReceiveBufferSize(long value2) {
            return this.setReceiveBufferSize(Long.valueOf(value2).intValue());
        }

        public boolean setReceiveBufferSize(int value2) {
            return this.setSocketOpt(12, value2);
        }

        public boolean hasReceiveMore() {
            return this.base.getSocketOpt(13) == 1;
        }

        public SelectableChannel getFD() {
            return (SelectableChannel)this.base.getSocketOptx(14);
        }

        public int getEvents() {
            return this.base.getSocketOpt(15);
        }

        public boolean subscribe(byte[] topic) {
            return this.setSocketOpt(6, topic);
        }

        public boolean subscribe(String topic) {
            return this.setSocketOpt(6, topic);
        }

        public boolean unsubscribe(byte[] topic) {
            return this.setSocketOpt(7, topic);
        }

        public boolean unsubscribe(String topic) {
            return this.setSocketOpt(7, topic);
        }

        @Deprecated
        public boolean setEncoder(Class<? extends IEncoder> cls) {
            return this.setSocketOpt(1001, cls);
        }

        @Deprecated
        public boolean setDecoder(Class<? extends IDecoder> cls) {
            return this.setSocketOpt(1002, cls);
        }

        public boolean setMsgAllocationHeapThreshold(int threshold) {
            return this.setSocketOpt(1004, threshold);
        }

        public int getMsgAllocationHeapThreshold() {
            return this.base.getSocketOpt(1004);
        }

        public boolean setMsgAllocator(MsgAllocator allocator) {
            return this.setSocketOpt(1003, allocator);
        }

        public boolean setConnectRid(String rid) {
            return this.setSocketOpt(61, rid);
        }

        public boolean setConnectRid(byte[] rid) {
            return this.setSocketOpt(61, rid);
        }

        public boolean setRouterRaw(boolean raw) {
            return this.setSocketOpt(41, raw);
        }

        public boolean setProbeRouter(boolean probe) {
            return this.setSocketOpt(51, probe);
        }

        public boolean setRouterMandatory(boolean mandatory) {
            return this.setSocketOpt(33, mandatory);
        }

        public boolean setRouterHandover(boolean handover) {
            return this.setSocketOpt(56, handover);
        }

        public boolean setXpubVerbose(boolean verbose) {
            return this.setSocketOpt(40, verbose);
        }

        public boolean setXpubNoDrop(boolean noDrop) {
            return this.setSocketOpt(69, noDrop);
        }

        @Deprecated
        public boolean getIPv4Only() {
            return !this.isIPv6();
        }

        public boolean isIPv6() {
            return (Boolean)this.base.getSocketOptx(42);
        }

        public boolean getIPv6() {
            return this.isIPv6();
        }

        @Deprecated
        public boolean setIPv4Only(boolean v4only) {
            return this.setIPv6(!v4only);
        }

        public boolean setIPv6(boolean v6) {
            return this.setSocketOpt(42, v6);
        }

        public int getTCPKeepAlive() {
            return this.base.getSocketOpt(34);
        }

        public boolean setTCPKeepAlive(int optVal) {
            return this.setSocketOpt(34, optVal);
        }

        @Deprecated
        public boolean getDelayAttachOnConnect() {
            return !this.isImmediate();
        }

        @Deprecated
        public boolean setDelayAttachOnConnect(boolean value2) {
            return this.setImmediate(!value2);
        }

        public boolean isImmediate() {
            return (Boolean)this.base.getSocketOptx(1039);
        }

        public boolean getImmediate() {
            return this.isImmediate();
        }

        public boolean setImmediate(boolean value2) {
            return this.setSocketOpt(1039, value2);
        }

        public boolean setSocksProxy(String proxy) {
            return this.setSocketOpt(67, proxy);
        }

        public boolean setSocksProxy(byte[] proxy) {
            return this.setSocketOpt(67, proxy);
        }

        public String getSocksProxy() {
            return (String)this.base.getSocketOptx(67);
        }

        public String getLastEndpoint() {
            return (String)this.base.getSocketOptx(32);
        }

        public boolean setZapDomain(String domain) {
            return this.setSocketOpt(55, domain);
        }

        public boolean setZapDomain(byte[] domain) {
            return this.setSocketOpt(55, domain);
        }

        public String getZapDomain() {
            return (String)this.base.getSocketOptx(55);
        }

        public boolean setZAPDomain(String domain) {
            return this.setZapDomain(domain);
        }

        public boolean setZAPDomain(byte[] domain) {
            return this.setZapDomain(domain);
        }

        public String getZAPDomain() {
            return this.getZapDomain();
        }

        @Deprecated
        public boolean setAsServerPlain(boolean server) {
            return this.setPlainServer(server);
        }

        public boolean setPlainServer(boolean server) {
            return this.setSocketOpt(44, server);
        }

        @Deprecated
        public boolean isAsServerPlain() {
            return this.getPlainServer();
        }

        @Deprecated
        public boolean getAsServerPlain() {
            return this.getPlainServer();
        }

        public boolean getPlainServer() {
            return (Boolean)this.base.getSocketOptx(44);
        }

        public boolean setPlainUsername(String username) {
            return this.base.setSocketOpt(45, username);
        }

        public boolean setPlainPassword(String password) {
            return this.base.setSocketOpt(46, password);
        }

        public boolean setPlainUsername(byte[] username) {
            return this.base.setSocketOpt(45, username);
        }

        public boolean setPlainPassword(byte[] password) {
            return this.base.setSocketOpt(46, password);
        }

        public String getPlainUsername() {
            return (String)this.base.getSocketOptx(45);
        }

        public String getPlainPassword() {
            return (String)this.base.getSocketOptx(46);
        }

        @Deprecated
        public boolean setAsServerCurve(boolean server) {
            return this.setCurveServer(server);
        }

        public boolean setCurveServer(boolean server) {
            return this.setSocketOpt(47, server);
        }

        @Deprecated
        public boolean isAsServerCurve() {
            return this.getCurveServer();
        }

        public boolean getCurveServer() {
            return (Boolean)this.base.getSocketOptx(47);
        }

        @Deprecated
        public boolean getAsServerCurve() {
            return this.getCurveServer();
        }

        public boolean setCurvePublicKey(byte[] key) {
            return this.setSocketOpt(48, key);
        }

        public boolean setCurveServerKey(byte[] key) {
            return this.setSocketOpt(50, key);
        }

        public boolean setCurveSecretKey(byte[] key) {
            return this.setSocketOpt(49, key);
        }

        public byte[] getCurvePublicKey() {
            return (byte[])this.base.getSocketOptx(48);
        }

        public byte[] getCurveServerKey() {
            return (byte[])this.base.getSocketOptx(50);
        }

        public byte[] getCurveSecretKey() {
            return (byte[])this.base.getSocketOptx(49);
        }

        public Mechanism getMechanism() {
            return Mechanism.find((Mechanisms)((Object)this.base.getSocketOptx(43)));
        }

        public boolean bind(String addr) {
            boolean rc = this.base.bind(addr);
            this.mayRaise();
            return rc;
        }

        public int bindToRandomPort(String addr) {
            return this.bindToRandomPort(addr, 49152, 65535);
        }

        public int bindToRandomPort(String addr, int min2, int max2) {
            Random rand = new Random();
            for (int i = 0; i < 100; ++i) {
                int port = rand.nextInt(max2 - min2 + 1) + min2;
                if (!this.base.bind(String.format("%s:%s", addr, port))) continue;
                return port;
            }
            throw new ZMQException("Could not bind socket to random port.", 48);
        }

        public boolean connect(String addr) {
            boolean rc = this.base.connect(addr);
            this.mayRaise();
            return rc;
        }

        public boolean disconnect(String addr) {
            return this.base.termEndpoint(addr);
        }

        public boolean unbind(String addr) {
            return this.base.termEndpoint(addr);
        }

        public boolean send(String data) {
            return this.send(data.getBytes(CHARSET), 0);
        }

        public boolean sendMore(String data) {
            return this.send(data.getBytes(CHARSET), 2);
        }

        public boolean send(String data, int flags) {
            return this.send(data.getBytes(CHARSET), flags);
        }

        public boolean send(byte[] data) {
            return this.send(data, 0);
        }

        public boolean sendMore(byte[] data) {
            return this.send(data, 2);
        }

        public boolean send(byte[] data, int flags) {
            Msg msg = new Msg(data);
            if (this.base.send(msg, flags)) {
                return true;
            }
            this.mayRaise();
            return false;
        }

        public boolean send(byte[] data, int off, int length2, int flags) {
            byte[] copy2 = new byte[length2];
            System.arraycopy(data, off, copy2, 0, length2);
            Msg msg = new Msg(copy2);
            if (this.base.send(msg, flags)) {
                return true;
            }
            this.mayRaise();
            return false;
        }

        public int sendByteBuffer(ByteBuffer data, int flags) {
            Msg msg = new Msg(data);
            if (this.base.send(msg, flags)) {
                return msg.size();
            }
            this.mayRaise();
            return -1;
        }

        public byte[] recv() {
            return this.recv(0);
        }

        public byte[] recv(int flags) {
            Msg msg = this.base.recv(flags);
            if (msg != null) {
                return msg.data();
            }
            this.mayRaise();
            return null;
        }

        public int recv(byte[] buffer2, int offset, int len2, int flags) {
            Msg msg = this.base.recv(flags);
            if (msg != null) {
                return msg.getBytes(0, buffer2, offset, len2);
            }
            return -1;
        }

        public int recvByteBuffer(ByteBuffer buffer2, int flags) {
            Msg msg = this.base.recv(flags);
            if (msg != null) {
                buffer2.put(msg.buf());
                return msg.size();
            }
            this.mayRaise();
            return -1;
        }

        public String recvStr() {
            return this.recvStr(0);
        }

        public String recvStr(int flags) {
            byte[] msg = this.recv(flags);
            if (msg != null) {
                return new String(msg, CHARSET);
            }
            return null;
        }

        public boolean monitor(String addr, int events) {
            return this.base.monitor(addr, events);
        }

        private void mayRaise() {
            int errno = this.base.errno();
            if (errno != 0 && errno != 35) {
                throw new ZMQException(errno);
            }
        }

        public int errno() {
            return this.base.errno();
        }

        public String toString() {
            return this.base.toString();
        }

        public static enum Mechanism {
            NULL(Mechanisms.NULL),
            PLAIN(Mechanisms.PLAIN),
            CURVE(Mechanisms.CURVE);

            private final Mechanisms mech;

            private Mechanism(Mechanisms zmq) {
                this.mech = zmq;
            }

            private static Mechanism find(Mechanisms mech) {
                for (Mechanism candidate : Mechanism.values()) {
                    if (candidate.mech != mech) continue;
                    return candidate;
                }
                return null;
            }
        }
    }

    public static class Context
    implements Closeable {
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final Ctx ctx;

        protected Context(int ioThreads) {
            this.ctx = zmq.ZMQ.init(ioThreads);
        }

        public boolean isTerminated() {
            return !this.ctx.checkTag();
        }

        public int getIOThreads() {
            return this.ctx.get(1);
        }

        public boolean setIOThreads(int ioThreads) {
            return this.ctx.set(1, ioThreads);
        }

        public int getMaxSockets() {
            return this.ctx.get(2);
        }

        public boolean setMaxSockets(int maxSockets) {
            return this.ctx.set(2, maxSockets);
        }

        @Deprecated
        public boolean getBlocky() {
            return this.isBlocky();
        }

        public boolean isBlocky() {
            return this.ctx.get(70) != 0;
        }

        public boolean setBlocky(boolean block) {
            return this.ctx.set(70, block ? 1 : 0);
        }

        public boolean isIPv6() {
            return this.ctx.get(42) != 0;
        }

        public boolean getIPv6() {
            return this.isIPv6();
        }

        public boolean setIPv6(boolean ipv6) {
            return this.ctx.set(42, ipv6 ? 1 : 0);
        }

        public void term() {
            if (this.closed.compareAndSet(false, true)) {
                this.ctx.terminate();
            }
        }

        public boolean isClosed() {
            return this.closed.get();
        }

        public Socket socket(int type) {
            return new Socket(this, type);
        }

        public Selector selector() {
            return this.ctx.createSelector();
        }

        public boolean close(Selector selector) {
            return this.ctx.closeSelector(selector);
        }

        public Poller poller() {
            return new Poller(this);
        }

        public Poller poller(int size2) {
            return new Poller(this, size2);
        }

        @Override
        public void close() {
            this.term();
        }
    }
}

