/*
 * Decompiled with CFR 0.152.
 */
package zmq.socket.pubsub;

import zmq.Ctx;
import zmq.Msg;
import zmq.SocketBase;
import zmq.pipe.Pipe;
import zmq.socket.FQ;
import zmq.socket.pubsub.Dist;
import zmq.socket.pubsub.Trie;
import zmq.util.Blob;

public class XSub
extends SocketBase {
    private final FQ fq;
    private final Dist dist;
    private final Trie subscriptions;
    private boolean hasMessage;
    private Msg message;
    private boolean more;
    private final Trie.ITrieHandler sendSubscription = new SendSubscription();

    public XSub(Ctx parent2, int tid, int sid) {
        super(parent2, tid, sid);
        this.options.type = 10;
        this.hasMessage = false;
        this.more = false;
        this.options.linger = 0;
        this.fq = new FQ();
        this.dist = new Dist();
        this.subscriptions = new Trie();
        this.message = new Msg();
    }

    @Override
    protected void xattachPipe(Pipe pipe, boolean subscribe2all) {
        assert (pipe != null);
        this.fq.attach(pipe);
        this.dist.attach(pipe);
        this.subscriptions.apply(this.sendSubscription, pipe);
        pipe.flush();
    }

    @Override
    protected void xreadActivated(Pipe pipe) {
        this.fq.activated(pipe);
    }

    @Override
    protected void xwriteActivated(Pipe pipe) {
        this.dist.activated(pipe);
    }

    @Override
    protected void xpipeTerminated(Pipe pipe) {
        this.fq.terminated(pipe);
        this.dist.terminated(pipe);
    }

    @Override
    protected void xhiccuped(Pipe pipe) {
        this.subscriptions.apply(this.sendSubscription, pipe);
        pipe.flush();
    }

    @Override
    protected boolean xsend(Msg msg) {
        int size2 = msg.size();
        if (size2 > 0 && msg.get(0) == 1) {
            this.subscriptions.add(msg, 1, size2 - 1);
            return this.dist.sendToAll(msg);
        }
        if (size2 > 0 && msg.get(0) == 0) {
            if (this.subscriptions.rm(msg, 1, size2 - 1)) {
                return this.dist.sendToAll(msg);
            }
        } else {
            return this.dist.sendToAll(msg);
        }
        return true;
    }

    @Override
    protected boolean xhasOut() {
        return true;
    }

    @Override
    protected Msg xrecv() {
        if (this.hasMessage) {
            Msg msg = this.message;
            this.hasMessage = false;
            this.more = msg.hasMore();
            return msg;
        }
        block0: while (true) {
            Msg msg;
            if ((msg = this.fq.recv(this.errno)) == null) {
                return null;
            }
            if (this.more || !this.options.filter || this.match(msg)) {
                this.more = msg.hasMore();
                return msg;
            }
            do {
                if (!msg.hasMore()) continue block0;
                msg = this.fq.recv(this.errno);
            } while ($assertionsDisabled || msg != null);
            break;
        }
        throw new AssertionError();
    }

    @Override
    protected boolean xhasIn() {
        if (this.more) {
            return true;
        }
        if (this.hasMessage) {
            return true;
        }
        block0: while (true) {
            this.message = this.fq.recv(this.errno);
            if (this.message == null) {
                assert (this.errno.is(35));
                return false;
            }
            if (!this.options.filter || this.match(this.message)) {
                this.hasMessage = true;
                return true;
            }
            do {
                if (!this.message.hasMore()) continue block0;
                this.message = this.fq.recv(this.errno);
            } while ($assertionsDisabled || this.message != null);
            break;
        }
        throw new AssertionError();
    }

    @Override
    protected Blob getCredential() {
        return this.fq.getCredential();
    }

    private boolean match(Msg msg) {
        return this.subscriptions.check(msg.buf());
    }

    private boolean sendSubscription(byte[] data, int size2, Pipe pipe) {
        Msg msg = new Msg(size2 + 1);
        msg.put((byte)1).put(data, 0, size2);
        boolean sent = pipe.write(msg);
        return sent;
    }

    private final class SendSubscription
    implements Trie.ITrieHandler {
        private SendSubscription() {
        }

        @Override
        public void added(byte[] data, int size2, Pipe pipe) {
            XSub.this.sendSubscription(data, size2, pipe);
        }
    }
}

