/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jdk8;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.datatype.jdk8.BaseScalarOptionalDeserializer;
import java.io.IOException;
import java.util.OptionalDouble;

class OptionalDoubleDeserializer
extends BaseScalarOptionalDeserializer<OptionalDouble> {
    private static final long serialVersionUID = 1L;
    static final OptionalDoubleDeserializer INSTANCE = new OptionalDoubleDeserializer();

    public OptionalDoubleDeserializer() {
        super(OptionalDouble.class, OptionalDouble.empty());
    }

    @Override
    public OptionalDouble deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
            return OptionalDouble.of(p.getDoubleValue());
        }
        switch (p.getCurrentTokenId()) {
            case 6: {
                String text2 = p.getText().trim();
                if (text2.length() == 0) {
                    this._coerceEmptyString(ctxt, false);
                    return (OptionalDouble)this._empty;
                }
                if (this._hasTextualNull(text2)) {
                    this._coerceTextualNull(ctxt, false);
                    return (OptionalDouble)this._empty;
                }
                return OptionalDouble.of(this._parseDoublePrimitive(ctxt, text2));
            }
            case 7: {
                return OptionalDouble.of(p.getDoubleValue());
            }
            case 11: {
                return (OptionalDouble)this._empty;
            }
            case 3: {
                if (!ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                p.nextToken();
                OptionalDouble parsed = this.deserialize(p, ctxt);
                this._verifyEndArrayForSingle(p, ctxt);
                return parsed;
            }
        }
        return (OptionalDouble)ctxt.handleUnexpectedToken(this._valueClass, p);
    }
}

