/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.anomaly;

import org.apache.iotdb.library.util.CircularQueue;
import org.apache.iotdb.library.util.LongCircularQueue;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFKSigma
implements UDTF {
    private double mean = 0.0;
    private double variance = 0.0;
    private double sumX2 = 0.0;
    private double sumX1 = 0.0;
    private double multipleK;
    private int windowSize = 0;
    private CircularQueue<Object> v;
    private LongCircularQueue t;
    private Type dataType;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE).validate(x -> (Integer)x > 0, "Window size should be larger than 0.", (Object)validator.getParameters().getIntOrDefault("window", 10)).validate(x -> (Double)x > 0.0, "Parameter k should be larger than 0.", (Object)validator.getParameters().getDoubleOrDefault("k", 3.0));
    }

    @Override
    public void beforeStart(UDFParameters udfParameters, UDTFConfigurations udtfConfigurations) throws Exception {
        udtfConfigurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(udfParameters.getDataType(0));
        this.multipleK = udfParameters.getDoubleOrDefault("k", 3.0);
        this.dataType = udfParameters.getDataType(0);
        this.windowSize = udfParameters.getIntOrDefault("window", 10000);
        this.v = new CircularQueue(this.windowSize);
        this.t = new LongCircularQueue(this.windowSize);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        double value = Util.getValueAsDouble(row);
        long timestamp = row.getTime();
        if (Double.isFinite(value) && !Double.isNaN(value)) {
            if (this.v.isFull()) {
                double frontValue = Double.parseDouble(this.v.pop().toString());
                switch (this.dataType) {
                    case INT32: {
                        this.v.push(row.getInt(0));
                        break;
                    }
                    case INT64: {
                        this.v.push(row.getLong(0));
                        break;
                    }
                    case DOUBLE: {
                        this.v.push(row.getDouble(0));
                        break;
                    }
                    case FLOAT: {
                        this.v.push(Float.valueOf(row.getFloat(0)));
                        break;
                    }
                }
                this.t.pop();
                this.t.push(timestamp);
                this.sumX1 = this.sumX1 - frontValue + value;
                this.sumX2 = this.sumX2 - frontValue * frontValue + value * value;
                this.mean = this.sumX1 / (double)this.v.getSize();
                this.variance = this.sumX2 / (double)this.v.getSize() - this.mean * this.mean;
                if (Math.abs(value - this.mean) > this.multipleK * Math.sqrt(this.variance * (double)this.v.getSize() / (double)(this.v.getSize() - 1))) {
                    Util.putValue(collector, this.dataType, timestamp, Util.getValueAsObject(row));
                }
            } else {
                switch (this.dataType) {
                    case INT32: {
                        this.v.push(row.getInt(0));
                        break;
                    }
                    case INT64: {
                        this.v.push(row.getLong(0));
                        break;
                    }
                    case DOUBLE: {
                        this.v.push(row.getDouble(0));
                        break;
                    }
                    case FLOAT: {
                        this.v.push(Float.valueOf(row.getFloat(0)));
                        break;
                    }
                }
                this.t.push(timestamp);
                this.sumX1 += value;
                this.sumX2 += value * value;
                this.mean = this.sumX1 / (double)this.v.getSize();
                this.variance = this.sumX2 / (double)this.v.getSize() - this.mean * this.mean;
                if (this.v.getSize() == this.windowSize) {
                    double stddev = Math.sqrt(this.variance * (double)this.v.getSize() / (double)(this.v.getSize() - 1));
                    for (int i = 0; i < this.v.getSize(); ++i) {
                        Object vi = this.v.get(i);
                        timestamp = this.t.get(i);
                        if (!(Math.abs(Double.parseDouble(vi.toString()) - this.mean) > this.multipleK * stddev)) continue;
                        Util.putValue(collector, this.dataType, timestamp, vi);
                    }
                }
            }
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        if (!this.v.isFull() && this.v.getSize() > 1) {
            double stddev = Math.sqrt(this.variance * (double)this.v.getSize() / (double)(this.v.getSize() - 1));
            for (int i = 0; i < this.v.getSize(); ++i) {
                Object vi = this.v.get(i);
                long timestamp = this.t.get(i);
                if (!(Math.abs(Double.parseDouble(vi.toString()) - this.mean) > this.multipleK * stddev)) continue;
                Util.putValue(collector, this.dataType, timestamp, vi);
            }
        }
    }
}

