/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.match;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.iotdb.library.match.model.Bounds;
import org.apache.iotdb.library.match.model.PatternCalculationResult;
import org.apache.iotdb.library.match.model.PatternContext;
import org.apache.iotdb.library.match.model.PatternResult;
import org.apache.iotdb.library.match.model.Point;
import org.apache.iotdb.library.match.model.Section;
import org.apache.iotdb.library.match.model.SectionCalculation;
import org.apache.iotdb.library.match.model.SectionNext;
import org.apache.iotdb.library.match.utils.LinearScale;
import org.apache.iotdb.library.match.utils.TimeScale;

public class PatternExecutor {
    List<Point> points = new ArrayList<Point>();
    List<Double> tangents = new ArrayList<Double>();
    List<Section> sections = new ArrayList<Section>();
    Long queryLength = null;
    Long queryLengthTolerance = null;
    Long queryHeight = null;
    Long queryHeightTolerance = null;

    public List<Point> extractPoints(Long[] times, Double[] values) {
        ArrayList<Point> points = new ArrayList<Point>();
        double px = times[0].longValue();
        for (int i = 0; i < times.length; ++i) {
            if (!((double)times[i].longValue() >= px)) continue;
            points.add(new Point(times[i].longValue(), values[i], times[i].longValue(), values[i]));
            px += 1.0;
        }
        double originY = points.stream().map(Point::getY).min(Double::compare).orElseGet(() -> 0.0);
        double originX = points.stream().map(Point::getX).min(Double::compare).orElseGet(() -> 0.0);
        for (int i = 0; i < points.size(); ++i) {
            Point pt = (Point)points.get(i);
            pt.setY(pt.getY() - originY);
            pt.setX(pt.getX() - originX);
        }
        return points;
    }

    public List<Point> extractPoints(List<Point> sourcePoints) {
        int i;
        ArrayList<Point> points = new ArrayList<Point>();
        double px = sourcePoints.get(0).getX();
        for (i = 0; i < sourcePoints.size(); ++i) {
            Point p = sourcePoints.get(i);
            if (!(p.getX() >= px)) continue;
            points.add(new Point(p.getX(), p.getY(), p.getX(), p.getY()));
            px += 1.0;
        }
        double originY = points.stream().map(Point::getY).max(Double::compare).orElseGet(() -> 0.0);
        double originX = points.stream().map(Point::getX).min(Double::compare).orElseGet(() -> 0.0);
        for (i = 0; i < points.size(); ++i) {
            Point pt = (Point)points.get(i);
            pt.setY(pt.getY());
            pt.setX(pt.getX() - originX);
        }
        return points;
    }

    public void setPoints(List<Point> points) {
        this.points = points;
        this.tangents = this.extractTangents(points);
        this.sections = this.findCurveSections(this.tangents, points, 0.01);
    }

    public List<Point> scalePoint(List<Long> times, List<Double> values) {
        ArrayList<Point> points = new ArrayList<Point>();
        TimeScale xScale = new TimeScale(times.get(0), times.get(times.size() - 1), 0.0, 1000.0);
        double minY = values.stream().min(Double::compare).orElseGet(() -> 0.0);
        double maxY = values.stream().max(Double::compare).orElseGet(() -> 0.0);
        LinearScale<Double> yScale = new LinearScale<Double>(minY, maxY, 0.0, 500.0);
        for (int i = 0; i < times.size(); ++i) {
            points.add(new Point(xScale.scale(times.get(i)), yScale.scale(values.get(i)), times.get(i).longValue(), values.get(i)));
        }
        return points;
    }

    public List<Point> scalePoint(List<Point> sourcePoints) {
        ArrayList<Point> points = new ArrayList<Point>();
        TimeScale xScale = new TimeScale((long)sourcePoints.get(0).getX(), (long)sourcePoints.get(sourcePoints.size() - 1).getX(), 0.0, 1000.0);
        double minY = sourcePoints.stream().map(Point::getY).min(Double::compare).orElseGet(() -> 0.0);
        double maxY = sourcePoints.stream().map(Point::getY).max(Double::compare).orElseGet(() -> 0.0);
        LinearScale<Double> yScale = new LinearScale<Double>(minY, maxY, 0.0, 500.0);
        for (int i = 0; i < sourcePoints.size(); ++i) {
            Point p = sourcePoints.get(i);
            points.add(new Point(xScale.scale((long)p.getX()), yScale.scale(p.getY()), p.getX(), p.getY()));
        }
        return points;
    }

    public List<PatternResult> executeQuery(PatternContext queryCtx) {
        this.executeQueryInSI(queryCtx);
        return queryCtx.getMatches();
    }

    private void executeQueryInSI(PatternContext queryCtx) {
        int dsi = 0;
        if (queryCtx.getDatasetSize() == null) {
            queryCtx.setDatasetSize(queryCtx.getDataPoints().get(queryCtx.getDataPoints().size() - 1).getX() - queryCtx.getDataPoints().get(0).getX());
        }
        List<Double> dataTangents = this.extractTangents(queryCtx.getDataPoints());
        List<Section> dataSections = this.findCurveSections(dataTangents, queryCtx.getDataPoints(), 0.01);
        for (dsi = 0; dsi < dataSections.size(); ++dsi) {
            for (int i = 0; i < this.sections.size(); ++i) {
                for (int j = 0; j < this.sections.get(i).getNext().size(); ++j) {
                    this.sections.get(i).getNext().get(j).setTimes(1);
                }
            }
            if (!this.matchIn(this.sections.get(0), dataSections, dsi, new ArrayList<Section>(), queryCtx, this.sections.get(this.sections.size() - 1))) break;
        }
    }

    private double tangent(Point p1, Point p2) {
        return (p2.getY() - p1.getY()) / (p2.getX() - p1.getX());
    }

    private List<Double> extractTangents(List<Point> points) {
        if (points.size() < 2) {
            return new ArrayList<Double>();
        }
        ArrayList<Double> tangents = new ArrayList<Double>();
        tangents.add(this.tangent(points.get(0), points.get(1)));
        for (int i = 1; i < points.size(); ++i) {
            tangents.add(this.tangent(points.get(i - 1), points.get(i)));
        }
        return tangents;
    }

    private double calcWidth(List<Point> points) {
        return points.get(points.size() - 1).getX() - points.get(0).getX();
    }

    private double calcHeight(List<Point> points) {
        return points.stream().map(Point::getY).max(Double::compare).orElseGet(() -> 0.0) - points.stream().map(Point::getY).min(Double::compare).orElseGet(() -> 0.0);
    }

    private List<Section> findCurveSections(List<Double> tangents, List<Point> points, double minHeightPerc) {
        ArrayList<Section> sections = new ArrayList<Section>();
        Double lastTg = null;
        Point lastPt = null;
        double totalHeight = this.calcHeight(points);
        double lastSectHeight = 0.0;
        for (int i = 0; i < tangents.size(); ++i) {
            Section lastSect;
            Double tangent = tangents.get(i);
            Point pt = points.get(i);
            double sign = Math.signum(tangent);
            if (sections.size() == 0) {
                sections.add(new Section(sign));
            } else if (sign != 0.0 && (lastSect = (Section)sections.get(sections.size() - 1)).getSign() != sign) {
                lastSectHeight = this.calcHeight(lastSect.getPoints());
                if (lastSect.getPoints().size() > 1 && (!(minHeightPerc > 0.0) || lastSectHeight / totalHeight > minHeightPerc)) {
                    Section newSection = new Section(sign);
                    sections.add(newSection);
                    newSection.getPoints().add(lastPt);
                    newSection.getTangents().add(lastTg);
                }
            }
            lastSect = (Section)sections.get(sections.size() - 1);
            lastSect.getPoints().add(pt);
            lastSect.getTangents().add(tangent);
            lastTg = tangent;
            lastPt = pt;
        }
        int count = 0;
        Section prev = null;
        for (Section s2 : sections) {
            s2.setId(count++);
            if (prev != null) {
                prev.getNext().add(new SectionNext(s2));
            }
            prev = s2;
        }
        prev.setNext(new ArrayList<SectionNext>());
        return sections;
    }

    private boolean matchIn(Section currSect, List<Section> dataSections, int dsi, List<Section> qSections, PatternContext queryCtx, Section lastQuerySect) {
        if (qSections.size() > 25) {
            return false;
        }
        PatternResult matchValue = null;
        int i = 0;
        ArrayList<Section> sectsBlock = new ArrayList<Section>();
        sectsBlock.add(currSect);
        while (currSect.getNext().size() == 1 && currSect != lastQuerySect) {
            currSect = currSect.getNext().get(0).getDest();
            sectsBlock.add(currSect);
        }
        if (dsi + sectsBlock.size() + qSections.size() > dataSections.size()) {
            return false;
        }
        if (qSections.size() > 0) {
            Point lastQSectionsSectPt = qSections.get(qSections.size() - 1).getPoints().get(qSections.get(qSections.size() - 1).getPoints().size() - 1);
            Point firstSectsBlockPt = ((Section)sectsBlock.get(0)).getPoints().get(0);
            if (firstSectsBlockPt.getX() < lastQSectionsSectPt.getX()) {
                double offset = -firstSectsBlockPt.getX() + lastQSectionsSectPt.getX();
                double offseto = -firstSectsBlockPt.getOrigX() + lastQSectionsSectPt.getOrigX();
                for (i = 0; i < sectsBlock.size(); ++i) {
                    sectsBlock.set(i, ((Section)sectsBlock.get(i)).translateXCopy(offset, offseto));
                }
            }
        }
        ArrayList<Section> newQSections = new ArrayList<Section>(qSections);
        newQSections.addAll(sectsBlock);
        List<Section> dataSectsForQ = dataSections.subList(dsi, dsi + newQSections.size());
        if (currSect == lastQuerySect && (currSect.getNext().size() == 0 || currSect.getNext().get(0).getSize() != 0 || currSect.getNext().get(0).getSize() == currSect.getNext().get(0).getTimes()) && (matchValue = this.calculateMatch(dataSectsForQ, newQSections, queryCtx, false)) != null) {
            int duplicateMatchIdx = -1;
            if (duplicateMatchIdx == -1) {
                matchValue.setId(queryCtx.getMatches().size());
                queryCtx.getMatches().add(matchValue);
            } else if (queryCtx.getMatches().get(duplicateMatchIdx).getMatch() > matchValue.getMatch()) {
                matchValue.setId(queryCtx.getMatches().get(duplicateMatchIdx).getId());
                queryCtx.getMatches().set(duplicateMatchIdx, matchValue);
            }
        }
        if (!currSect.getNext().isEmpty()) {
            boolean backLink = false;
            for (i = currSect.getNext().size() - 1; i >= 0; --i) {
                SectionNext next = currSect.getNext().get(i);
                if (currSect == lastQuerySect || i > 0) {
                    if (next.getSize() != 0) {
                        this.matchIn(next.getDest(), dataSections, dsi, newQSections, queryCtx, lastQuerySect);
                        continue;
                    }
                    if (next.getTimes() >= next.getSize()) continue;
                    next.setTimes(next.getTimes() + 1);
                    backLink = true;
                    this.matchIn(next.getDest(), dataSections, dsi, newQSections, queryCtx, lastQuerySect);
                    continue;
                }
                if (backLink) continue;
                this.matchIn(next.getDest(), dataSections, dsi, newQSections, queryCtx, lastQuerySect);
            }
        }
        return true;
    }

    private PatternResult calculateMatch(List<Section> matchedSections, List<Section> querySections, PatternContext queryCtx, boolean partialQuery) {
        PatternCalculationResult pointsMatchRes = this.calculatePointsMatch(querySections, matchedSections, partialQuery);
        if (pointsMatchRes == null || pointsMatchRes.getMatchedPoints().isEmpty()) {
            return null;
        }
        if (pointsMatchRes.getMatch() > (double)queryCtx.getThreshold()) {
            return null;
        }
        if (partialQuery) {
            PatternResult result = new PatternResult();
            result.setMatch(pointsMatchRes.getMatch());
            return result;
        }
        List<Point> matchedPts = pointsMatchRes.getMatchedPoints();
        double minPos = matchedPts.get(0).getX();
        double maxPos = matchedPts.get(matchedPts.size() - 1).getX();
        double matchSize = (maxPos - minPos) / queryCtx.getDatasetSize();
        double matchPos = (maxPos + minPos) / 2.0 / queryCtx.getDatasetSize();
        Long matchTimeSpan = Math.round(matchedPts.get(matchedPts.size() - 1).getOrigX() - matchedPts.get(0).getOrigX());
        if (this.queryHeight != null && !this.checkQueryHeight(this.calculateMatchHeight(matchedPts))) {
            return null;
        }
        PatternResult result = new PatternResult();
        result.setMatch(pointsMatchRes.getMatch());
        result.setPoints(matchedPts);
        result.setSize(matchSize);
        result.setMatchPos(matchPos);
        result.setTimespan(matchTimeSpan);
        result.setMinPos(minPos);
        result.setMaxPos(maxPos);
        result.setSections(matchedSections);
        return result;
    }

    private PatternCalculationResult calculatePointsMatch(List<Section> querySections, List<Section> matchedSections, boolean partialQuery) {
        if (!this.areCompatibleSections(querySections, matchedSections, !partialQuery)) {
            return null;
        }
        Bounds matchedSecBounds = this.getBounds(matchedSections, matchedSections.size() > 2 ? 1 : 0, matchedSections.size() - (matchedSections.size() > 2 ? 2 : 1));
        Bounds queryBounds = this.getBounds(querySections, querySections.size() > 2 ? 1 : 0, querySections.size() - (querySections.size() > 2 ? 2 : 1));
        double subSequenceScaleFactorX = (matchedSecBounds.getMaxX() - matchedSecBounds.getMinX()) / (queryBounds.getMaxX() - queryBounds.getMinX());
        double subSequenceScaleFactorY = (matchedSecBounds.getMaxY() - matchedSecBounds.getMinY()) / (queryBounds.getMaxY() - queryBounds.getMinY());
        ArrayList<Point> matchedPoints = new ArrayList<Point>();
        double pointDifferencesCost = 0.0;
        double rescalingCost = 0.0;
        double sum = 0.0;
        double num = 0.0;
        for (int si = 0; si < querySections.size(); ++si) {
            int i;
            SectionCalculation dataSect = new SectionCalculation();
            SectionCalculation querySect = new SectionCalculation();
            sum = 0.0;
            num = 0.0;
            querySect.setPoints(querySections.get(si).getPoints());
            querySect.setWidth(this.calcWidth(querySect.getPoints()));
            querySect.setHeight(this.calcHeight(querySect.getPoints()));
            if (querySect.getHeight() == 0.0) continue;
            if (si == 0 && querySections.size() > 2) {
                dataSect.setPoints(this.sectionEndSubpartPoints(matchedSections.get(si), querySect.getWidth() * subSequenceScaleFactorX));
            } else if (si == querySections.size() - 1 && querySections.size() > 2) {
                dataSect.setPoints(this.sectionStartSubpartPoints(matchedSections.get(si), querySect.getWidth() * subSequenceScaleFactorX));
            } else {
                dataSect.setPoints(matchedSections.get(si).getPoints());
            }
            dataSect.setWidth(this.calcWidth(dataSect.getPoints()));
            dataSect.setHeight(this.calcHeight(dataSect.getPoints()));
            if (dataSect.getHeight() == 0.0) continue;
            double scaleFactorX = dataSect.getWidth() / (querySect.getWidth() * subSequenceScaleFactorX);
            double scaleFactorY = dataSect.getHeight() / (querySect.getHeight() * subSequenceScaleFactorY);
            if (scaleFactorX != 0.0 && scaleFactorY != 0.0) {
                rescalingCost += Math.pow(Math.log(scaleFactorX), 2.0) + Math.pow(Math.log(scaleFactorY), 2.0);
            }
            dataSect.setCentroidY(0.0);
            for (i = 0; i < dataSect.getPoints().size(); ++i) {
                dataSect.setCentroidY(dataSect.getCentroidY() + dataSect.getPoints().get(i).getY());
            }
            dataSect.setCentroidY(dataSect.getCentroidY() / (double)dataSect.getPoints().size());
            querySect.setCentroidY(0.0);
            for (i = 0; i < querySect.getPoints().size(); ++i) {
                querySect.setCentroidY(querySect.getPoints().get(0).getY() * subSequenceScaleFactorY * scaleFactorY);
            }
            querySect.setCentroidY(querySect.getCentroidY() / (double)querySect.getPoints().size());
            double centroidsDifference = querySect.getPoints().get(0).getY() * subSequenceScaleFactorY * scaleFactorY - dataSect.getPoints().get(0).getY();
            double queryPtsStep = (double)querySect.getPoints().size() / (double)dataSect.getPoints().size();
            for (i = 0; i < dataSect.getPoints().size(); ++i) {
                Point dataPt = dataSect.getPoints().get(i);
                Point queryPt = querySect.getPoints().get((int)Math.floor((double)i * queryPtsStep));
                double resSum = Math.abs(queryPt.getY() * subSequenceScaleFactorY * scaleFactorY - centroidsDifference - dataPt.getY()) / dataSect.getHeight();
                sum += resSum;
                num += 1.0;
            }
            if (!partialQuery) {
                for (i = 0; i < dataSect.getPoints().size(); ++i) {
                    matchedPoints.add(dataSect.getPoints().get(i));
                }
            }
            if (!(num > 0.0)) continue;
            pointDifferencesCost += sum / num;
        }
        PatternCalculationResult result = new PatternCalculationResult();
        result.setMatch(pointDifferencesCost * 1.0 + rescalingCost * 1.0);
        result.setMatchedPoints(matchedPoints);
        return result;
    }

    public List<Point> sectionStartSubpartPoints(Section section, double width) {
        ArrayList<Point> points = new ArrayList<Point>();
        double startX = section.getPoints().get(0).getX();
        for (int pi = 0; pi < section.getPoints().size(); ++pi) {
            points.add(section.getPoints().get(pi));
            if (section.getPoints().get(pi).getX() - startX >= width) break;
        }
        return points;
    }

    public List<Point> sectionEndSubpartPoints(Section section, double width) {
        ArrayList<Point> points = new ArrayList<Point>();
        double endX = section.getPoints().get(section.getPoints().size() - 1).getX();
        for (int pi = section.getPoints().size() - 1; pi >= 0; --pi) {
            points.add(0, section.getPoints().get(pi));
            if (endX - section.getPoints().get(pi).getX() >= width) break;
        }
        return points;
    }

    public boolean checkQueryLength(double queryLength) {
        if (this.queryLength == null) {
            return true;
        }
        double min2 = this.queryLength - this.queryLength * this.queryLengthTolerance;
        double max = this.queryLength + this.queryLength * this.queryLengthTolerance;
        return queryLength >= min2 && queryLength <= max;
    }

    public boolean checkQueryHeight(double queryHeight) {
        if (this.queryHeight == null) {
            return true;
        }
        double min2 = this.queryHeight - this.queryHeight * this.queryHeightTolerance;
        double max = this.queryHeight + this.queryHeight * this.queryHeightTolerance;
        return queryHeight >= min2 && queryHeight <= max;
    }

    public double calculateMatchHeight(List<Point> matchedPts) {
        double minY = Collections.min(matchedPts, Comparator.comparingDouble(Point::getY)).getOrigY();
        double maxY = Collections.max(matchedPts, Comparator.comparingDouble(Point::getY)).getOrigY();
        return maxY - minY;
    }

    public int searchEqualMatch(PatternResult targetMatch, List<PatternResult> matches) {
        double targetStartX = targetMatch.getPoints().get(0).getX();
        double targetEndX = targetMatch.getPoints().get(targetMatch.getPoints().size() - 1).getX();
        for (int idx = 0; idx < matches.size(); ++idx) {
            if (!(Math.abs(targetStartX - matches.get(idx).getPoints().get(0).getX()) <= 10.0) || !(Math.abs(targetEndX - matches.get(idx).getPoints().get(matches.get(idx).getPoints().size() - 1).getX()) <= 10.0)) continue;
            return idx;
        }
        return -1;
    }

    public boolean areCompatibleSections(List<Section> querySections, List<Section> dataSections, boolean checkLength) {
        if (querySections.size() != dataSections.size()) {
            return false;
        }
        if (this.queryLength != null && checkLength) {
            Section lastDataSection = dataSections.get(dataSections.size() - 1);
            double maxMatchLength = lastDataSection.getPoints().get(lastDataSection.getPoints().size() - 1).getOrigX() - dataSections.get(0).getPoints().get(0).getOrigX() + (double)(this.queryLength * this.queryLengthTolerance);
            double minMatchLength = (dataSections.size() == 1 ? 0.0 : lastDataSection.getPoints().get(0).getOrigX() - dataSections.get(0).getPoints().get(dataSections.get(0).getPoints().size() - 1).getOrigX()) - (double)(this.queryLength * this.queryLengthTolerance);
            if ((double)this.queryLength.longValue() > maxMatchLength || (double)this.queryLength.longValue() < minMatchLength) {
                return false;
            }
        }
        double incompatibleSections = 0.0;
        for (int j = 0; j < querySections.size(); ++j) {
            if (querySections.get(j).getSign() == 0.0 || querySections.get(j).getSign() == dataSections.get(j).getSign()) continue;
            incompatibleSections += 1.0;
        }
        return incompatibleSections / (double)querySections.size() <= 0.5;
    }

    public Bounds getBounds(List<Section> sections, int startSectIdx, int endSectIdx) {
        if (sections == null) {
            return null;
        }
        Bounds bounds = new Bounds();
        bounds.setMinX(sections.get(startSectIdx).getPoints().get(0).getX());
        bounds.setMaxX(sections.get(endSectIdx).getPoints().get(sections.get(endSectIdx).getPoints().size() - 1).getX());
        for (int i = startSectIdx; i < endSectIdx; ++i) {
            Stream<Double> yList = sections.get(i).getPoints().stream().map(Point::getY);
            double localMinY = sections.get(i).getPoints().stream().map(Point::getY).min(Double::compare).orElseGet(() -> 9.223372036854776E18);
            double localMaxY = sections.get(i).getPoints().stream().map(Point::getY).max(Double::compare).orElseGet(() -> 9.223372036854776E18);
            if (localMinY < bounds.getMinY()) {
                bounds.setMinY(localMinY);
            }
            if (!(localMaxY > bounds.getMaxY())) continue;
            bounds.setMaxY(localMaxY);
        }
        return bounds;
    }

    public List<Section> reduceSections(List<Section> sections, int n) {
        if (n >= sections.size() || n < 1) {
            return sections;
        }
        ArrayList<Section> newSections = new ArrayList<Section>(sections);
        while (n < newSections.size()) {
            Integer smallestSection = null;
            double sectionSizeAvg = 0.0;
            for (int i = 0; i < newSections.size(); ++i) {
                sectionSizeAvg += ((Section)newSections.get(i)).sizeEucl();
                if (smallestSection != null && !(((Section)newSections.get(smallestSection)).sizeEucl() > ((Section)newSections.get(i)).sizeEucl())) continue;
                smallestSection = i;
            }
            sectionSizeAvg /= (double)newSections.size();
            if (((Section)newSections.get(smallestSection)).sizeEucl() > sectionSizeAvg * 0.8) {
                return null;
            }
            if (smallestSection == 0) {
                ((Section)newSections.get(0)).concat((Section)newSections.get(1));
                newSections.remove(1);
                continue;
            }
            if (smallestSection == newSections.size() - 1) {
                ((Section)newSections.get(newSections.size() - 2)).concat((Section)newSections.get(newSections.size() - 1));
                newSections.remove(newSections.size() - 1);
                continue;
            }
            if (((Section)newSections.get(smallestSection - 1)).sizeEucl() <= ((Section)newSections.get(smallestSection + 1)).sizeEucl()) {
                ((Section)newSections.get(smallestSection - 1)).concat((Section)newSections.get(smallestSection));
                newSections.remove(newSections.get(smallestSection));
                continue;
            }
            ((Section)newSections.get(smallestSection)).concat((Section)newSections.get(smallestSection + 1));
            newSections.remove(newSections.get(smallestSection + 1));
        }
        return newSections;
    }

    public List<Section> expandSections(List<Section> sections, int n) {
        if (n <= sections.size()) {
            return sections;
        }
        ArrayList<Section> newSections = new ArrayList<Section>(sections);
        for (int i = sections.size(); i <= n; ++i) {
            newSections.add(sections.get(sections.size() - 1));
        }
        return newSections;
    }
}

